/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.scenarios;

import com.dataiku.dip.coremodel.Checklists;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.integrations.IntegrationHook;
import com.dataiku.dip.integrations.IntegrationHooksRegistry;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.recipes.ParamsWithSelectableConnection;
import com.dataiku.dip.recipes.SelectableCodeEnvContainer;
import com.dataiku.dip.recipes.SelectableConnectionContainer;
import com.dataiku.dip.scheduler.ScenarioThread;
import com.dataiku.dip.scheduler.reports.ScenarioReporter;
import com.dataiku.dip.scheduler.scenarios.DelayedTriggersBehavior;
import com.dataiku.dip.scheduler.scenarios.ScenarioParams;
import com.dataiku.dip.scheduler.scenarios.ScenarioRegistry;
import com.dataiku.dip.scheduler.scenarios.StepBasedScenarioRunner;
import com.dataiku.dip.scheduler.steps.SendReportStepRunner;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.scheduler.triggers.TriggerFire;
import com.dataiku.dip.scheduler.triggers.TriggerMeta;
import com.dataiku.dip.scheduler.triggers.TriggerParams;
import com.dataiku.dip.scheduler.triggers.TriggerRegistry;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ScenariosTriggerService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Scenario
extends TaggableObjectsService.TaggableObject
implements SelectableCodeEnvContainer,
SelectableConnectionContainer {
    @JSON.FileTransient
    public String projectKey;
    @JSON.FileTransient
    public String id;
    public String type;
    public String name;
    public boolean active;
    public boolean automationLocal;
    public String runAsUser;
    public DelayedTriggersBehavior delayedTriggersBehavior = new DelayedTriggersBehavior();
    public List<Trigger> triggers = Lists.newArrayList();
    public List<ScenarioReporter> reporters = Lists.newArrayList();
    public ScenarioParams params;
    public boolean markedAsTest;
    private static Logger logger = Logger.getLogger((String)"dku.scenarios");

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.SCENARIO;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isAutomationLocal() {
        return this.automationLocal;
    }

    public String getDescription() {
        return this.description;
    }

    public String getShortDesc() {
        return this.shortDesc;
    }

    public String getRunAsUser() {
        return this.runAsUser;
    }

    public DelayedTriggersBehavior getDelayedTriggersBehavior() {
        return this.delayedTriggersBehavior;
    }

    public List<Trigger> getTriggers() {
        return Lists.newArrayList(this.triggers);
    }

    public List<ScenarioReporter> getReporters() {
        return Lists.newArrayList(this.reporters);
    }

    public ScenarioParams getParams() {
        return this.params;
    }

    public VersionTag getVersionTag() {
        return this.versionTag;
    }

    public VersionTag getCreationTag() {
        return this.creationTag;
    }

    public Checklists getChecklists() {
        return this.checklists;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    public JsonObject getCustomFields() {
        return this.customFields;
    }

    public boolean isMarkedAsTest() {
        return this.markedAsTest;
    }

    public <T extends ScenarioParams> T getParamsAs(Class<T> clazz) {
        return (T)((ScenarioParams)clazz.cast(this.params));
    }

    public ScenarioReporter getReporter(String reporterId) {
        return this.reporters.stream().filter(r -> r.getId().equals(reporterId)).findAny().orElse(null);
    }

    public Step getStep(String stepId) {
        StepBasedScenarioRunner.StepBasedScenarioParams stepParams = this.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class);
        return stepParams.getSteps().stream().filter(r -> r.getId().equals(stepId)).findAny().orElse(null);
    }

    public Scenario withId(String id) {
        this.id = id;
        return this;
    }

    public Scenario withProjectKey(String projectKey) {
        this.projectKey = projectKey;
        return this;
    }

    public Scenario withType(String type) {
        this.type = type;
        return this;
    }

    public Scenario withName(String name) {
        this.name = name;
        return this;
    }

    public Scenario withActive(boolean active) {
        this.active = active;
        return this;
    }

    public Scenario withDescription(String description) {
        this.description = description;
        return this;
    }

    protected Scenario withShortDesc(String shortDesc) {
        this.shortDesc = shortDesc;
        return this;
    }

    public Scenario withRunAsUser(String runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    public Scenario withDelayedTriggersBehavior(DelayedTriggersBehavior delayedTriggersBehavior) {
        this.delayedTriggersBehavior = delayedTriggersBehavior;
        return this;
    }

    public Scenario withTriggers(List<Trigger> triggers) {
        this.triggers = Lists.newArrayList(triggers);
        return this;
    }

    public Scenario withTriggers(Trigger ... triggers) {
        this.triggers = Lists.newArrayList((Object[])triggers);
        return this;
    }

    public Scenario withReporters(List<ScenarioReporter> reporters) {
        this.reporters = Lists.newArrayList(reporters);
        return this;
    }

    public Scenario withReporters(ScenarioReporter ... reporters) {
        this.reporters = Lists.newArrayList((Object[])reporters);
        return this;
    }

    public Scenario withParams(ScenarioParams params) {
        this.params = params;
        return this;
    }

    public Scenario withVersionTag(VersionTag versionTag) {
        this.versionTag = versionTag;
        return this;
    }

    public Scenario withCreationTag(VersionTag creationTag) {
        this.creationTag = creationTag;
        return this;
    }

    public Scenario withChecklists(Checklists checklists) {
        this.checklists = checklists;
        return this;
    }

    public Scenario withTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Scenario withCustomFields(JsonObject customFields) {
        this.customFields = customFields;
        return this;
    }

    @Override
    public List<ParamsWithSelectableCodeEnv> collectCodeEnvUsers() {
        ArrayList codeEnvUsers = Lists.newArrayList();
        if (this.params instanceof SelectableCodeEnvContainer) {
            codeEnvUsers.addAll(((SelectableCodeEnvContainer)((Object)this.params)).collectCodeEnvUsers());
        }
        for (Trigger trigger : this.getTriggers()) {
            TriggerParams params = trigger.getParams();
            if (!(params instanceof ParamsWithSelectableCodeEnv)) continue;
            codeEnvUsers.add((ParamsWithSelectableCodeEnv)((Object)params));
        }
        return codeEnvUsers;
    }

    @Override
    public List<ParamsWithSelectableConnection> collectConnectionUsers() {
        ArrayList connectionUsers = Lists.newArrayList();
        if (this.params instanceof SelectableConnectionContainer) {
            connectionUsers.addAll(((SelectableConnectionContainer)((Object)this.params)).collectConnectionUsers());
        }
        for (Trigger trigger : this.getTriggers()) {
            TriggerParams params = trigger.getParams();
            if (!(params instanceof ParamsWithSelectableConnection)) continue;
            connectionUsers.add((ParamsWithSelectableConnection)((Object)params));
        }
        return connectionUsers;
    }

    public static void registerAdapter() {
        JSON.registerAdapter(Scenario.class, (Object)new JSON.Adapter<Scenario>(){

            public Scenario deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) throws JsonParseException {
                JsonElement jsonMarkedAsTest;
                JsonElement jsonCustomFields;
                JsonElement jsonAutomationLocal;
                JsonElement jsonParams;
                JsonElement jsonReporters;
                JsonElement jsonTriggers;
                JsonElement jsonTags;
                JsonElement jsonDelayedTriggersBehavior;
                JsonElement jsonChecklists;
                JsonElement jsonCreationTag;
                JsonElement jsonVersionTag;
                JsonElement jsonRunAsUser;
                JsonElement jsonShortDesc;
                JsonElement jsonDescription;
                JsonElement jsonName;
                JsonElement jsonId;
                JsonObject jsonObj = json.getAsJsonObject();
                Scenario scenario = new Scenario();
                JsonElement jsonProjectKey = jsonObj.get("projectKey");
                if (jsonProjectKey != null) {
                    scenario = scenario.withProjectKey(jsonProjectKey.getAsString());
                }
                if ((jsonId = jsonObj.get("id")) != null && !jsonId.isJsonNull()) {
                    scenario = scenario.withId(jsonId.getAsString());
                }
                scenario = scenario.withType(jsonObj.get("type").getAsString());
                JsonElement jsonActive = jsonObj.get("active");
                if (jsonActive != null) {
                    scenario = scenario.withActive(jsonActive.getAsBoolean());
                }
                if ((jsonName = jsonObj.get("name")) != null && !jsonName.isJsonNull()) {
                    scenario = scenario.withName(jsonName.getAsString());
                }
                if ((jsonDescription = jsonObj.get("description")) != null && !jsonDescription.isJsonNull()) {
                    scenario = scenario.withDescription(jsonDescription.getAsString());
                }
                if ((jsonShortDesc = jsonObj.get("shortDesc")) != null && !jsonShortDesc.isJsonNull()) {
                    scenario = scenario.withShortDesc(jsonShortDesc.getAsString());
                }
                if ((jsonRunAsUser = jsonObj.get("runAsUser")) != null && !jsonRunAsUser.isJsonNull()) {
                    scenario = scenario.withRunAsUser(jsonRunAsUser.getAsString());
                }
                if ((jsonVersionTag = jsonObj.get("versionTag")) != null && !jsonVersionTag.isJsonNull()) {
                    scenario = scenario.withVersionTag((VersionTag)ctx.deserialize(jsonVersionTag, VersionTag.class));
                }
                if ((jsonCreationTag = jsonObj.get("creationTag")) != null && !jsonCreationTag.isJsonNull()) {
                    scenario = scenario.withCreationTag((VersionTag)ctx.deserialize(jsonVersionTag, VersionTag.class));
                }
                if ((jsonChecklists = jsonObj.get("checklists")) != null && !jsonChecklists.isJsonNull()) {
                    scenario = scenario.withChecklists((Checklists)ctx.deserialize(jsonChecklists, Checklists.class));
                }
                if ((jsonDelayedTriggersBehavior = jsonObj.get("delayedTriggersBehavior")) != null && !jsonDelayedTriggersBehavior.isJsonNull()) {
                    scenario = scenario.withDelayedTriggersBehavior((DelayedTriggersBehavior)ctx.deserialize(jsonDelayedTriggersBehavior, DelayedTriggersBehavior.class));
                }
                if ((jsonTags = jsonObj.get("tags")) != null && !jsonTags.isJsonNull()) {
                    scenario = scenario.withTags((List)ctx.deserialize(jsonTags, List.class));
                }
                if ((jsonTriggers = jsonObj.get("triggers")) != null) {
                    scenario = scenario.withTriggers((List)ctx.deserialize(jsonTriggers, new TypeToken<List<Trigger>>(){}.getType()));
                }
                if ((jsonReporters = jsonObj.get("reporters")) != null) {
                    try {
                        scenario = scenario.withReporters((List)ctx.deserialize(jsonReporters, new TypeToken<List<ScenarioReporter>>(){}.getType()));
                    }
                    catch (IntegrationHooksRegistry.UnknownIntegrationTypeException e) {
                        logger.warn((Object)("Unknown integration, did not deserialize it: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                    }
                }
                if ((jsonParams = jsonObj.get("params")) != null) {
                    scenario = scenario.withParams((ScenarioParams)ctx.deserialize(jsonParams, ScenarioRegistry.getMeta(scenario).paramsClass()));
                }
                if ((jsonAutomationLocal = jsonObj.get("automationLocal")) != null && jsonAutomationLocal.getAsBoolean()) {
                    scenario.automationLocal = true;
                }
                if ((jsonCustomFields = jsonObj.get("customFields")) != null && jsonCustomFields.isJsonObject()) {
                    scenario = scenario.withCustomFields(jsonCustomFields.getAsJsonObject());
                }
                if ((jsonMarkedAsTest = jsonObj.get("markedAsTest")) != null && jsonMarkedAsTest.getAsBoolean()) {
                    scenario.markedAsTest = true;
                }
                return scenario;
            }

            public JsonElement serialize(Scenario scenario, Type type, JsonSerializationContext ctx) {
                JsonObject jsonObj = new JsonObject();
                if (!JSON.excludesFileTransient((JsonSerializationContext)ctx)) {
                    jsonObj.addProperty("projectKey", scenario.getProjectKey());
                    jsonObj.addProperty("id", scenario.getId());
                }
                jsonObj.addProperty("type", scenario.getType());
                jsonObj.addProperty("name", scenario.getName());
                jsonObj.addProperty("active", Boolean.valueOf(scenario.isActive()));
                jsonObj.addProperty("runAsUser", scenario.getRunAsUser());
                jsonObj.addProperty("description", scenario.getDescription());
                jsonObj.addProperty("shortDesc", scenario.getShortDesc());
                jsonObj.add("creationTag", ctx.serialize((Object)scenario.getCreationTag(), VersionTag.class));
                jsonObj.add("versionTag", ctx.serialize((Object)scenario.getVersionTag(), VersionTag.class));
                jsonObj.add("checklists", ctx.serialize((Object)scenario.getChecklists(), Checklists.class));
                jsonObj.add("delayedTriggersBehavior", ctx.serialize((Object)scenario.getDelayedTriggersBehavior(), DelayedTriggersBehavior.class));
                jsonObj.add("tags", ctx.serialize(scenario.getTags(), List.class));
                jsonObj.add("triggers", ctx.serialize(scenario.getTriggers(), new TypeToken<List<Trigger>>(){}.getType()));
                jsonObj.add("reporters", ctx.serialize(scenario.getReporters(), new TypeToken<List<ScenarioReporter>>(){}.getType()));
                if (scenario.getParams() != null) {
                    jsonObj.add("params", ctx.serialize((Object)scenario.getParams(), ScenarioRegistry.getMeta(scenario).paramsClass()));
                }
                jsonObj.addProperty("automationLocal", Boolean.valueOf(scenario.automationLocal));
                if (scenario.getCustomFields() != null) {
                    jsonObj.add("customFields", (JsonElement)scenario.getCustomFields());
                }
                jsonObj.addProperty("markedAsTest", Boolean.valueOf(scenario.isMarkedAsTest()));
                return jsonObj;
            }
        });
    }

    public static class ScenarioListItem
    extends TaggableObjectsService.TaggableListItem {
        public final String type;
        public final String runAsUser;
        public final boolean active;
        public boolean unavailable = false;
        public final boolean automationLocal;
        public final List<TriggerDigestItem> triggerDigestItems = Lists.newArrayList();
        public final List<ReporterDigestItem> reporterDigestItems = Lists.newArrayList();
        public final boolean markedAsTest;
        public String triggerDigest;
        public long nextRun;
        public boolean running;
        public TriggerFire trigger;
        public long start;
        transient Scenario scenario;

        public ScenarioListItem(Scenario scenario) {
            super(scenario);
            this.scenario = scenario;
            this.type = scenario.getType();
            this.runAsUser = scenario.getRunAsUser();
            this.active = scenario.isActive();
            this.automationLocal = scenario.isAutomationLocal();
            this.markedAsTest = scenario.isMarkedAsTest();
        }

        public void computeTriggerDigest_NT(ScenariosTriggerService scenariosTriggerService) throws SQLException {
            TransactionContext.assertNoAttachedTransaction();
            if (this.scenario.getTriggers() != null) {
                for (Trigger trigger : this.scenario.getTriggers()) {
                    TriggerMeta meta = TriggerRegistry.getMeta(trigger);
                    String triggerState = scenariosTriggerService.getTriggerState(this.scenario, trigger);
                    TriggerDigestItem triggerDigestItem = new TriggerDigestItem(trigger.getName(), meta.getDigest(trigger), trigger.isActive(), meta.getExpectedNextRun(trigger, triggerState));
                    this.triggerDigestItems.add(triggerDigestItem);
                }
            }
            StringBuilder sb = new StringBuilder();
            long nextRun = 0L;
            for (TriggerDigestItem triggerDigestItem : this.triggerDigestItems) {
                if (!triggerDigestItem.active) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                if (StringUtils.isNotBlank((String)triggerDigestItem.name)) {
                    sb.append(triggerDigestItem.name);
                } else {
                    sb.append(triggerDigestItem.description);
                }
                if (triggerDigestItem.nextRun <= 0L || nextRun != 0L && triggerDigestItem.nextRun >= nextRun) continue;
                nextRun = triggerDigestItem.nextRun;
            }
            this.nextRun = nextRun;
            this.triggerDigest = sb.toString();
        }

        public void computeReporterDigest_NT() {
            TransactionContext.assertNoAttachedTransaction();
            if (this.scenario.getReporters() != null) {
                for (ScenarioReporter reporter : this.scenario.getReporters()) {
                    IntegrationHook integrationHook = reporter.getMessaging();
                    String properties = "Send on scenario " + reporter.phase.toString();
                    if (reporter.runConditionEnabled && !reporter.getRunCondition().isEmpty()) {
                        properties = properties + " when " + reporter.getRunCondition();
                    }
                    ReporterDigestItem reporterDigestItem = new ReporterDigestItem(reporter.getId(), reporter.getName(), ReporterType.REPORTER.toString(), integrationHook.getType(), this.getChannelId(integrationHook), properties, reporter.isActive());
                    this.reporterDigestItems.add(reporterDigestItem);
                }
            }
            if (this.scenario.getParams() != null && this.scenario.getType().equals(StepBasedScenarioRunner.META.getType())) {
                StepBasedScenarioRunner.StepBasedScenarioParams params = this.scenario.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class);
                for (Step step : params.getSteps()) {
                    if (!step.getType().equals(SendReportStepRunner.META.getType())) continue;
                    SendReportStepRunner.SendReportStepParams stepParams = step.getParamsAs(SendReportStepRunner.SendReportStepParams.class);
                    IntegrationHook integrationHook = stepParams.messaging;
                    ReporterDigestItem reporterDigestItem = new ReporterDigestItem(step.getId(), step.getName(), ReporterType.STEP.toString(), integrationHook.getType(), this.getChannelId(integrationHook), "Send message", step.enabled);
                    this.reporterDigestItems.add(reporterDigestItem);
                }
            }
        }

        private String getChannelId(IntegrationHook integrationHook) {
            JsonObject messagingJson = JSON.toJsonObject((Object)integrationHook.getConfiguration());
            String channelId = null;
            if (messagingJson.has("channelId")) {
                channelId = messagingJson.get("channelId").getAsString();
            }
            return channelId;
        }

        public void setThread(ScenarioThread scenarioThread, boolean full) {
            if (scenarioThread != null) {
                this.running = true;
                this.start = scenarioThread.getScenarioRun().getStart();
                if (full) {
                    this.trigger = scenarioThread.getScenarioRun().getTrigger();
                }
            }
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.SCENARIO;
        }
    }

    public static class ReporterDigestItem {
        public final String id;
        public final String name;
        public final String reporterType;
        public final String messagingType;
        public final String channelId;
        public final String properties;
        public final boolean active;

        public ReporterDigestItem(String id, String name, String reporterType, String messagingType, String channelId, String properties, boolean active) {
            this.id = id;
            this.name = name;
            this.reporterType = reporterType;
            this.messagingType = messagingType;
            this.channelId = channelId;
            this.properties = properties;
            this.active = active;
        }
    }

    public static class TriggerDigestItem {
        public final String name;
        public final String description;
        public final boolean active;
        public final long nextRun;

        TriggerDigestItem(String name, String description, boolean active, DateTime nextRun) {
            this.name = name;
            this.description = description;
            this.active = active;
            this.nextRun = nextRun != null ? nextRun.getMillis() : 0L;
        }
    }

    public static enum ReporterType {
        REPORTER,
        STEP;

    }
}

