/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.scenarios.testing;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.scenarios.TestScenarioRunDTO;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class TestScenarioRunHTMLReportGenerator {
    private TestScenarioRunHTMLReportGenerator() {
    }

    public static String buildHTMLReport(Model model, File output) throws IOException, TemplateException {
        Configuration cfg = TestScenarioRunHTMLReportGenerator.initConfig();
        Template template = cfg.getTemplate("default.ftl");
        try (FileWriter writer = new FileWriter(output);){
            template.process((Object)model.data, (Writer)writer);
            String string = writer.toString();
            return string;
        }
    }

    private static Configuration initConfig() throws IOException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_30);
        cfg.setLocale(Locale.ENGLISH);
        cfg.setNewBuiltinClassResolver(TemplateClassResolver.ALLOWS_NOTHING_RESOLVER);
        cfg.setTemplateLoader((TemplateLoader)new URLTemplateLoader(){

            protected URL getURL(String arg0) {
                throw new RuntimeException("Forbidden");
            }
        });
        cfg.setDirectoryForTemplateLoading(DKUApp.getResourceFile((String[])new String[]{"scenarios", "test-dashbord-report-template"}));
        return cfg;
    }

    private static Map<String, Integer> getCounters(List<TestScenarioRunDTO> scenarioRunDTOs) {
        LinkedHashMap<String, Integer> counters = new LinkedHashMap<String, Integer>();
        for (ReportItem.Outcome outcome : ReportItem.Outcome.values()) {
            counters.put(outcome.name(), 0);
        }
        counters.put("NOT_COMPUTED", 0);
        for (TestScenarioRunDTO scenario : scenarioRunDTOs) {
            ReportItem.Outcome outcome = scenario.getOutcome();
            String key = outcome != null ? scenario.getOutcome().name() : "NOT_COMPUTED";
            counters.put(key, (Integer)counters.get(key) + 1);
        }
        return counters;
    }

    public static class Model {
        public Map data = new HashMap();

        public Model withScenarioRunsInfo(List<TestScenarioRunDTO> scenarioRunDTOs) {
            this.data.put("counters", TestScenarioRunHTMLReportGenerator.getCounters(scenarioRunDTOs));
            this.data.put("totalCount", TestScenarioRunHTMLReportGenerator.getCounters(scenarioRunDTOs).values().stream().reduce(0, Integer::sum));
            this.data.put("scenarioRuns", scenarioRunDTOs);
            return this;
        }

        public Model withGenerationInfo(String projectId, @Nullable String userName) {
            this.data.put("projectId", projectId);
            this.data.put("currentTime", DateTime.now().getMillis());
            if (!StringUtils.isBlank((String)userName)) {
                this.data.put("generatorUserInfo", "by user " + userName);
            } else {
                this.data.put("generatorUserInfo", "by public API key");
            }
            return this;
        }

        public Model withBundleInfo(String bundleId, @Nullable String bundleActivatedOn, @Nullable String bundleActivatedBy) {
            this.data.put("bundleId", bundleId);
            if (bundleActivatedOn != null) {
                this.data.put("activatedOn", DateTime.parse((String)bundleActivatedOn).toDate());
            }
            if (bundleActivatedBy != null) {
                this.data.put("activatedBy", bundleActivatedBy);
            }
            return this;
        }

        public Model withInstanceInfo(String instanceInfo) {
            this.data.put("instanceName", instanceInfo);
            return this;
        }
    }
}

