/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.analysis.coreservices.MLBaseService;
import com.dataiku.dip.analysis.docgen.ModelDocumentGenerationService;
import com.dataiku.dip.analysis.docgen.model.DocumentGenerationResponse;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.managedfolder.KernelsManagedFolderService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateModelDocumentationExportStepRunner
implements StepRunner {
    private final CreateModelDocumentationExportStepParams params;
    private final Scenario scenario;
    private final Step step;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private ManagedFoldersService managedFoldersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private KernelsManagedFolderService kernelsManagedFolderService;
    @Autowired
    private ModelDocumentGenerationService modelDocumentGenerationService;
    @Autowired
    private MLBaseService mlBaseService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.MDGExportStepRunner");

    public CreateModelDocumentationExportStepRunner(Scenario scenario, Step step, CreateModelDocumentationExportStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.info((Object)("Start step " + this.step.name));
        String projectKey = this.scenario.getProjectKey();
        DSSAuthCtx user = stepRun.getScenarioRun().getRunAsUser();
        String fullModelId = this.params.fullModelId;
        ManagedFolder targetMF = null;
        FullModelId fmi = null;
        String modelProjectKey = null;
        try {
            if (this.params.targetFolderId == null) {
                throw new IllegalArgumentException("No target managed folder selected. Select a target managed folder to store the result of the export or remove this step.");
            }
            if (!(this.params.defaultTemplate || this.params.sourceFolderId != null && this.params.templatePath != null)) {
                throw new IllegalArgumentException("No custom template selected. Select a custom template or use default template.");
            }
            targetMF = this.getManagedFolder(projectKey, this.params.targetFolderId);
            if (fullModelId == null) {
                throw new IllegalArgumentException("No model selected. Select a model or remove this step.");
            }
            logger.info((Object)"Get full model version");
            fmi = this.getFullModelId_NT(projectKey, fullModelId);
            fullModelId = fmi.toString();
            modelProjectKey = fmi.getProjectKey();
            if (modelProjectKey == null) {
                throw new IllegalArgumentException("Unknown source project for selected model. Select a different model or remove this step.");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to prepare model doc", (Throwable)ex);
            stepReportItem.withOutcome(ReportItem.Outcome.FAILED).withThrown(ex);
            return;
        }
        logger.info((Object)"Get MDG template");
        File templateFile = this.modelDocumentGenerationService.getTemplate(this.params.defaultTemplate, fullModelId, user, projectKey, this.params.sourceFolderId, this.params.templatePath);
        ReportTargetItem.ModelDocumentationExportItem target = new ReportTargetItem.ModelDocumentationExportItem(projectKey, fullModelId, this.params.targetFolderId, targetMF.name, this.params.mlTaskType);
        ReportItem item = new ReportItem.CreatedModelDocumentExport(target).withStart(System.currentTimeMillis());
        ReportItem.CreatedModelDocumentExport reportItem = (ReportItem.CreatedModelDocumentExport)item;
        try {
            logger.info((Object)"Start MDG");
            DocumentGenerationResponse mdgResponse = this.modelDocumentGenerationService.getMdgResponse(user, modelProjectKey, new FileInputStream(templateFile), fmi);
            File outputFile = this.modelDocumentGenerationService.getMdgFile(mdgResponse);
            if (outputFile == null) {
                throw new FileNotFoundException("Generated file not found");
            }
            if (this.params.withTimestamp) {
                outputFile = this.appendFileTimestamp(outputFile);
            }
            logger.info((Object)"Transfer file to managed folder");
            try {
                String exportPath = File.separator + outputFile.getName();
                try (FileInputStream exportFileStream = new FileInputStream(outputFile);){
                    this.kernelsManagedFolderService.handleUploadRequest_NT(targetMF.projectKey, targetMF.id, exportFileStream, exportPath, true, stepRun.getScenarioRun().getRunAsUser());
                }
            }
            finally {
                this.modelDocumentGenerationService.clean(outputFile);
            }
            logger.info((Object)"Model documentation successfully exported");
            reportItem.withEnd(DateTime.now().getMillis());
            if (mdgResponse.data.warning) {
                SmartLogTail logTail = new SmartLogTail();
                logTail.appendLine(mdgResponse.data.report());
                reportItem.withOutcome(ReportItem.Outcome.WARNING).withLogTail(logTail);
            } else {
                reportItem.withOutcome(ReportItem.Outcome.SUCCESS);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to create model doc", (Throwable)ex);
            reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED);
            stepReportItem.withThrown(ex);
        }
        finally {
            this.jobsDatabaseService.tryRegisterFlowObjectEvent(new AnyLoc(projectKey, fullModelId), null, null, stepRun.getScenarioRun(), stepRun, reportItem);
        }
        stepReportItem.outcome = reportItem.getOutcome();
        logger.info((Object)("Done step " + this.step.name));
    }

    private ManagedFolder getManagedFolder(String projectKey, String folderId) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            ManagedFolder managedFolder = this.managedFoldersService.getMandatory(projectKey, folderId);
            return managedFolder;
        }
    }

    private FullModelId getFullModelId_NT(String projectKey, String fullModelId) throws IOException {
        FullModelId fmi = null;
        if (ModelDocumentGenerationService.isModelDocumentationConstant(fullModelId)) {
            if (this.params.modelId != null) {
                fmi = this.modelDocumentGenerationService.getSavedModelFMI_NT(projectKey, this.params.modelId, fullModelId);
            } else if (this.params.analysisId != null) {
                MLTaskLoc loc = new MLTaskLoc(projectKey, this.params.analysisId, this.params.mlTaskId);
                fmi = this.mlBaseService.getLatestModelId(loc);
            }
        } else {
            fmi = FullModelId.parse(fullModelId);
        }
        if (fmi == null || !fmi.exists()) {
            throw new IllegalArgumentException("Unknown model version: " + projectKey + "." + fullModelId + " Select a different model or remove this step.");
        }
        return fmi;
    }

    private File appendFileTimestamp(File f) throws IOException {
        Object newFilename = f.getName().replace(".docx", "");
        newFilename = (String)newFilename + new SimpleDateFormat("' - 'yyyyMMdd'-'HHmm'.docx'").format(new Date());
        File outputFileStamped = new File(f.getParent(), (String)newFilename);
        Files.move(f.toPath(), outputFileStamped.toPath(), new CopyOption[0]);
        return outputFileStamped;
    }

    public static class CreateModelDocumentationExportStepParams
    extends NonFatalStepParams
    implements StepParams {
        public String fullModelId;
        private boolean withTimestamp;
        private String targetFolderId;
        private boolean defaultTemplate;
        private String sourceFolderId;
        private String templatePath;
        private String analysisId;
        private String modelId;
        private String mlTaskId;
        private String mlTaskType;

        public CreateModelDocumentationExportStepParams withFullModelId(String fullModelId) {
            this.fullModelId = fullModelId;
            return this;
        }

        public CreateModelDocumentationExportStepParams withDefaultTemplate(boolean defaultTemplate) {
            this.defaultTemplate = defaultTemplate;
            return this;
        }

        public CreateModelDocumentationExportStepParams withSourceFolderId(String sourceFolderId) {
            this.sourceFolderId = sourceFolderId;
            return this;
        }

        public CreateModelDocumentationExportStepParams withTimestamp(boolean withTimestamp) {
            this.withTimestamp = withTimestamp;
            return this;
        }

        public CreateModelDocumentationExportStepParams withTargetFolderId(String targetFolderId) {
            this.targetFolderId = targetFolderId;
            return this;
        }
    }
}

