/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scoring.exports;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.model.CompatibilityWithReason;
import com.dataiku.dip.scoring.exports.ScoringExporter;
import com.dataiku.dip.scoring.exports.pmml.PMML;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.PathUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class PMMLScoring
implements ScoringExporter.ScoringWriter {
    public static final String CONTENT_TYPE = "application/xml";
    private FullModelId fullModelId;

    public PMMLScoring(FullModelId fullModelId) {
        this.fullModelId = fullModelId;
    }

    @Override
    public CompatibilityWithReason getCompatibility() throws IOException {
        return PredictionResultsReader.makeDetails((FullModelId)this.fullModelId).pmmlCompatibility;
    }

    @Override
    public String makeFileName() throws IOException {
        return PathUtils.slugify((String)this.fullModelId.getHeadMLTask().name) + ".pmml";
    }

    @Override
    public String getContentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void writeTo(OutputStream os) throws Exception {
        try (AutoDelete tmpResources = DSSTempUtils.getTempFolder((String)"model-export", (String)"model");){
            ScoringExporter.copyResourcesFromFMI((File)tmpResources, this.fullModelId);
            PMML.fromModelResources((File)tmpResources).writeToStream(os);
        }
    }
}

