/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.GitReferencesService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.git.cli.GitRemoteCommands;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class GitController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GitReferencesService gitReferencesService;

    @AuditedCall(value={"msgType", "list-git-remote-references"})
    @RequestMapping(value={"/api/git/list-remote-references"}, method={RequestMethod.POST})
    public void listRemoteRefs(HttpServletRequest req, HttpServletResponse resp, @RequestParam String repository, @RequestParam(required=false) String login, @RequestParam(required=false) String password) throws Exception {
        AuthCtx user;
        try (Transaction ignored = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
        }
        List<String> refs = new GitRemoteCommands(null).listRefs(user, this.gitReferencesService.mkRemoteURL(repository, login, password));
        GitController.writeJSON((HttpServletResponse)resp, refs);
    }
}

