/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dashboards.DashboardsService;
import com.dataiku.dip.dashboards.DashboardsUtils;
import com.dataiku.dip.dashboards.insights.InsightsService;
import com.dataiku.dip.dashboards.insights.staticfile.StaticFileInsightMeta;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.dashboards.model.DashboardPage;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.dashboards.model.Tile;
import com.dataiku.dip.dashboards.model.ui.EnrichedDashboardPage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.TagFilterUtils;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.EncodedContent;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class InsightsController
extends DIPInternalControllerBase {
    @Autowired
    private InsightsService insightsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private DashboardsService dashboardsService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private AuditTrailService auditTrailService;
    private static final Logger logger = Logger.getLogger((String)"dku.insights.controller");

    @AuditedCall(value={"msgType", "insight-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/dashboards/insights/list"})
    public void list(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            List<Insight> allInsights = this.insightsService.listUnsafe(projectKey);
            ArrayList<Insight> insights = new ArrayList<Insight>(allInsights.size());
            for (Insight insight : allInsights) {
                if (!this.insightsService.isUserAwareOfInsight(insight, user)) continue;
                insights.add(insight);
            }
            InsightsController.writeJSON((HttpServletResponse)resp, insights);
        }
    }

    @AuditedCall(value={"msgType", "insight-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/dashboards/insights/list-with-access-state"})
    public void listWithAccessInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        InsightListWithAccessStates ret = new InsightListWithAccessStates();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            List<Insight> allInsights = this.insightsService.listUnsafe(projectKey);
            for (Insight insight : allInsights) {
                if (!this.insightsService.isVisibleToUser(insight, user) || !this.insightsService.hasInsightReadPermission(user, insight)) continue;
                ret.insights.add(insight);
                ret.insightAccessData.put(insight.id, this.insightsService.getInsightAccessState(insight));
            }
            InsightsController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "insight-list", "projectKey", "${projectKey}", "tagFilter", "${tagFilter}"})
    @RequestMapping(value={"/api/dashboards/insights/list-heads"})
    public void listHeads(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false) String tagFilter) throws Exception {
        AuthCtx user;
        TaggableObjectsService.FilteredTaggableItems heads = new TaggableObjectsService.FilteredTaggableItems();
        TagFilterUtils.TagFilter tf = (TagFilterUtils.TagFilter)JSON.parse((String)tagFilter, TagFilterUtils.TagFilter.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            HashMap<String, Insight.InsightListItem> dic = new HashMap<String, Insight.InsightListItem>();
            for (Insight insight : this.insightsService.listUnsafe(projectKey)) {
                try {
                    if (!this.insightsService.isVisibleToUser(insight, user)) continue;
                    if (!TagFilterUtils.matches(tf, insight)) {
                        ++heads.filteredOut;
                        continue;
                    }
                    Insight.InsightListItem listItem = new Insight.InsightListItem(insight);
                    listItem.accessState = this.insightsService.getInsightAccessState(insight);
                    UsersService.UIUser owner = this.usersService.getUserOrNull_NoLeak(listItem.owner);
                    listItem.ownerDisplayName = owner != null ? owner.displayName : null;
                    this.taggableObjectsService.setEditionInfoFromTags(insight, listItem);
                    heads.items.add(listItem);
                    dic.put(insight.id, listItem);
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to read insight", (Throwable)e);
                }
            }
            for (Dashboard dashboard : this.dashboardsService.listUnsafe(projectKey)) {
                for (DashboardPage page : dashboard.pages) {
                    for (Tile tile : page.getFlattenedTileList()) {
                        Insight.InsightListItem insight;
                        if (tile.tileType == Tile.TileType.INSIGHT && (insight = (Insight.InsightListItem)dic.get(tile.insightId)) != null) {
                            insight.dashboardsIdsPinnedOn.add(dashboard.id);
                            if (dashboard.listed) {
                                insight.listedDashboardsIdsPinnedOn.add(dashboard.id);
                            }
                        }
                        if (tile.clickAction != Tile.TileClickAction.OPEN_OTHER_INSIGHT || (insight = (Insight.InsightListItem)dic.get(tile.targetInsightId)) == null) continue;
                        insight.dashboardsIdsLinkedFrom.add(dashboard.id);
                        if (!dashboard.listed) continue;
                        insight.listedDashboardsIdsLinkedFrom.add(dashboard.id);
                    }
                }
            }
        }
        this.interestsService.enrichHeads(user.getAssociatedDSSUser(), projectKey, heads.items);
        InsightsController.writeJSON((HttpServletResponse)resp, heads);
    }

    @AuditedCall(value={"msgType", "insight-read-meta", "projectKey", "${projectKey}", "insightId", "${insightId}"})
    @RequestMapping(value={"/api/dashboards/insights/get"})
    public void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String insightId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDashboardReadPermission(user, new SmartObjectRef(ITaggingService.TaggableType.INSIGHT, insightId), projectKey);
            Insight insight = this.insightsService.getMandatoryUnsafe(projectKey, insightId);
            if (!this.insightsService.hasInsightReadPermission(user, insight)) {
                throw new SecurityException("You do not have the required permissions to access this insight");
            }
            InsightsController.writeJSON((HttpServletResponse)resp, (Object)insight);
        }
    }

    @AuditedCall(value={"msgType", "insight-read-meta", "projectKey", "${projectKey}", "insightId", "${insightId}"})
    @RequestMapping(value={"/api/dashboards/insights/get-full-info"})
    public void getFullInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String insightId) throws Exception {
        NavigatorService.InsightFullInfo info;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDashboardReadPermission(u, new SmartObjectRef(ITaggingService.TaggableType.INSIGHT, insightId), projectKey);
            info = this.navigatorService.getInsightFullInfo(projectKey, insightId, u);
        }
        this.navigatorService.addInfo_NT(info, u);
        InsightsController.writeJSON((HttpServletResponse)resp, (Object)info);
    }

    @AuditedCall(value={"msgType", "insight-read-meta", "projectKey", "${projectKey}", "insightId", "${insightId}"})
    @RequestMapping(value={"/api/dashboards/insights/get-with-payload"})
    public void getWithPayload(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String insightId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDashboardReadPermission(user, new SmartObjectRef(ITaggingService.TaggableType.INSIGHT, insightId), projectKey);
            InsightWithPayload insightWithPayload = new InsightWithPayload();
            insightWithPayload.insight = this.insightsService.getMandatoryUnsafe(projectKey, insightId);
            if (!this.insightsService.hasInsightReadPermission(user, insightWithPayload.insight)) {
                throw new SecurityException("You do not have the required permissions to access this insight");
            }
            insightWithPayload.payload = this.insightsService.getPayload(insightWithPayload.insight);
            InsightsController.writeJSON((HttpServletResponse)resp, (Object)insightWithPayload);
        }
    }

    @AuditedCall(value={"msgType", "insight-read-meta", "projectKey", "${projectKey}", "insightId", "${insightId}"})
    @RequestMapping(value={"/api/dashboards/insights/get-summary"})
    public void getSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String insightId) throws Exception {
        AuthCtx authCtx;
        TaggableObjectsService.TaggableObjectSummary summary = new TaggableObjectsService.TaggableObjectSummary();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.failIfNoDashboardReadPermission(authCtx, new SmartObjectRef(ITaggingService.TaggableType.INSIGHT, insightId), projectKey);
            summary.object = this.insightsService.getMandatoryUnsafe(projectKey, insightId);
        }
        summary.timeline = this.timelinesService.getObjectTimeline_NT(summary.object, 0, 100);
        summary.interest = this.interestsService.getObjectAndUserInterest_noFail(authCtx, summary.object);
        InsightsController.writeJSON((HttpServletResponse)resp, (Object)summary);
    }

    @AuditedCall(value={"msgType", "insight-copy", "projectKey", "${projectKey}", "insightIds", "${insightIds}", "names", "${names}"})
    @RequestMapping(value={"/api/dashboards/insights/copy"})
    public void copy(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String insightIds, @RequestParam String names, @RequestParam(required=false) String dashboardId) throws Exception {
        ArrayList<Insight> insightCopyList = new ArrayList<Insight>();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS);
            String[] insightIdList = (String[])JSON.parse((String)insightIds, String[].class);
            String[] insightNameList = (String[])JSON.parse((String)names, String[].class);
            for (int i = 0; i < insightNameList.length; ++i) {
                String insightId = insightIdList[i];
                String insightName = insightNameList[i];
                Insight insightCopy = this.insightsService.copy(projectKey, insightId, insightName, dashboardId, user.getIdentifier());
                insightCopyList.add(insightCopy);
            }
            t.commitV("Copying %s insights in project %s.", new Object[]{insightCopyList.size(), projectKey});
        }
        InsightsController.writeJSON((HttpServletResponse)resp, insightCopyList);
    }

    @AuditInline
    @RequestMapping(value={"/api/dashboards/insights/save"})
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam String insightData, @RequestParam(required=false) String commitMessage, @RequestParam(required=false) String payload) throws Exception {
        Insight insight = (Insight)JSON.parse((String)insightData, Insight.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            SerializedProject project = this.projectsService.getMandatoryUnsafe(insight.projectKey);
            this.projectsService.checkPerm(user, project.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS);
            Insight existing = StringUtils.isBlank((String)insight.id) ? null : this.insightsService.getMandatoryUnsafe(insight.projectKey, insight.id);
            String insightId = "";
            if (existing == null) {
                this.insightsService.setIdAndOwnerOnNewInsight(insight, user);
                insightId = insight.id;
            } else {
                if (!StringUtils.equals((String)existing.owner, (String)insight.owner)) {
                    this.projectsService.checkPerm(user, project.projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
                }
                if (!(project.permissionsVersion != SerializedProject.PermissionsVersion.LEGACY || StringUtils.equals((String)existing.owner, (String)user.getIdentifier()) && existing.listed == insight.listed)) {
                    this.projectsService.checkPerm(user, project.projectKey, Privileges.ProjectLevelPrivilegeType.MODERATE_DASHBOARDS);
                }
                insight.owner = existing.owner;
            }
            this.insightsService.save(insight, existing == null, payload);
            InsightsController.writeJSON((HttpServletResponse)resp, (Object)insightId);
            if (StringUtils.isNotBlank((String)commitMessage)) {
                t.commit(commitMessage, 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
            } else {
                t.commit(String.format("Saved insight %s (%s.%s)", insight.name, insight.projectKey, insight.id), 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
            }
            this.auditTrailService.generic("insight-save").with("projectKey", insight.projectKey).with("insightId", insight.id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("insight-save", (Throwable)e).with("projectKey", insight.projectKey).with("insightId", insight.id).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/dashboards/insights/create-and-pin"})
    public void createAndPin(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String insightData, @RequestParam String tileData, @RequestParam String pinningOrdersData, @RequestParam(required=false) String payloadsData) throws Exception {
        ArrayList insightIds = new ArrayList();
        Insight[] insightList = (Insight[])JSON.parse((String)insightData, Insight[].class);
        String[] payloads = null;
        payloads = StringUtils.isNotBlank((String)payloadsData) ? (String[])JSON.parse((String)payloadsData, String[].class) : new String[insightList.length];
        String displayableInsightsIds = "";
        StringBuilder sb = new StringBuilder();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            DashboardsUtils.PinningOrder[] pinningOrdersList = (DashboardsUtils.PinningOrder[])JSON.parse((String)pinningOrdersData, DashboardsUtils.PinningOrder[].class);
            Tile[][] tileList = (Tile[][])JSON.parse((String)tileData, Tile[][].class);
            SerializedProject project = this.projectsService.getMandatoryUnsafe(insightList[0].projectKey);
            this.projectsService.checkPerm(user, project.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS);
            for (int i = 0; i < insightList.length; ++i) {
                insightIds.add(new ArrayList());
                for (int k = 0; k < pinningOrdersList.length; ++k) {
                    Insight insight = insightList[i];
                    Tile tile = tileList[k][i];
                    String payload = payloads[i];
                    insight.dashboardCreationId = pinningOrdersList[k].dashboardId;
                    insight.id = null;
                    this.insightsService.setIdAndOwnerOnNewInsight(insight, user);
                    this.insightsService.save(insight, true, payload);
                    tile.insightId = insight.id;
                    this.dashboardsService.addToDashboard(pinningOrdersList[k], tile, projectKey);
                    ((ArrayList)insightIds.get(i)).add(insight.id);
                }
                if (pinningOrdersList.length == 0) {
                    this.insightsService.setIdAndOwnerOnNewInsight(insightList[i], user);
                    this.insightsService.save(insightList[i], true, payloads[i]);
                    ((ArrayList)insightIds.get(i)).add(insightList[i].id);
                }
                sb.append(DashboardsUtils.getMultiPinInsightsId(projectKey, insightList[i].name, (List)insightIds.get(i)) + ", ");
            }
            if (pinningOrdersList.length > 0) {
                String displayableDashboardsIds = DashboardsUtils.getMultiPinDashboardsId(projectKey, pinningOrdersList, false);
                displayableInsightsIds = sb.toString();
                t.commitV("Saved and pinned insights %s on dashboards %s", new Object[]{displayableInsightsIds, displayableDashboardsIds});
            } else {
                t.commitV("Created insights from top level objects %s on project %s", new Object[]{displayableInsightsIds, projectKey});
            }
            this.auditTrailService.generic("insight-pin").with("projectKey", insightList[0].projectKey).with("insightId", insightList[insightList.length - 1].id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("insight-pin", (Throwable)e).with("projectKey", insightList[0].projectKey).with("insightId", insightList[0].id).emit();
            throw e;
        }
        InsightsController.writeJSON((HttpServletResponse)resp, insightIds);
    }

    @AuditInline
    @RequestMapping(value={"/api/dashboards/insights/make-listed"})
    public void makeListed(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String insightIds, @RequestParam boolean listed) throws Exception {
        String[] insightIdList = (String[])JSON.parse((String)insightIds, String[].class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            SerializedProject project = this.projectsService.getMandatoryUnsafe(projectKey);
            this.projectsService.checkPerm(user, projectKey, project.permissionsVersion == SerializedProject.PermissionsVersion.LEGACY ? Privileges.ProjectLevelPrivilegeType.MODERATE_DASHBOARDS : Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS);
            for (String insightId : insightIdList) {
                this.insightsService.makeListed(projectKey, insightId, listed);
                this.auditTrailService.generic("insight-make-listed").with("projectKey", projectKey).with("insightId", insightId).emit();
            }
            String listedLabel = listed ? "public" : "private";
            String insightLabel = insightIdList.length > 1 ? "insights" : "insight";
            t.commitV("Made %d %s %s in project %s: %s", new Object[]{insightIdList.length, insightLabel, listedLabel, projectKey, insightIds});
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/dashboards/insights/get-missing-reader-authorizations"})
    public void getMissingReaderAuthorizations(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String insightIds) throws Exception {
        ArrayList ret;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            String[] insightIdList = (String[])JSON.parse((String)insightIds, String[].class);
            HashMap<Integer, SerializedProject.ReaderAuthorization> missingReaderAuthorizationsMap = new HashMap<Integer, SerializedProject.ReaderAuthorization>();
            for (String insightId : insightIdList) {
                Insight insight = this.insightsService.getMandatoryUnsafe(projectKey, insightId);
                if (!this.insightsService.hasInsightReadPermission(user, insight)) {
                    throw new SecurityException("You do not have the permission to view this insight");
                }
                List<SerializedProject.ReaderAuthorization> missingReaderAuthorizations = this.insightsService.getMissingReaderAuthorizations(insight);
                for (SerializedProject.ReaderAuthorization mra : missingReaderAuthorizations) {
                    Integer key = mra.objectRef.hashCode();
                    SerializedProject.ReaderAuthorization mergeMra = (SerializedProject.ReaderAuthorization)missingReaderAuthorizationsMap.get(key);
                    if (mergeMra != null) {
                        mergeMra.modes.addAll(mra.modes);
                        continue;
                    }
                    mra.objectRef = this.taggableObjectsReadService.enrichSmartObjectRef(mra.objectRef, projectKey);
                    missingReaderAuthorizationsMap.put(key, mra);
                }
                this.auditTrailService.generic("insight-read-meta").with("projectKey", projectKey).with("insightId", insightId).emit();
            }
            ret = new ArrayList(missingReaderAuthorizationsMap.values());
        }
        InsightsController.writeJSON((HttpServletResponse)resp, ret);
    }

    @AuditedCall(value={"msgType", "insight-view", "projectKey", "${projectKey}", "insightId", "${insightId}"})
    @RequestMapping(value={"/api/dashboards/insights/view-static-file"}, method={RequestMethod.GET})
    public void viewStaticFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String insightId, @RequestParam(required=false, defaultValue="false") boolean download) throws Exception {
        String contentType;
        byte[] content;
        Insight insight;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = download ? this.authService.getMandatoryUserNoXSRF(req) : this.authService.getMandatoryUser(req);
            insight = this.insightsService.getMandatoryUnsafe(projectKey, insightId);
            if (!this.insightsService.hasInsightReadPermission(user, insight)) {
                throw new SecurityException("You do not have the required permissions to access this insight");
            }
            if (!"static_file".equals(insight.type)) {
                throw ErrorContext.iae((String)"This insight is not a static file");
            }
        }
        try (InputStream is = this.insightsService.streamStaticContent(insight);){
            StaticFileInsightMeta.StaticFileInsightParams params = (StaticFileInsightMeta.StaticFileInsightParams)insight.params;
            if (download) {
                resp.setHeader("Content-Disposition", "attachment; filename=\"" + insight.getDisplayName() + "\"");
                IOUtils.copy((InputStream)is, (OutputStream)resp.getOutputStream());
                return;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)bos);
            content = bos.toByteArray();
            contentType = params.contentType;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Static insight data not found", (Throwable)e);
            content = "File not found.".getBytes();
            contentType = "text/html";
        }
        InsightsController.writeJSON((HttpServletResponse)resp, (Object)new EncodedContent(content, contentType));
    }

    public class InsightListWithAccessStates {
        List<Insight> insights = new ArrayList<Insight>();
        Map<String, EnrichedDashboardPage.InsightAccessState> insightAccessData = new HashMap<String, EnrichedDashboardPage.InsightAccessState>();
    }

    static class InsightWithPayload {
        Insight insight;
        String payload;

        InsightWithPayload() {
        }
    }
}

