/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.api.auth.PublicAPIKeysService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PublicAPIKeysWebAppsController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private PublicAPIKeysService apiKeyService;
    @Autowired
    private TransactionService transactionService;
    private static Logger logger = Logger.getLogger((String)"dip.controllers.queries");

    @AuditedCall(value={"msgType", "project-apikey-get-privileges-for-webapp"})
    @RequestMapping(value={"/api/webapps/get-apikey-dataset-privileges"})
    public void getList(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String keyId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx liu = this.authService.getMandatoryUser(req);
            PublicAPIKeysService.WebAppDatasetLevelPermissions permissions = this.apiKeyService.getDatasetLevelPermissions(liu, projectKey, keyId);
            PublicAPIKeysWebAppsController.writeJSON((HttpServletResponse)resp, (Object)permissions);
        }
    }

    @AuditedCall(value={"msgType", "project-apikey-set-privileges-for-webapp"})
    @RequestMapping(value={"/api/webapps/set-apikey-dataset-privileges"})
    public void setList(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String keyId, @RequestParam String data) throws Exception {
        PublicAPIKeysService.WebAppDatasetLevelPermissions perms = (PublicAPIKeysService.WebAppDatasetLevelPermissions)JSON.parse((String)data, PublicAPIKeysService.WebAppDatasetLevelPermissions.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx liu = this.authService.getMandatoryUser(req);
            this.apiKeyService.setDatasetLevelPermissions(liu, projectKey, keyId, perms);
            t.commit("Updated dataset-level permissions for webapp API key in project " + projectKey);
        }
    }
}

