/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.PluginStoreService;
import com.dataiku.dip.requestcenter.Request;
import com.dataiku.dip.requestcenter.RequestsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api/requests"})
public class RequestsController
extends DIPInternalControllerBase {
    private static final int REQUEST_MESSAGE_SIZE_LIMIT = 1000;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private RequestsService requestsService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private PluginStoreService pluginStoreService;
    @Autowired
    private IPluginsRegistryService pluginsRegistry;
    @Autowired
    private UsersDAO usersDAO;

    @AuditedCall(value={"msgType", "requests-center-requests-list"})
    @RequestMapping(value={"/"})
    public void listRequests(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false, defaultValue="{}") String facets, @RequestParam(required=false, defaultValue="0") int offset, @RequestParam(required=false, defaultValue="50") int limit) throws IOException, SQLException {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        Map facetsMap = (Map)JSON.parse((String)facets, (TypeToken)new TypeToken<Map<String, List<String>>>(){});
        RequestsController.writeJSON((HttpServletResponse)resp, (Object)this.requestsService.search(authCtx, facetsMap, offset, limit));
    }

    @AuditedCall(value={"msgType", "requests-center-request-get", "requestId", "${requestId}"})
    @RequestMapping(value={"/get-request"})
    public void getRequest(HttpServletRequest req, HttpServletResponse resp, @RequestParam String requestId) throws IOException, CodedSQLException, DKUSecurityException {
        Request request = this.requestsService.getRequestOrNull(requestId);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (!this.requestsService.authorizedToReadRequest(authCtx, request)) {
                throw new NotFoundException("Request not found or not authorized to read it: " + requestId);
            }
        }
        RequestsController.writeJSON((HttpServletResponse)resp, (Object)request);
    }

    @AuditedCall(value={"msgType", "requests-center-request-get-latest", "objectProjectKey", "${objectProjectKey}", "objectType", "${objectType}", "objectId", "${objectId}"})
    @RequestMapping(value={"/get-latest-object-request-for-user"})
    public void getLatestObjectRequestForUser(HttpServletRequest req, HttpServletResponse resp, @RequestParam String objectId, @RequestParam Request.RequestObjectType objectType, @RequestParam String objectProjectKey) throws Exception {
        Request request;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        Request.RequestType requestType = objectType.getDefaultRequestType();
        if (requestType.isAccessRequest()) {
            request = this.requestsService.getLatestProjectObjectRequestForUser(authCtx.getAssociatedDSSUser(), objectProjectKey, objectType, objectId, false);
        } else if (requestType.isPluginRequest() || requestType.isCodeEnvRequest()) {
            request = this.requestsService.getLatestObjectRequestForUser(authCtx.getAssociatedDSSUser(), objectType, objectId, false);
        } else if (requestType.isInstanceAccessRequest() || requestType.isProfileUpgradeRequest()) {
            request = this.requestsService.getLatestPendingRequestForRequestType(authCtx.getAssociatedDSSUser(), requestType, false);
        } else {
            throw new IllegalArgumentException("Cannot check latest object request for user for request type : " + String.valueOf((Object)requestType));
        }
        if (request == null) {
            RequestsController.send404((String)String.format("User has made no requests of type %s for object with id %s", new Object[]{objectType, objectId}), (HttpServletResponse)resp);
        } else {
            RequestsController.writeJSON((HttpServletResponse)resp, (Object)request);
        }
    }

    @AuditInline
    @RequestMapping(value={"/approve"})
    public void approve(HttpServletRequest req, HttpServletResponse resp, @RequestParam String requestId, @RequestParam RequestsService.RequestResponse requestResponse, @RequestParam(required=false) String closingMessage) throws IOException, SQLException, DKUSecurityException, LimitsStatusComputer.LicenseLimitException, CodedException {
        Request request = this.requestsService.getRequestOrNull(requestId);
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                if (!this.requestsService.authorizedToReadRequest(authCtx, request)) {
                    throw new NotFoundException("Request not found or not authorized to read it: " + requestId);
                }
                this.requestsService.checkResponseAllowed(authCtx, request, requestResponse);
                this.requestsService.checkRequestUnanswered(request);
            }
            this.requestsService.performChangesForApprovedRequest_NT(authCtx, request, requestResponse);
            this.requestsService.approve(request, authCtx.getAssociatedDSSUser(), closingMessage);
            this.auditTrailService.generic("requests-center-request-approve").with("requestId", requestId).with("requesterLogin", request.requesterLogin).with("requestType", request.requestType.toString()).with("objectProjectKey", request.objectProjectKey).with("objectType", request.objectType.toString()).with("objectId", request.objectId).withAll(JSON.toJsonObjectExcept((Object)requestResponse, (String[])new String[]{"type"})).emit();
        }
        catch (Exception e) {
            AuditTrailService.EmittableAuditObj auditObj = this.auditTrailService.failure("requests-center-request-approve", (Throwable)e).with("requestId", requestId).withAll(JSON.toJsonObjectExcept((Object)requestResponse, (String[])new String[]{"type"}));
            if (request != null) {
                auditObj.with("requesterLogin", request.requesterLogin).with("requestType", request.requestType.toString()).with("objectProjectKey", request.objectProjectKey).with("objectType", request.objectType.toString()).with("objectId", request.objectId);
            }
            auditObj.emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/reject"})
    public void reject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String requestId, @RequestParam(required=false) String closingMessage) throws IOException, SQLException, DKUSecurityException, CodedException {
        Request request = this.requestsService.getRequestOrNull(requestId);
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                if (!this.requestsService.authorizedToReadRequest(authCtx, request)) {
                    throw new NotFoundException("Request not found or not authorized to read it: " + requestId);
                }
                this.requestsService.checkRequestUnanswered(request);
            }
            this.requestsService.reject(request, authCtx.getAssociatedDSSUser(), closingMessage);
            this.auditTrailService.generic("requests-center-request-reject").with("requestId", requestId).with("requesterLogin", request.requesterLogin).with("requestType", request.requestType.toString()).with("objectProjectKey", request.objectProjectKey).with("objectType", request.objectType.toString()).with("objectId", request.objectId).emit();
        }
        catch (Exception e) {
            AuditTrailService.EmittableAuditObj auditObj = this.auditTrailService.failure("requests-center-request-reject", (Throwable)e).with("requestId", requestId);
            if (request != null) {
                auditObj.with("requesterLogin", request.requesterLogin).with("requestType", request.requestType.toString()).with("objectProjectKey", request.objectProjectKey).with("objectType", request.objectType.toString()).with("objectId", request.objectId);
            }
            auditObj.emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/create-access-request"})
    public void createAccessRequest(HttpServletRequest req, HttpServletResponse resp, @RequestParam Request.RequestObjectType objectType, @RequestParam String objectProjectKey, @RequestParam String objectId, @RequestParam(required=false) String requestMessage) throws IOException, CodedSQLException {
        Request.RequestType requestType;
        String login;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            login = authCtx.getAssociatedDSSUser();
            requestType = objectType.getDefaultRequestType();
            if (!requestType.isAccessRequest()) {
                throw new IllegalArgumentException(String.format("Cannot request access for %s: %s", new Object[]{objectType, objectId}));
            }
            this.requestsService.checkRequestEnabledForType(login, objectId, objectProjectKey, requestType);
        }
        this.requestsService.checkUserHasNoRequestOnObjectWithStatus(login, objectType, requestType, objectId, objectProjectKey, Request.RequestStatus.PENDING);
        String requestId = this.requestsService.create(login, requestType, objectType, objectProjectKey, objectId, new Request.EmptyRequestDetails(), requestMessage);
        this.auditTrailService.generic("requests-center-request-create").with("requestId", requestId).with("requestType", requestType.toString()).with("objectProjectKey", objectProjectKey).with("objectType", objectType.toString()).with("objectId", objectId).emit();
        RequestsController.writeJSON((HttpServletResponse)resp, (Object)new Id(requestId));
    }

    @AuditInline
    @RequestMapping(value={"/create-sharing-request"})
    public void createSharingRequest(HttpServletRequest req, HttpServletResponse resp, @RequestParam Request.RequestObjectType objectType, @RequestParam String objectProjectKey, @RequestParam String objectId, @RequestParam String sharingTargetProject, @RequestParam(required=false) String requestMessage) throws IOException, CodedSQLException {
        String requestId;
        boolean targetProjectExists;
        boolean objectExists;
        Request.RequestType requestType;
        String login;
        if (StringUtils.isBlank((String)sharingTargetProject)) {
            throw new IllegalArgumentException("Target project key not specified.");
        }
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            login = authCtx.getAssociatedDSSUser();
            requestType = objectType.getDefaultRequestType();
            if (!requestType.isSharingRequest()) {
                throw new IllegalArgumentException(String.format("Cannot request sharing for %s: %s", new Object[]{objectType, objectId}));
            }
            this.requestsService.checkRequestEnabledForType(login, objectId, objectProjectKey, requestType);
            objectExists = this.taggableObjectsReadService.exists(objectProjectKey, objectType.toTaggableType().orElse(null), objectId);
            targetProjectExists = this.taggableObjectsReadService.exists(sharingTargetProject, ITaggingService.TaggableType.PROJECT, sharingTargetProject);
        }
        if (objectExists && targetProjectExists) {
            Request.ObjectSharingRequestDetails requestDetails = new Request.ObjectSharingRequestDetails();
            requestDetails.sharingTargetProject = sharingTargetProject;
            requestId = this.requestsService.create(login, requestType, objectType, objectProjectKey, objectId, requestDetails, requestMessage);
            this.auditTrailService.generic("requests-center-request-create").with("requestId", requestId).with("requestType", requestType.toString()).with("objectProjectKey", objectProjectKey).with("objectType", objectType.toString()).with("objectId", objectId).with("sharingTargetProject", sharingTargetProject).emit();
        } else {
            requestId = this.requestsService.createRequestId();
        }
        RequestsController.writeJSON((HttpServletResponse)resp, (Object)new Id(requestId));
    }

    @AuditInline
    @RequestMapping(value={"/create-plugin-request"})
    public void createPluginRequest(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) Request.RequestType requestType, @RequestParam String objectId, @RequestParam(required=false) String requestMessage) throws IOException, CodedSQLException {
        String requestId;
        boolean objectExists;
        String login;
        Request.RequestObjectType objectType = Request.RequestObjectType.PLUGIN;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            login = authCtx.getAssociatedDSSUser();
            if (requestType == null) {
                requestType = objectType.getDefaultRequestType();
            }
            if (!requestType.isPluginRequest()) {
                throw new IllegalArgumentException(String.format("Cannot request install for %s: %s", new Object[]{objectType, objectId}));
            }
            this.requestsService.checkRequestEnabledForType(login, objectId, null, requestType);
            objectExists = this.pluginStoreService.exists(objectId);
        }
        this.requestsService.checkUserHasNoRequestOnObjectWithStatus(login, objectType, requestType, objectId, null, Request.RequestStatus.PENDING);
        if (requestType == Request.RequestType.INSTALL_PLUGIN) {
            this.requestsService.checkUserHasNoRequestOnObjectWithStatus(login, objectType, requestType, objectId, null, Request.RequestStatus.APPROVED);
            if (this.pluginsRegistry.isPluginInstalled(objectId)) {
                throw new IllegalArgumentException(String.format("Plugin %s is already installed", objectId));
            }
        }
        this.checkMessageLength(requestMessage);
        if (objectExists) {
            requestId = this.requestsService.create(login, requestType, objectType, null, objectId, new Request.PluginRequestDetails(), requestMessage);
            this.auditTrailService.generic("requests-center-request-create").with("requestId", requestId).with("requestType", requestType.toString()).with("objectType", objectType.toString()).with("objectId", objectId).emit();
        } else {
            requestId = this.requestsService.createRequestId();
        }
        RequestsController.writeJSON((HttpServletResponse)resp, (Object)new Id(requestId));
    }

    @AuditInline
    @RequestMapping(value={"/create-code-env-request"})
    public void createCodeEnvRequest(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) Request.RequestType requestType, @RequestParam String objectId, @RequestParam String envLang, @RequestParam String envDesc, @RequestParam String specPackagesList, @RequestParam String specCondaEnvironment, @RequestParam(required=false) String requestMessage, @RequestParam(required=false) String source) throws IOException, CodedSQLException {
        String login;
        Request.RequestObjectType objectType = Request.RequestObjectType.CODE_ENV;
        CodeEnvModel.EnvLang el = CodeEnvModel.EnvLang.valueOf(envLang);
        CodeEnvModel.AbstractEnvDesc desc = switch (el) {
            case CodeEnvModel.EnvLang.PYTHON -> (CodeEnvModel.AbstractEnvDesc)JSON.parse((String)envDesc, CodeEnvModel.PythonEnvDesc.class);
            case CodeEnvModel.EnvLang.R -> (CodeEnvModel.AbstractEnvDesc)JSON.parse((String)envDesc, CodeEnvModel.REnvDesc.class);
            default -> throw new IllegalArgumentException(String.format("language  %s is not available to create code env", envLang));
        };
        Request.CodeEnvRequestDetails.CodeEnvRequestSource codeEnvRequestSource = Request.CodeEnvRequestDetails.CodeEnvRequestSource.MANUAL;
        if (!Strings.isNullOrEmpty((String)source)) {
            codeEnvRequestSource = Request.CodeEnvRequestDetails.CodeEnvRequestSource.valueOf(source);
        }
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            login = authCtx.getAssociatedDSSUser();
            if (requestType == null) {
                requestType = objectType.getDefaultRequestType();
            }
            if (!requestType.isCodeEnvRequest()) {
                throw new IllegalArgumentException(String.format("Cannot request install for %s: %s", new Object[]{objectType, objectId}));
            }
            this.requestsService.checkRequestEnabledForType(login, objectId, null, requestType);
        }
        this.requestsService.checkUserHasNoRequestOnObjectWithStatus(login, objectType, requestType, objectId, null, Request.RequestStatus.PENDING);
        this.checkMessageLength(requestMessage);
        Request.CodeEnvRequestDetails details = new Request.CodeEnvRequestDetails();
        details.desc = desc;
        details.envLang = el;
        details.specPackagesList = specPackagesList;
        details.specCondaEnvironment = specCondaEnvironment;
        details.source = codeEnvRequestSource;
        String requestId = this.requestsService.create(login, requestType, objectType, null, objectId, details, requestMessage);
        this.auditTrailService.generic("requests-center-request-create").with("requestId", requestId).with("requestType", requestType.toString()).with("objectType", objectType.toString()).with("objectId", objectId).emit();
        RequestsController.writeJSON((HttpServletResponse)resp, (Object)new Id(requestId));
    }

    @AuditInline
    @RequestMapping(value={"/create-instance-access-request"})
    public void createInstanceAccessRequest(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String requestMessage) throws IOException, CodedSQLException {
        String login;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            login = authCtx.getAssociatedDSSUser();
            this.requestsService.checkRequestEnabledForType(login, null, null, Request.RequestType.INSTANCE_ACCESS);
        }
        this.requestsService.checkUserHasNoPendingRequestForType(login, Request.RequestType.INSTANCE_ACCESS);
        String requestId = this.requestsService.create(login, Request.RequestType.INSTANCE_ACCESS, Request.RequestObjectType.INSTANCE, new Request.EmptyRequestDetails(), requestMessage);
        this.auditTrailService.generic("requests-center-request-create").with("requestId", requestId).with("requestType", Request.RequestType.INSTANCE_ACCESS.toString()).with("objectType", Request.RequestObjectType.INSTANCE.toString()).emit();
        RequestsController.writeJSON((HttpServletResponse)resp, (Object)new Id(requestId));
    }

    @AuditInline
    @RequestMapping(value={"/create-profile-upgrade-request"}, method={RequestMethod.POST})
    public void createProfileUpgradeRequest(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String requestMessage) throws IOException, CodedSQLException {
        String login;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            login = authCtx.getAssociatedDSSUser();
            this.requestsService.checkRequestEnabledForType(login, null, null, Request.RequestType.PROFILE_UPGRADE);
        }
        this.requestsService.checkUserHasNoPendingRequestForType(login, Request.RequestType.PROFILE_UPGRADE);
        this.checkMessageLength(requestMessage);
        String requestId = this.requestsService.create(login, Request.RequestType.PROFILE_UPGRADE, Request.RequestObjectType.PROFILE, new Request.EmptyRequestDetails(), requestMessage);
        this.auditTrailService.generic("requests-center-request-create").with("requestId", requestId).with("requestType", Request.RequestType.PROFILE_UPGRADE.toString()).with("objectType", Request.RequestObjectType.PROFILE.toString()).emit();
        RequestsController.writeJSON((HttpServletResponse)resp, (Object)new Id(requestId));
    }

    private void checkMessageLength(String requestMessage) {
        if (requestMessage != null && requestMessage.length() > 1000) {
            throw new IllegalArgumentException(String.format("Request message too long. The message size is restricted to %d characters.", 1000));
        }
    }
}

