/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dashboards.insights.InsightsService;
import com.dataiku.dip.dashboards.insights.runnable.DSSRunnableInsightMeta;
import com.dataiku.dip.dashboards.insights.runnable.DSSRunnableInsightParams;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.runnables.DSSRunnableDesc;
import com.dataiku.dip.scheduler.runnables.DSSRunnableResult;
import com.dataiku.dip.scheduler.runnables.DSSRunnablesService;
import com.dataiku.dip.scheduler.runnables.InlinePythonDSSRunnableThread;
import com.dataiku.dip.scheduler.runnables.LoadedRunnable;
import com.dataiku.dip.scheduler.runnables.PythonRunnableDesc;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.SecurityCodes;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class RunnablesController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private DSSRunnablesService dssRunnablesService;
    @Autowired
    private InsightsService insightsService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private APITicketService apiTicketService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/runnables/list-accessible"})
    public void listAccessible(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            boolean runnablesExist = false;
            RunnablesList ret = new RunnablesList();
            for (LoadedRunnable<?> runnable : this.dssRunnablesService.listRunnables()) {
                runnablesExist = true;
                if (!this.dssRunnablesService.canRun(runnable, user, projectKey)) continue;
                ret.runnables.add(runnable);
            }
            ret.runnablesExist = runnablesExist;
            RunnablesController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "runnable-run", "projectKey", "${projectKey}", "runnableType", "${runnableType}"})
    @RequestMapping(value={"/api/runnables/manual-run"})
    public void manualRun(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String runnableType, @RequestParam(required=false, value="params") String paramsData, @RequestParam(required=false, value="adminParams") String adminParamsData) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            LoadedRunnable<?> runnable = this.dssRunnablesService.getRunnable(runnableType);
            if (!this.dssRunnablesService.canRun(runnable, authCtx, projectKey)) {
                throw new SecurityException("Insufficient permissions to run " + runnableType);
            }
            CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forMacro((AuthCtx)authCtx, (String)runnableType, (String)projectKey, null, null, null));
            this.runMacro(resp, projectKey, runnableType, paramsData, adminParamsData, authCtx, new String[0]);
        }
    }

    @AuditedCall(value={"msgType", "runnable-run", "clusterId", "${clusterId}", "runnableType", "${runnableType}"})
    @RequestMapping(value={"/api/runnables/cluster-run"})
    public void clusterRun(HttpServletRequest req, HttpServletResponse resp, @RequestParam String clusterId, @RequestParam String runnableType, @RequestParam(required=false, value="params") String paramsData, @RequestParam(required=false, value="adminParams") String adminParamsData) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            LoadedRunnable<?> runnable = this.dssRunnablesService.getRunnable(runnableType);
            int clusterRolesCount = 0;
            for (DSSRunnableDesc.MacroRoleDef role : ((DSSRunnableDesc)runnable.desc).macroRoles) {
                if (role.type != DSSRunnableDesc.MacroRoleDef.Type.CLUSTER) continue;
                ++clusterRolesCount;
            }
            if (clusterRolesCount == 0) {
                throw new SecurityException("Macro " + runnableType + " has no CLUSTER role");
            }
            this.permissionsService.checkClusterPrivileges(authCtx, clusterId, Privileges.ClusterLevelPrivilegeType.USE);
            if (!this.dssRunnablesService.canRun(runnable, authCtx, "__fake_project__")) {
                throw new SecurityException("Insufficient permissions to run " + runnableType);
            }
            CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forMacro((AuthCtx)authCtx, (String)runnableType, null, null, (String)clusterId, null));
            this.runMacro(resp, null, runnableType, paramsData, adminParamsData, authCtx, new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AuditedCall(value={"msgType", "project-create-from-macro", "runnableType", "${runnableType}", "projectFolderId", "${projectFolderId}"})
    @RequestMapping(value={"/api/runnables/project-creation-run"})
    public void projectCreationRun(HttpServletRequest req, HttpServletResponse resp, @RequestParam String runnableType, @RequestParam String projectFolderId, @RequestParam(required=false, value="params") String paramsData) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.permissionsService.checkCanCreateProjectFromMacro(authCtx);
            this.permissionsService.checkProjectFolderPrivilege(authCtx, projectFolderId, Privileges.ProjectFolderLevelPrivilegeType.WRITE_CONTENTS);
            LoadedRunnable<?> runnable = this.dssRunnablesService.getRunnable(runnableType);
            boolean hasProjectCreationMacroRole = false;
            for (DSSRunnableDesc.MacroRoleDef role : ((DSSRunnableDesc)runnable.desc).macroRoles) {
                if (role.type != DSSRunnableDesc.MacroRoleDef.Type.PROJECT_CREATOR) continue;
                hasProjectCreationMacroRole = true;
                break;
            }
            if (!hasProjectCreationMacroRole) {
                throw new SecurityException("Macro " + runnableType + " is not for project creation");
            }
            CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forMacro((AuthCtx)authCtx, (String)runnableType, null, null, null, null));
            try {
                this.runMacro(resp, null, runnableType, paramsData, "{}", authCtx, "_projectFolderId", projectFolderId);
            }
            finally {
                CurrentComputeResourceUsageContext.clear();
            }
        }
    }

    private void runMacro(HttpServletResponse resp, String projectKey, String runnableType, String paramsData, String adminParamsData, AuthCtx authCtx, String ... additionalProperties) throws IOException, Exception {
        JsonObject params = new JsonObject();
        if (!StringUtils.isBlank((String)paramsData)) {
            params = (JsonObject)JSON.parse((String)paramsData, JsonObject.class);
        }
        int i = 0;
        while (i * 2 + 1 < additionalProperties.length) {
            params.addProperty(additionalProperties[i * 2], additionalProperties[i * 2 + 1]);
            ++i;
        }
        JsonObject adminParams = new JsonObject();
        if (!StringUtils.isBlank((String)adminParamsData)) {
            adminParams = (JsonObject)JSON.parse((String)adminParamsData, JsonObject.class);
        }
        File contextDir = ApplicationConfigurator.getFile((String)("tmp/runnables/" + runnableType));
        RunnablesController.writeJSON((HttpServletResponse)resp, this.dssRunnablesService.run(runnableType, authCtx, projectKey, params, adminParams, contextDir));
    }

    @AuditedCall(value={"msgType", "runnable-run-from-dashboard", "projectKey", "${projectKey}", "insightId", "${insightId}"})
    @RequestMapping(value={"/api/runnables/insight-run"})
    public void insightRun(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String insightId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            Insight insight = this.insightsService.getMandatoryUnsafe(projectKey, insightId);
            if (!insight.getSubtype().equals(DSSRunnableInsightMeta.META.getType())) {
                throw ErrorContext.iaef((String)"Insight %s in project %s is not a runnable (type is %s)", (Object)insightId, (Object[])new Object[]{projectKey, insight.getSubtype()});
            }
            DSSRunnableInsightParams insightParams = (DSSRunnableInsightParams)insight.params;
            String runnableType = insightParams.runnableType;
            LoadedRunnable<?> runnable = this.dssRunnablesService.getRunnable(runnableType);
            AuthCtx runAsUser = authCtx;
            if (StringUtils.isNotBlank((String)insightParams.runAsUser)) {
                if (this.usersService.getUserOrNull_NoLeak(insightParams.runAsUser) == null) {
                    throw ErrorContext.iaef((String)"Cannot execute runnable in insight %s.%s: configured to run as user '%s' which does not exist", (Object)projectKey, (Object[])new Object[]{insightId, insightParams.runAsUser});
                }
                runAsUser = DSSAuthCtx.forUserLogin(this.usersService.getInternalUserOrNullUnsafe(insightParams.runAsUser));
            }
            if (!this.dssRunnablesService.canRun(runnable, runAsUser, projectKey)) {
                throw new SecurityException("Insufficient permissions to run " + runnableType);
            }
            JsonObject runnableParams = insightParams.config;
            JsonObject runnableAdminParams = new JsonObject();
            File contextDir = ApplicationConfigurator.getFile((String)("tmp/runnables/" + runnableType));
            CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forMacro((AuthCtx)authCtx, (String)runnableType, (String)projectKey, null, null, (String)insightId));
            RunnablesController.writeJSON((HttpServletResponse)resp, this.dssRunnablesService.run(runnableType, runAsUser, projectKey, runnableParams, runnableAdminParams, contextDir));
        }
    }

    @AuditedCall(value={"msgType", "runnable-inline-run", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/runnables/inline-python-run"})
    public void inlinePythonRun(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String code, @RequestParam String desc, @RequestParam String envSelection) throws Exception {
        AuthCtx authCtx;
        CodeEnvSelection envSelectionObj = (CodeEnvSelection)JSON.parse((String)envSelection, CodeEnvSelection.class);
        PythonRunnableDesc runnableDescObj = (PythonRunnableDesc)JSON.parse((String)desc, PythonRunnableDesc.class);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            if (runnableDescObj.impersonate) {
                authCtx.failIfNoSafeCode("Run inline code (isolated)");
            } else {
                authCtx.failIfNoUnsafeCode("Run inline code (un-isolated)");
            }
        }
        AutoDelete contextDir = DSSTempUtils.getTempFolder((String)"inline-runnables");
        InlinePythonDSSRunnableThread ipt = new InlinePythonDSSRunnableThread(authCtx, code, runnableDescObj, envSelectionObj, projectKey, (File)contextDir, this.apiTicketService);
        RunnablesController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(ipt, 0L, new TypeToken<FutureResponse<DSSRunnableResult>>(){}));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/runnables/load-kept-file"})
    public void loadKeptFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam(required=false) String clusterId, @RequestParam String runnableType, @RequestParam(value="item") String itemData) throws Exception {
        File file;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            if (StringUtils.isNotBlank((String)projectKey)) {
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                LoadedRunnable<?> runnable = this.dssRunnablesService.getRunnable(runnableType);
                if (!this.dssRunnablesService.canRun(runnable, authCtx, projectKey)) {
                    throw new SecurityException("Insufficient permissions to run " + runnableType);
                }
            } else {
                this.permissionsService.checkClusterPrivileges(authCtx, clusterId, Privileges.ClusterLevelPrivilegeType.USE);
            }
        }
        ReportTargetItem.KeptFileItem item = (ReportTargetItem.KeptFileItem)JSON.parse((String)itemData, ReportTargetItem.KeptFileItem.class);
        File contextDir = ApplicationConfigurator.getFile((String)("tmp/runnables/" + runnableType));
        File file2 = file = item.path.startsWith("/") ? new File(item.path) : new File(contextDir, item.path);
        if (!(DKUFileUtils.isWithin((File)contextDir, (File)file) && file.isFile() && file.canRead())) {
            throw new DKUSecurityException("Trying to access a file outside the macro's tmp/").withCode((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_PATH_ESCAPE);
        }
        RunnablesController.writeJSON((HttpServletResponse)resp, (Object)Lists.newArrayList((Object[])new String[]{FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8)}));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/runnables/download-kept-file"})
    public void downloadKeptFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String projectKey, @RequestParam(required=false) String clusterId, @RequestParam String runnableType, @RequestParam(value="item") String itemData) throws Exception {
        File file;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUserNoXSRF(req);
            if (StringUtils.isNotBlank((String)projectKey)) {
                this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                LoadedRunnable<?> runnable = this.dssRunnablesService.getRunnable(runnableType);
                if (!this.dssRunnablesService.canRun(runnable, authCtx, projectKey)) {
                    throw new SecurityException("Insufficient permissions to run " + runnableType);
                }
            } else {
                this.permissionsService.checkClusterPrivileges(authCtx, clusterId, Privileges.ClusterLevelPrivilegeType.USE);
            }
        }
        ReportTargetItem.KeptFileItem item = (ReportTargetItem.KeptFileItem)JSON.parse((String)itemData, ReportTargetItem.KeptFileItem.class);
        File contextDir = ApplicationConfigurator.getFile((String)("tmp/runnables/" + runnableType));
        File file2 = file = item.path.startsWith("/") ? new File(item.path) : new File(contextDir, item.path);
        if (DKUFileUtils.isWithin((File)contextDir, (File)file) && file.isFile() && file.canRead()) {
            this.writeFileForDownload(resp, file, item.mimeType, file.getName());
        } else {
            resp.setStatus(404);
            resp.getWriter().write("File not found " + file.getAbsolutePath());
        }
    }

    public static class RunnablesList {
        public List<LoadedRunnable<?>> runnables = Lists.newArrayList();
        public boolean runnablesExist;
    }
}

