/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.analysis;

import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.coreservices.DataAugmentationService;
import com.dataiku.dip.analysis.coreservices.MLBaseService;
import com.dataiku.dip.analysis.coreservices.PredictionCreationService;
import com.dataiku.dip.analysis.coreservices.PredictionService;
import com.dataiku.dip.analysis.ml.DKUMLUtils;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLSparkParams;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.prediction.CustomPythonPredictionAlgoService;
import com.dataiku.dip.analysis.ml.prediction.DeephubImagesDataService;
import com.dataiku.dip.analysis.ml.prediction.DesignImagesDataService;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesService;
import com.dataiku.dip.analysis.ml.prediction.guess.OutcomeStats;
import com.dataiku.dip.analysis.ml.prediction.guess.PredictionGuessPolicy;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.analysis.model.prediction.ActualModelParameters;
import com.dataiku.dip.analysis.model.prediction.DeepHubPreTrainModelingParams;
import com.dataiku.dip.analysis.model.prediction.EnsembleParams;
import com.dataiku.dip.analysis.model.prediction.MetricParams;
import com.dataiku.dip.analysis.model.prediction.PartitionedModelExtract;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelSnippetData;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.TimestepParams;
import com.dataiku.dip.analysis.model.prediction.overrides.MLOverridesParams;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.datalayer.utils.RecipeCreationUtils;
import com.dataiku.dip.experimenttracking.ExperimentTrackingService;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.code.python.PythonRecipeStatusComputer;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.analysis.SavedModelsController;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.shaker.server.SerializedMemTableV2;
import com.dataiku.dip.shaker.server.SerializedTableChunk;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.Gson;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AnalysisPredictionController
extends DIPInternalControllerBase {
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private PredictionService predictionService;
    @Autowired
    private DesignImagesDataService designImagesDataService;
    @Autowired
    private DeephubImagesDataService deephubImagesDataService;
    @Autowired
    private CustomPythonPredictionAlgoService customPythonPredictionAlgosService;
    @Autowired
    private PredictionCreationService predictionCreationService;
    @Autowired
    private PredictionRecipesService trainingRecipeService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private MLBaseService mlBaseService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DataAugmentationService dataAugmentationService;
    @Autowired
    private ExperimentTrackingService experimentTrackingService;
    private static final Logger logger = Logger.getLogger((String)"dku.analysis");

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/pml/list-predictable-columns"})
    public void listPredictableColumns(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId) throws Exception {
        AuthCtx user;
        AnalysisCoreParams acp = null;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
        }
        AnalysisPredictionController.writeJSON((HttpServletResponse)resp, this.predictionCreationService.listPredictableColumns_NT(acp, user));
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-create", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/pml/create-and-guess"})
    public void createAndGuess(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String targetVariable, @RequestParam(required=false) String managedFolderSmartId, @RequestParam(required=false) PredictionMLTask.PredictionType predictionType, @RequestParam MLTask.BackendType mlBackendType, @RequestParam String mlBackendName, @RequestParam(required=false) Boolean useGlobalMetastore, @RequestParam(required=false) String timeVariable, @RequestParam(required=false) List<String> timeseriesIdentifiers, @RequestParam(required=false) String treatmentVariable, @RequestParam PredictionGuessPolicy guessPolicy) throws Exception {
        MLSparkParams sparkParams;
        AuthCtx u = null;
        AnalysisCoreParams acp = null;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            u = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            if (mlBackendType == null) {
                throw ErrorContext.iae((String)"Invalid ML Backend type");
            }
            if (mlBackendType.isSparkBased()) {
                SparkSettings sparkSettings = new ClusterSelector().selectForProject(u, projectKey).getSparkSettings();
                if (StringUtils.isBlank((String)mlBackendName)) {
                    mlBackendName = sparkSettings.getDefault().name;
                }
                sparkSettings.getByName(mlBackendName);
                sparkParams = RecipeCreationUtils.setupMLSparkParams(u, projectKey, mlBackendName, useGlobalMetastore);
            } else {
                sparkParams = null;
            }
            if (mlBackendType == MLTask.BackendType.KERAS) {
                u.failIfNoSafeCode("use a custom Keras architecture");
            }
        }
        AnalysisPredictionController.writeJSON((HttpServletResponse)resp, (Object)new Id(this.predictionService.createAndGuess_NT(u, acp, targetVariable, managedFolderSmartId, mlBackendType, sparkParams, guessPolicy, predictionType, timeVariable, timeseriesIdentifiers, treatmentVariable)));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/pml/get-light-mltask-status"})
    public void getLightPMLTaskStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        AnalysisPredictionController.writeJSON((HttpServletResponse)resp, (Object)this.predictionService.getLightMLTaskStatus_NT(loc));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/pml/get-mltask-status"})
    public void getPMLTaskStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        AnalysisPredictionController.writeJSON((HttpServletResponse)resp, (Object)this.predictionService.getMLTaskStatus_NT(loc));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/pml/list-custom-python-algos"})
    public void listPredictionCustomModels(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        AnalysisPredictionController.writeJSON((HttpServletResponse)resp, this.customPythonPredictionAlgosService.listAlgosFromLoadedPlugins());
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-get-settings", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "sessionId", "${sessionId}"})
    @RequestMapping(value={"/api/analysis/pml/get-session-task"})
    public void getSessionSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam String sessionId) throws Exception {
        PredictionMLTask task;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            task = this.analysisCRUDService.getPMLSessionTask(loc, sessionId, true);
        }
        AnalysisPredictionController.writeJSON((HttpServletResponse)resp, (Object)task);
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-get-settings", "fullModelId", "${fullModelId}", "usePostTrain", "${usePostTrain}"})
    @RequestMapping(value={"/api/analysis/pml/get-pretrain-equivalent-mltask"})
    public void getPretrainEquivalentMltask(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam Boolean usePostTrain) throws Exception {
        PredictionMLTask task;
        FullModelId fmi = FullModelId.parse(fullModelId);
        String projectKey = fmi.getProjectKey();
        String analysisId = fmi.getTaskLoc().analysisId;
        String mlTaskId = fmi.getTaskLoc().mlTaskId;
        String sessionId = fmi.getSessionId();
        String preProcessingId = fmi.getPreprocessingId();
        String modelId = fmi.getModelId();
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            task = this.analysisCRUDService.getPMLSessionTask(loc, sessionId, true);
        }
        ActualModelParameters actualModel = this.analysisCRUDService.getPMLActualSessionParams(loc, sessionId, preProcessingId, modelId);
        if (task instanceof PredictionMLTask.TabularPredictionMLTask) {
            PredictionModelingParams predictionModelingParams;
            PostTrainPredictionModelingParams postTrain = new PostTrainPredictionModelingParams();
            if (usePostTrain.booleanValue()) {
                postTrain = (PostTrainPredictionModelingParams)actualModel.resolved;
            }
            PredictionMLTask.TabularPredictionMLTask mlTask = (PredictionMLTask.TabularPredictionMLTask)task;
            mlTask.modeling = predictionModelingParams = PredictionModelingParams.fromPredictionModelingParamsNoEnabledAlgos(mlTask.modeling, mlTask.predictionType);
            PreTrainPredictionModelingParams preTrain = fmi.parseModelFile("rmodeling_params.json", PreTrainPredictionModelingParams.class);
            PostTrainPredictionModelingParams modelingParams = (PostTrainPredictionModelingParams)actualModel.resolved;
            if (usePostTrain.booleanValue()) {
                modelingParams.algorithm.meta.regridifyToMLTask(predictionModelingParams, postTrain, preTrain);
                predictionModelingParams.gridSearchParams.strategy = PredictionModelingParams.GridSearchParams.Strategy.GRID;
            } else {
                modelingParams.algorithm.meta.refreshMLTask(predictionModelingParams, preTrain);
            }
        } else if (task instanceof PredictionMLTask.DeepHubPredictionMLTask) {
            PredictionMLTask.DeepHubPredictionMLTask mlTask = (PredictionMLTask.DeepHubPredictionMLTask)task;
            DeepHubPreTrainModelingParams predictionModelingParams = DeepHubPreTrainModelingParams.build(task.predictionType);
            predictionModelingParams.metrics = mlTask.modeling.metrics;
            mlTask.modeling = predictionModelingParams;
        } else {
            throw new IllegalArgumentException("Unsupported MlTask: " + task.getClass().getSimpleName());
        }
        AnalysisPredictionController.writeJSON((HttpServletResponse)resp, (Object)task);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/pml/get-model-snippets"})
    public void getPMLTaskSnippets(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam(required=false) String[] fullModelIds) throws Exception {
        PredictionMLTask task;
        List<FullModelId> fullModelIdList;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (fullModelIds == null || fullModelIds.length == 0) {
            fullModelIdList = this.predictionService.listTaskModelIds(loc);
        } else {
            fullModelIdList = new ArrayList<FullModelId>();
            for (String fmi : fullModelIds) {
                fullModelIdList.add(FullModelId.parse(fmi));
            }
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            task = this.analysisCRUDService.getPMLTask(loc);
        }
        Map<String, PredictionModelSnippetData> snippets = this.predictionService.getSnippets_NT(task, fullModelIdList);
        Gson gsonInstance = PartitionedModelExtract.createGsonWithLimitedSummaries();
        String jsonResponse = null;
        try {
            jsonResponse = PartitionedModelExtract.createGsonWithLimitedSummaries().toJson(snippets);
        }
        catch (IllegalArgumentException e) {
            throw JSON.withBetterSerializationError((Gson)gsonInstance, snippets, (IllegalArgumentException)e);
        }
        AnalysisPredictionController.writeJSONString((HttpServletResponse)resp, (String)jsonResponse);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/pml/get-partitioned-model-snippets"})
    public void getPartitionSnippets(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        PredictionMLTask task;
        FullModelId fmi = FullModelId.parse(fullModelId);
        if (!fmi.isModelPartition() && !fmi.isPartitionedBaseModel()) {
            throw ErrorContext.iaef((String)"Invalid FMI, not partitioned: %s", (Object)fullModelId, (Object[])new Object[0]);
        }
        FullModelId baseFmi = fmi.isModelPartition() ? fmi.getPartitionedBaseModel() : fmi;
        MLTaskLoc taskLoc = fmi.getTaskLoc();
        try (Transaction ignored = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF);
            task = this.analysisCRUDService.getPMLTask(taskLoc);
        }
        Map<String, PredictionModelSnippetData> snippets = this.predictionService.getSnippets_NT(task, Collections.singletonList(baseFmi));
        AnalysisPredictionController.writeJSON((HttpServletResponse)resp, (Object)snippets.get(baseFmi.toString()));
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-get-settings", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/pml/get-updated-settings"})
    public void getPMLUpdatedSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId) throws Exception {
        AuthCtx u = null;
        AnalysisCoreParams acp = null;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            u = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
        }
        boolean changed = this.predictionService.update_NT(u, acp, mlTaskId);
        logger.info((Object)("CHANGED " + changed));
        try (Transaction t = this.transactionService.beginRead();){
            MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
            AnalysisPredictionController.writeJSON((HttpServletResponse)resp, (Object)this.analysisCRUDService.getPMLTask(loc));
        }
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-reguess", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/api/analysis/pml/reguess-with-target"})
    @ResponseBody
    public PredictionMLTask reguessWithTarget(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam String targetVariable, @RequestParam boolean redetect) throws Exception {
        PredictionMLTask task;
        AnalysisCoreParams acp;
        AuthCtx u;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (this.mlBaseService.isGuessing(loc)) {
            throw new IllegalStateException("The ML task is in guessing state. Wait for guessing to finish before re-guessing");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            u = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            task = this.analysisCRUDService.getPMLTask(loc);
        }
        return this.predictionService.reguessWithTarget_NT(u, acp, loc, task, targetVariable, redetect);
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-reguess", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/api/analysis/pml/reguess-with-timeseries-identifiers"})
    @ResponseBody
    public PredictionMLTask.TimeseriesForecastingMLTask reguessWithTimeseriesIdentifiers(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam List<String> timeseriesIdentifiers, @RequestParam boolean redetect) throws Exception {
        PredictionMLTask.TimeseriesForecastingMLTask task;
        AnalysisCoreParams acp;
        AuthCtx u;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (this.mlBaseService.isGuessing(loc)) {
            throw new IllegalStateException("The ML task is in guessing state. Wait for guessing to finish before re-guessing");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            u = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            task = (PredictionMLTask.TimeseriesForecastingMLTask)this.analysisCRUDService.getPMLTask(loc);
        }
        return this.predictionService.reguessWithTimeseriesIdentifiers_NT(u, acp, loc, task, timeseriesIdentifiers, redetect);
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-reguess", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/api/analysis/pml/reguess-with-time-variable"})
    @ResponseBody
    public PredictionMLTask.TimeseriesForecastingMLTask reguessWithTimeVariable(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam String timeVariable, @RequestParam boolean redetect) throws Exception {
        PredictionMLTask.TimeseriesForecastingMLTask task;
        AnalysisCoreParams acp;
        AuthCtx u;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (this.mlBaseService.isGuessing(loc)) {
            throw new IllegalStateException("The ML task is in guessing state. Wait for guessing to finish before re-guessing");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            u = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            task = (PredictionMLTask.TimeseriesForecastingMLTask)this.analysisCRUDService.getPMLTask(loc);
        }
        return this.predictionService.reguessWithTimeVariable_NT(u, acp, loc, task, timeVariable, redetect);
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-reguess", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/api/analysis/pml/reguess-with-treatment-variable"})
    @ResponseBody
    public PredictionMLTask.CausalPredictionMLTask reguessWithTreatmentVariable(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam String treatmentVariable, @RequestParam boolean redetect) throws Exception {
        PredictionMLTask.CausalPredictionMLTask task;
        AnalysisCoreParams acp;
        AuthCtx u;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (this.mlBaseService.isGuessing(loc)) {
            throw new IllegalStateException("The ML task is in guessing state. Wait for guessing to finish before re-guessing");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            u = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            task = (PredictionMLTask.CausalPredictionMLTask)this.analysisCRUDService.getPMLTask(loc);
        }
        return this.predictionService.reguessWithTreatmentVariable_NT(u, acp, loc, task, treatmentVariable, redetect);
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-reguess", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/api/analysis/pml/reguess-with-type"})
    @ResponseBody
    public PredictionMLTask reguessWithType(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam PredictionMLTask.PredictionType newType, @RequestParam boolean redetect) throws Exception {
        PredictionMLTask task;
        AnalysisCoreParams acp;
        AuthCtx u;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (this.mlBaseService.isGuessing(loc)) {
            throw new IllegalStateException("The ML task is in guessing state. Wait for guessing to finish before re-guessing");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            u = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            task = this.analysisCRUDService.getPMLTask(loc);
        }
        return this.predictionService.reguessWithType_NT(u, acp, loc, task, newType, redetect);
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-reguess", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/api/analysis/pml/reguess"})
    @ResponseBody
    public PredictionMLTask reguess(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId) throws Exception {
        PredictionMLTask task;
        AnalysisCoreParams acp;
        AuthCtx u;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (this.mlBaseService.isGuessing(loc)) {
            throw new IllegalStateException("The ML task is in guessing state. Wait for guessing to finish before re-guessing");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            u = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            task = this.analysisCRUDService.getPMLTask(loc);
        }
        return this.predictionService.reguess_NT(u, acp, loc, task);
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-reguess", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}"})
    @RequestMapping(value={"/api/analysis/pml/reguess-with-timestep-params"})
    @ResponseBody
    public PredictionMLTask.TimeseriesForecastingMLTask reguessWithTimestepParams(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam boolean redetect, @RequestParam(required=false) TimestepParams timestepParams, @RequestParam(required=false) Long predictionLength, @RequestParam(required=false) Long validationHorizons) throws Exception {
        PredictionMLTask.TimeseriesForecastingMLTask task;
        AnalysisCoreParams acp;
        AuthCtx u;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (this.mlBaseService.isGuessing(loc)) {
            throw new IllegalStateException("The ML task is in guessing state. Wait for guessing to finish before re-guessing");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            u = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            task = (PredictionMLTask.TimeseriesForecastingMLTask)this.analysisCRUDService.getPMLTask(loc);
        }
        return this.predictionService.reguessWithTimestepParams_NT(u, acp, loc, task, timestepParams, predictionLength, redetect, validationHorizons);
    }

    @AuditedCall(value={"msgType", "analysis-prediction-refresh-images-feed-data", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mltaskId", "${mltaskId}"})
    @RequestMapping(value={"api/analysis/pml/refresh-images-data-sample"})
    public void refreshImagesDataSample(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam int nbRows, @RequestParam(required=false) DeephubImagesDataService.DeepHubDesignFilterRequest filters) throws Exception {
        SerializedMemTableV2 smt;
        AuthCtx u = null;
        AnalysisCoreParams acp = null;
        PredictionMLTask task = null;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (this.mlBaseService.isGuessing(loc)) {
            throw new IllegalStateException("The ML task is in guessing state. Wait for guessing to finish before requesting images");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            u = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            task = this.analysisCRUDService.getPMLTask(loc);
        }
        if (task.backendType == MLTask.BackendType.DEEP_HUB) {
            smt = this.deephubImagesDataService.refreshDesignImagesDataSample(u, acp, nbRows, task, filters);
        } else {
            if (filters != null) {
                throw new IllegalArgumentException("Filters are only supported for deephub tasks");
            }
            smt = this.designImagesDataService.refreshDesignImagesDataSample(u, acp, nbRows, null);
        }
        AnalysisPredictionController.writeJSON((HttpServletResponse)resp, (Object)smt);
    }

    @AuditedCall(value={"msgType", "analysis-prediction-get-random-image-paths", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mltaskId", "${mltaskId}"})
    @RequestMapping(value={"api/analysis/pml/get-random-image-paths"})
    public void getRandomImagePaths(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam(required=false) Integer numImagePaths) throws Exception {
        AuthCtx u = null;
        AnalysisCoreParams acp = null;
        PredictionMLTask task = null;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (this.mlBaseService.isGuessing(loc)) {
            throw new IllegalStateException("The ML task is in guessing state. Wait for guessing to finish before requesting images");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            u = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            task = this.analysisCRUDService.getPMLTask(loc);
        }
        List<String> smt = this.deephubImagesDataService.getRandomImagePaths(u, acp, task, numImagePaths != null ? numImagePaths : 1);
        AnalysisPredictionController.writeJSON((HttpServletResponse)resp, smt);
    }

    @AuditedCall(value={"msgType", "analysis-prediction-get-augmented-images", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mltaskId", "${mltaskId}"})
    @RequestMapping(value={"api/analysis/pml/get-augmented-images"})
    public void getAugmentedImages(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam String augmentationParams, @RequestParam String imagePath, @RequestParam int numAugmentedVersions, @RequestParam(required=false) DataAugmentationService.AugmentationType augmentationType, @RequestParam(required=false) Boolean applyMaxTransform) throws Exception {
        AuthCtx u = null;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        PredictionMLTask task = null;
        if (this.mlBaseService.isGuessing(loc)) {
            throw new IllegalStateException("The ML task is in guessing state. Wait for guessing to finish before requesting images");
        }
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            task = this.analysisCRUDService.getPMLTask(loc);
        }
        DeepHubPreTrainModelingParams.ImageAugmentationParams imageAugmentationParam = (DeepHubPreTrainModelingParams.ImageAugmentationParams)JSON.parse((String)augmentationParams, DeepHubPreTrainModelingParams.ImageAugmentationParams.class);
        AnalysisPredictionController.writeJSON((HttpServletResponse)resp, this.dataAugmentationService.getAugmentedImages_NT(u, loc, task, imageAugmentationParam, imagePath, numAugmentedVersions, augmentationType, applyMaxTransform));
    }

    @AuditedCall(value={"msgType", "analysis-prediction-get-images-feed-data-chunk", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mltaskId", "${mltaskId}"})
    @RequestMapping(value={"api/analysis/pml/get-images-data-chunk"})
    public void getImagesDataChunk(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam int firstRow, @RequestParam int nbRows, @RequestParam(required=false) DeephubImagesDataService.DeepHubDesignFilterRequest filters) throws Exception {
        SerializedTableChunk smt;
        AuthCtx u = null;
        AnalysisCoreParams acp = null;
        PredictionMLTask task = null;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (this.mlBaseService.isGuessing(loc)) {
            throw new IllegalStateException("The ML task is in guessing state. Wait for guessing to finish before requesting images");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            u = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            task = this.analysisCRUDService.getPMLTask(loc);
        }
        if (task.backendType == MLTask.BackendType.DEEP_HUB) {
            smt = this.deephubImagesDataService.getDesignImagesDataChunk(u, acp, task, firstRow, nbRows, filters);
        } else {
            if (filters != null) {
                throw new IllegalArgumentException("Filters are only supported for deephub tasks");
            }
            smt = this.designImagesDataService.getDesignImagesDataChunk(u, acp, firstRow, nbRows, null);
        }
        AnalysisPredictionController.writeJSON((HttpServletResponse)resp, (Object)smt);
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-change-guess-policy", "projectKey", "${projectKey}", "analysisId", "${analysisId}", "mlTaskId", "${mlTaskId}", "newPolicyId", "${newPolicyId}"})
    @RequestMapping(value={"/api/analysis/pml/change-guess-policy"})
    public void changeGuessPolicy(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam String newPolicyId) throws Exception {
        PredictionMLTask task;
        AnalysisCoreParams acp;
        AuthCtx u;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (this.mlBaseService.isGuessing(loc)) {
            throw new IllegalStateException("The ML task is in guessing state. Wait for guessing to finish before re-guessing");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            u = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            task = this.analysisCRUDService.getPMLTask(loc);
        }
        if (!(task instanceof PredictionMLTask.TabularPredictionMLTask)) {
            throw new IllegalArgumentException("Cannot change guessing for MLTask: " + task.getClass().getSimpleName());
        }
        this.predictionService.changeGuessPolicy(u, acp, loc, (PredictionMLTask.TabularPredictionMLTask)task, PredictionGuessPolicy.valueOf(newPolicyId));
        AnalysisPredictionController.writeJSON((HttpServletResponse)resp, (Object)task);
    }

    @AuditedCall(value={"msgType", "analysis-pmltask-duplicate", "projectKeyFrom", "${projectKeyFrom}", "analysisIdFrom", "${analysisIdFrom}", "mlTaskIdFrom", "${mlTaskIdFrom}", "projectKeyTo", "${projectKeyTo}", "analysisIdTo", "${analysisIdTo}", "newTarget", "${newTarget}"})
    @RequestMapping(value={"/api/analysis/pml/duplicate"})
    public void duplicateTask(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKeyFrom, @RequestParam String analysisIdFrom, @RequestParam String mlTaskIdFrom, @RequestParam String projectKeyTo, @RequestParam String analysisIdTo, @RequestParam(required=false) String newTarget) throws Exception {
        AnalysisCoreParams acp;
        PredictionMLTask task;
        AuthCtx user;
        PartitioningScheme partitioningFrom = null;
        PartitioningScheme partitioningTo = null;
        Dataset datasetDestination = null;
        List<Partition> partitionsTo = null;
        MLTaskLoc loc = new MLTaskLoc(projectKeyFrom, analysisIdFrom, mlTaskIdFrom);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKeyFrom, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            this.projectsService.checkPerm(req, projectKeyTo, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = this.authService.getMandatoryUser(req);
            task = this.analysisCRUDService.getPMLTask(loc);
            acp = this.analysisCRUDService.getCoreMandatory(projectKeyTo, analysisIdTo);
            if (task.isPartitioned()) {
                partitioningFrom = this.datasetAccessService.getMandatoryFromRef(projectKeyFrom, this.analysisCRUDService.getCoreMandatory((String)projectKeyFrom, (String)analysisIdFrom).inputDatasetSmartName).getPartitioningSchema();
                datasetDestination = this.datasetAccessService.getMandatoryFromRef(projectKeyTo, acp.inputDatasetSmartName);
                partitioningTo = datasetDestination.getPartitioningSchema();
            }
        }
        if (task.isPartitioned()) {
            partitionsTo = DatasetHandlerFactory.build(user, datasetDestination).listPartitions();
        }
        DuplicationResult result = new DuplicationResult();
        if (this.predictionService.canDuplicate(acp, user, loc, task, newTarget)) {
            this.predictionService.duplicate(acp, user, loc, task, newTarget, partitioningFrom, partitioningTo, partitionsTo);
            result.success = true;
            result.newMlTaskId = new Id(task.id);
        } else {
            result.success = false;
            result.possibleTargets = this.mlBaseService.getColumnNames(acp, user);
        }
        AnalysisPredictionController.writeJSON((HttpServletResponse)resp, (Object)result);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/pml/get-pretrain-status"})
    public void getPretrainStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId) throws Exception {
        PredictionMLTask pmlTask;
        AnalysisCoreParams coreParams;
        MLTaskLoc loc;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
            coreParams = this.analysisCRUDService.getCoreMandatory(loc.analysisProjectKey, loc.analysisId);
            pmlTask = this.analysisCRUDService.getPMLTask(loc);
        }
        AnalysisPredictionController.writeJSON((HttpServletResponse)resp, (Object)this.predictionService.getPreTrainStatus_NT(loc, user, coreParams, pmlTask));
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-set-settings", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/pml/validate-keras-architecture"})
    public void validateArchitecture(HttpServletRequest req, HttpServletResponse resp, @RequestParam String payload, @RequestParam(value="envSelection") String envSelectionStr, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        CodeEnvSelection envSelection = (CodeEnvSelection)JSON.parse((String)envSelectionStr, CodeEnvSelection.class);
        RecipeStatus.BasicRecipeStatus status = new RecipeStatus.BasicRecipeStatus();
        try {
            String envName = new CodeEnvSelector().selectForDoctor(projectKey, envSelection);
            PythonRecipeStatusComputer.checkPythonCompile(status.topLevelMessages, payload, envName == null || envName.isEmpty() ? null : envName, projectKey);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"Failed to check architecture code", (Throwable)e);
            status.topLevelMessages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to check architecture code: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
        AnalysisPredictionController.writeJSON((HttpServletResponse)resp, (Object)status);
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-set-settings", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/pml/save-settings"})
    public void saveSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTask) throws Exception {
        PredictionMLTask taskObj = (PredictionMLTask)JSON.parse((String)mlTask, MLTask.class);
        DKUMLUtils.checkPredictionTaskBeforeSaving(taskObj);
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, taskObj.id);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            this.analysisCRUDService.saveMLTask(loc, taskObj, true);
            t.commit("Saved settings of ML task " + taskObj.id + " in " + projectKey + "." + analysisId);
        }
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-train", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/pml/train-start"})
    public void trainStart(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam(required=false) Boolean forceRefresh, @RequestParam(required=false) String userSessionName, @RequestParam(required=false) String userSessionDescription, @RequestParam(defaultValue="false") Boolean runQueue) throws Exception {
        PredictionMLTask task;
        AuthCtx user;
        AnalysisCoreParams acp;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (this.mlBaseService.isGuessing(loc)) {
            throw new IllegalStateException("The ML task is in guessing state. Wait for guessing to finish before training");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            user = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkVisualMLAllowed(user);
            this.predictionService.checkSourceDatasetPermissions(user, acp, loc);
            task = this.analysisCRUDService.getPMLTask(loc);
        }
        if (forceRefresh != null && forceRefresh.booleanValue()) {
            t = this.transactionService.beginWriteForUI(req);
            try {
                ++task.splitParams.instanceIdRefresher;
                this.analysisCRUDService.saveMLTask(loc, task, true);
                t.commit("Saved settings of ML task " + task.id + " in " + projectKey + "." + analysisId);
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
        }
        this.predictionService.trainStart_NT(user, acp, loc, task, userSessionName, userSessionDescription, runQueue);
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-retrain", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/pml/retrain-start"})
    public void retrainStart(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam String sessionId, @RequestParam(required=false) String[] fullModelIds) throws Exception {
        PredictionMLTask task;
        AuthCtx user;
        AnalysisCoreParams acp;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (this.mlBaseService.isGuessing(loc)) {
            throw new IllegalStateException("The ML task is in guessing state. Wait for guessing to finish before re-training");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            user = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkVisualMLAllowed(user);
            this.predictionService.checkSourceDatasetPermissions(user, acp, loc);
            task = this.analysisCRUDService.getPMLSessionTask(loc, sessionId, false);
        }
        this.predictionService.retrainStart_NT(user, acp, loc, sessionId, task, fullModelIds);
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-new-model-version-with-different-overrides", "fullModelId", "${fullModelId}"})
    @RequestMapping(value={"/api/analysis/pml/create-model-with-different-overrides"})
    public void createModelWithDifferentOverrides(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String newModelName, @RequestParam MLOverridesParams overridesParams) throws Exception {
        AuthCtx user;
        FullModelId originFmi = FullModelId.parse(fullModelId);
        if (this.mlBaseService.isGuessing(originFmi.getTaskLoc()) || this.mlBaseService.isTraining(originFmi.getTaskLoc())) {
            throw new IllegalStateException("The ML task is working. Wait for work to finish before creating new model with overrides");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, originFmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkVisualMLAllowed(user);
        }
        this.predictionService.createTrainedModelWithDifferentOverridesAnalysis_NT(user, originFmi, newModelName, overridesParams);
    }

    @AuditedCall(value={"msgType", "analysis-prediction-enqueue-session", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/pml/enqueue-session"})
    public void enqueueSession(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam(required=false) boolean pauseQueue, @RequestParam(required=false) String userSessionName, @RequestParam(required=false) String userSessionDescription, @RequestParam(required=false) Boolean forceRefresh) throws Exception {
        PredictionMLTask task;
        AuthCtx user;
        AnalysisCoreParams acp;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (this.mlBaseService.isGuessing(loc)) {
            throw new IllegalStateException("The ML task is in guessing state. Wait for guessing to finish before training");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            user = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkVisualMLAllowed(user);
            this.predictionService.checkSourceDatasetPermissions(user, acp, loc);
            task = this.analysisCRUDService.getPMLTask(loc);
        }
        this.predictionService.enqueueSession(user, acp, loc, task, pauseQueue, userSessionName, userSessionDescription, forceRefresh);
    }

    @AuditedCall(value={"msgType", "analysis-prediction-resume-queue-sessions", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/pml/train-queue"})
    public void trainQueue(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId) throws Exception {
        AnalysisCoreParams acp;
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        if (this.mlBaseService.isGuessing(loc)) {
            throw new IllegalStateException("The ML task is in guessing state. Wait for guessing to finish before training");
        }
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.licenseEnforcementService.checkVisualMLAllowed(user);
            this.predictionService.checkSourceDatasetPermissions(user, acp, loc);
        }
        this.predictionService.trainQueue(acp, loc);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/pml/check-can-ensemble"})
    @ResponseBody
    public PredictionService.EnsembleCheck checkCanEnsemble(HttpServletRequest req, @RequestParam List<String> modelIds) throws Exception {
        ArrayList<FullModelId> parsed = new ArrayList<FullModelId>();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            for (String modelId : modelIds) {
                FullModelId fmi = FullModelId.parse(modelId);
                this.projectsService.failIfNoReadAccess(authCtx, fmi.getUnderlyingStore(), fmi.getProjectKey());
                parsed.add(FullModelId.parse(modelId));
            }
        }
        return this.predictionService.checkEnsemblability(parsed);
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-ensemble", "projectKey", "${projectKey}", "analysisId", "${analysisId}"})
    @RequestMapping(value={"/api/analysis/pml/create-ensemble"})
    public void createEnsemble(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam String modelIds, @RequestParam String method) throws Exception {
        AnalysisCoreParams acp;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
        }
        MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
        List fmis = (List)JSON.parse((String)modelIds, List.class);
        ArrayList<FullModelId> parsed = new ArrayList<FullModelId>();
        for (String s : fmis) {
            parsed.add(FullModelId.parse(s));
        }
        logger.debug((Object)("Creating ensemble : model_ids : " + modelIds));
        this.predictionService.createEnsemble(user, loc, acp, parsed, EnsembleParams.EnsembleMethod.valueOf(method));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/pml/save-costmatrix-weights"})
    public void saveCostMatrixWeights(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String data) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        MetricParams.CostMatrixWeights cmw = (MetricParams.CostMatrixWeights)JSON.parse((String)data, MetricParams.CostMatrixWeights.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, fmi.getProjectKey(), Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            PredictionMLTask.ClassicalPredictionMLTask task = (PredictionMLTask.ClassicalPredictionMLTask)this.analysisCRUDService.getPMLTask(fmi.getTaskLoc());
            task.modeling.metrics.costMatrixWeights = cmw;
            this.analysisCRUDService.saveMLTask(fmi.getTaskLoc(), task, true);
            t.commit("Saved new cost matrix weights in " + fullModelId);
        }
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-deploy", "modelId", "${fullModelId}", "datasetRef", "${trainDatasetSmartName}"})
    @RequestMapping(value={"/api/analysis/pml/flow/deploy-train"})
    public void deployTrainPrepare(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String trainDatasetSmartName, @RequestParam(required=false) String testDatasetSmartName, @RequestParam String modelName, @RequestParam(required=false) String managedFolderSmartId, @RequestParam String options) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        if (fmi.isModelPartition()) {
            throw ErrorContext.iae((String)"Can't deploy a model partition");
        }
        String projectKey = fmi.getTaskLoc().analysisProjectKey;
        PredictionRecipesService.TrainingRecipeCreationOptions optionsObj = (PredictionRecipesService.TrainingRecipeCreationOptions)JSON.parse((String)options, PredictionRecipesService.TrainingRecipeCreationOptions.class);
        AuthCtx user = null;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = this.authService.getMandatoryUser(req);
        }
        DatasetLocUtils.DatasetLoc trainLoc = DatasetLocUtils.resolveSmart(projectKey, trainDatasetSmartName);
        DatasetLocUtils.DatasetLoc testLoc = null;
        if (!StringUtils.isBlank((String)testDatasetSmartName)) {
            testLoc = DatasetLocUtils.resolveSmart(projectKey, testDatasetSmartName);
        }
        AnyLoc folder = null;
        if (!StringUtils.isBlank((String)managedFolderSmartId)) {
            folder = AnyLoc.resolveSmart(projectKey, managedFolderSmartId);
        }
        AnalysisPredictionController.writeJSON((HttpServletResponse)resp, this.trainingRecipeService.createTrainingRecipePrep_NT(user, fmi, trainLoc, testLoc, optionsObj, modelName, folder));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/pml/flow/list-redeployable-train"})
    public void redeployableTrainPrepare(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId) throws Exception {
        FullModelId fmi = FullModelId.parse(fullModelId);
        String projectKey = fmi.getTaskLoc().analysisProjectKey;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            MLTask mlTask = fmi.getHeadMLTask();
            assert (mlTask.taskType.equals((Object)MLTask.MLTaskType.PREDICTION));
            PredictionMLTask pmlTask = (PredictionMLTask)mlTask;
            Map<SerializedRecipe, SavedModel> models = this.trainingRecipeService.listUpdatableTrain(projectKey, pmlTask);
            ArrayList<SavedModelsController.ReplaceableSavedModel> results = new ArrayList<SavedModelsController.ReplaceableSavedModel>(models.size());
            for (Map.Entry<SerializedRecipe, SavedModel> entry : models.entrySet()) {
                SerializedRecipe recipe = entry.getKey();
                SavedModel model = entry.getValue();
                if (pmlTask.isPartitioned() != model.isPartitioned()) continue;
                SavedModelsController.ReplaceableSavedModel rsm = new SavedModelsController.ReplaceableSavedModel();
                rsm.inputDatasetName = recipe.getInputsForRole((String)"main").get((int)0).ref;
                rsm.recipeName = recipe.name;
                rsm.savedModel = model;
                results.add(rsm);
            }
            AnalysisPredictionController.writeJSON((HttpServletResponse)resp, results);
        }
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-deploy", "modelId", "${fullModelId}", "recipeName", "${recipeName}"})
    @RequestMapping(value={"/api/analysis/pml/flow/redeploy-train"})
    public void redeployTrainPrepare(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String recipeName, @RequestParam boolean activate, @RequestParam String options) throws Exception {
        SerializedRecipe recipe;
        AuthCtx user;
        FullModelId fmi = FullModelId.parse(fullModelId);
        if (fmi.isModelPartition()) {
            throw ErrorContext.iae((String)"Can't redeploy a model partition");
        }
        String projectKey = fmi.getTaskLoc().analysisProjectKey;
        PredictionRecipesService.TrainingRecipeCreationOptions optionsObj = (PredictionRecipesService.TrainingRecipeCreationOptions)JSON.parse((String)options, PredictionRecipesService.TrainingRecipeCreationOptions.class);
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            user = this.authService.getMandatoryUser(req);
            recipe = (SerializedRecipe)this.recipesDAO.getMandatory(projectKey, recipeName);
        }
        boolean schemaChanged = this.trainingRecipeService.updateTrainingRecipePrep_NT(user, fmi, recipe, activate, optionsObj);
        AnalysisPredictionController.writeJSONString((HttpServletResponse)resp, (String)("{\"schemaChanged\":" + schemaChanged + "}"));
    }

    @AuditedCall(value={"msgType", "analysis-prediction-task-deploy-notebook", "modelId", "${fullModelId}"})
    @RequestMapping(value={"/api/analysis/pml/create-notebook"})
    public void deployNotebook(HttpServletRequest req, HttpServletResponse resp, @RequestParam String fullModelId, @RequestParam String notebookTitle) throws Exception {
        Callable<PredictionService.NotebookToSave> nbkFuture;
        FullModelId fmi = FullModelId.parse(fullModelId);
        String projectKey = fmi.getTaskLoc().analysisProjectKey;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            nbkFuture = this.predictionService.createJupyterNotebook(fmi, notebookTitle, authCtx);
        }
        PredictionService.NotebookToSave nbk = nbkFuture.call();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            t.writeStringUTF8(nbk.newNotebookFile, nbk.jsonContent);
            t.commit("Created a Jupyter notebook from model " + fullModelId);
            AnalysisPredictionController.writeJSON((HttpServletResponse)resp, (Object)new Id(nbk.transmogrifiedTitle));
        }
    }

    @AuditedCall(value={"msgType", "analysis-ml-copy-algo", "projectKeyFrom", "${projectKeyFrom}", "analysisIdFrom", "${analysisIdFrom}", "mlTaskIdFrom", "${mlTaskIdFrom}", "projectKeyTo", "${projectKeyTo}", "analysisIdTo", "${analysisIdTo}", "mlTaskIdTo", "${mlTaskIdTo}"})
    @RequestMapping(value={"/api/analysis/pml/copy-algorithm-settings"})
    public void copyAlgorithmSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKeyFrom, @RequestParam String analysisIdFrom, @RequestParam String mlTaskIdFrom, @RequestParam String projectKeyTo, @RequestParam String analysisIdTo, @RequestParam String mlTaskIdTo) throws Exception {
        PredictionMLTask taskTo;
        AnalysisCoreParams acp;
        MLTaskLoc locTo;
        PredictionMLTask taskFrom;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKeyFrom, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            MLTaskLoc locFrom = new MLTaskLoc(projectKeyFrom, analysisIdFrom, mlTaskIdFrom);
            taskFrom = this.analysisCRUDService.getPMLTask(locFrom);
            this.projectsService.checkPerm(req, projectKeyTo, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            locTo = new MLTaskLoc(projectKeyTo, analysisIdTo, mlTaskIdTo);
            acp = this.analysisCRUDService.getCoreMandatory(projectKeyTo, analysisIdTo);
            taskTo = this.analysisCRUDService.getPMLTask(locTo);
        }
        assert (taskFrom.predictionType.canCopySettings(taskTo.predictionType));
        assert (taskFrom.backendType == taskTo.backendType);
        if (taskFrom instanceof PredictionMLTask.TabularPredictionMLTask) {
            PredictionMLTask.TabularPredictionMLTask mlTaskTo = (PredictionMLTask.TabularPredictionMLTask)taskTo;
            PredictionMLTask.TabularPredictionMLTask mlTaskFrom = (PredictionMLTask.TabularPredictionMLTask)taskFrom;
            PredictionModelingParams modelingTo = mlTaskTo.modeling;
            PredictionModelingParams.GridSearchParams searchParams = (PredictionModelingParams.GridSearchParams)JSON.deepCopy((Object)modelingTo.gridSearchParams);
            boolean gridSearch = modelingTo.grid_search;
            MetricParams metrics = (MetricParams)JSON.deepCopy((Object)modelingTo.metrics);
            mlTaskTo.modeling = (PredictionModelingParams)JSON.deepCopy((Object)mlTaskFrom.modeling);
            mlTaskTo.modeling.grid_search = gridSearch;
            mlTaskTo.modeling.gridSearchParams = searchParams;
            mlTaskTo.modeling.metrics = metrics;
            if (taskFrom instanceof PredictionMLTask.ClassicalPredictionMLTask) {
                this.predictionService.fixUpAlgoDifferentPredType((PredictionMLTask.ClassicalPredictionMLTask)mlTaskTo, u, acp);
            }
        }
        try (RWTransaction rw = this.transactionService.beginWriteAsLoggedInUser(u);){
            this.analysisCRUDService.saveMLTask(locTo, taskTo, true);
            rw.commit("Copied algorithm settings from " + taskFrom.id + " to " + taskTo.id);
        }
        AnalysisPredictionController.writeJSON((HttpServletResponse)resp, (Object)taskTo);
    }

    @AuditNotNeeded
    @ResponseBody
    @RequestMapping(value={"/api/analysis/pml/list-algos-incompatible-with-search-strategy"})
    public HashMap<String, String> listAlgosIncompatibleWithSearchStrategy(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String taskString) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        MLTask mlTask = (MLTask)JSON.parse((String)taskString, MLTask.class);
        HashMap<String, String> algosIncompatibleWithSearchStrategy = new HashMap<String, String>();
        if (mlTask instanceof PredictionMLTask.TabularPredictionMLTask) {
            algosIncompatibleWithSearchStrategy = this.predictionService.listAlgosIncompatibleWithSearchStrategy((PredictionMLTask.TabularPredictionMLTask)mlTask);
        }
        return algosIncompatibleWithSearchStrategy;
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/pml/is-hp-search-needed"}, method={RequestMethod.POST})
    public void isHPSearchNeeded(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String taskString) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        PredictionMLTask pmlTask = (PredictionMLTask)JSON.parse((String)taskString, MLTask.class);
        boolean isHPSearchNeeded = false;
        if (pmlTask instanceof PredictionMLTask.TabularPredictionMLTask) {
            isHPSearchNeeded = PredictionService.isHPSearchNeeded((PredictionMLTask.TabularPredictionMLTask)pmlTask);
        }
        AnalysisPredictionController.writeJSON((HttpServletResponse)resp, Collections.singletonMap("isHPSearchNeeded", isHPSearchNeeded));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/pml/treated-control-stats"}, method={RequestMethod.GET})
    @ResponseBody
    public OutcomeStats getStatsForTreatedAndControlRows(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId, @RequestParam String controlValue, @RequestParam boolean dropMissingValues) throws Exception {
        PredictionMLTask pml;
        AnalysisCoreParams acp;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            user = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
            pml = this.analysisCRUDService.getPMLTask(loc);
        }
        if (!(pml instanceof PredictionMLTask.CausalPredictionMLTask)) {
            throw new IllegalArgumentException(String.format("Unsupported prediction type: %s", new Object[]{pml.predictionType}));
        }
        PredictionMLTask.CausalPredictionMLTask causalPredictionMLTask = (PredictionMLTask.CausalPredictionMLTask)pml;
        return this.predictionService.getOutcomeStatsByTreatedState(user, acp, causalPredictionMLTask, controlValue, dropMissingValues);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/analysis/pml/treated-col-values"}, method={RequestMethod.GET})
    @ResponseBody
    public Set<String> getTreatmentColValues(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String analysisId, @RequestParam String mlTaskId) throws Exception {
        PredictionMLTask pml;
        AnalysisCoreParams acp;
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            user = this.authService.getMandatoryUser(req);
            acp = this.analysisCRUDService.getCoreMandatory(projectKey, analysisId);
            MLTaskLoc loc = new MLTaskLoc(projectKey, analysisId, mlTaskId);
            pml = this.analysisCRUDService.getPMLTask(loc);
        }
        if (!(pml instanceof PredictionMLTask.CausalPredictionMLTask)) {
            throw new IllegalArgumentException(String.format("Unsupported prediction type: %s", new Object[]{pml.predictionType}));
        }
        PredictionMLTask.CausalPredictionMLTask causalPredictionMLTask = (PredictionMLTask.CausalPredictionMLTask)pml;
        return this.predictionService.getTreatmentColValues(user, acp, causalPredictionMLTask);
    }

    static class DuplicationResult {
        boolean success;
        Id newMlTaskId;
        Set<String> possibleTargets;

        DuplicationResult() {
        }
    }
}

