/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.eda;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.eda.compute.sampling.DataSpec;
import com.dataiku.dip.eda.compute.sampling.Sample;
import com.dataiku.dip.eda.compute.sampling.SamplesService;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/eda/compute/samples"})
public class SamplesController
extends DIPInternalControllerBase {
    @Autowired
    UIAuthService authService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    PermissionsService permissionsService;
    @Autowired
    SamplesService samplesService;
    @Autowired
    ProjectsService projectsService;
    @Autowired
    AuditTrailService auditTrailService;
    @Autowired
    DatasetAccessService datasetAccessService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.eda.samples");

    @AuditInline
    @RequestMapping(value={"/rebuild"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<Sample> buildSample(HttpServletRequest req, @RequestParam TaggableObjectsService.TaggableObjectRef key, @RequestParam DataSpec dataSpec) throws Exception {
        FutureResponse<Sample> futureResponse;
        block8: {
            logger.infoV("(Re)Build sample for %s", new Object[]{key});
            logger.debugV("Data spec:", new Object[]{JSON.pretty((Object)dataSpec)});
            AnyLoc datasetLoc = DatasetLocUtils.DatasetLoc.resolveSmart(key.projectKey, dataSpec.inputDatasetSmartName);
            Transaction t = this.transactionService.beginRead();
            try {
                DSSAuthCtx authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
                this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, key.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                this.projectsService.failIfNoDatasetReadUseAccess(authCtx, datasetLoc, key.projectKey);
                Dataset dataset = this.datasetAccessService.getMandatoryUnsafe(datasetLoc);
                this.permissionsService.checkUserDefinedCustomSqlFilters(authCtx, dataset, dataSpec.datasetSelection);
                FutureResponse<Sample> futureSample = this.samplesService.buildSampleInFuture(authCtx, key, dataSpec);
                this.auditTrailService.generic("statistics-sample-build").with("dataSpec", JSON.toJsonObject((Object)dataSpec)).with("sampleKey", JSON.toJsonObject((Object)key)).emit();
                futureResponse = futureSample;
                if (t == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.auditTrailService.failure("statistics-sample-build", (Throwable)e).with("dataSpec", JSON.toJsonObject((Object)dataSpec)).with("sampleKey", JSON.toJsonObject((Object)key)).emit();
                    throw e;
                }
            }
            t.close();
        }
        return futureResponse;
    }

    @AuditInline
    @RequestMapping(value={"/current"}, method={RequestMethod.POST})
    @ResponseBody
    public Sample getCurrentSample(HttpServletRequest req, @RequestParam TaggableObjectsService.TaggableObjectRef key, @RequestParam DataSpec dataSpec) throws Exception {
        logger.infoV("Get current sample for %s", new Object[]{key});
        logger.debugV("Data spec:", new Object[]{JSON.pretty((Object)dataSpec)});
        AnyLoc datasetLoc = DatasetLocUtils.DatasetLoc.resolveSmart(key.projectKey, dataSpec.inputDatasetSmartName);
        try {
            DSSAuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
                this.permissionsService.checkProjectPrivileges((AuthCtx)authCtx, key.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                this.projectsService.failIfNoDatasetReadUseAccess(authCtx, datasetLoc, key.projectKey);
            }
            Sample sample = this.samplesService.getCurrentSample_NT(authCtx, key, dataSpec);
            this.auditTrailService.generic("statistics-sample-get").with("dataSpec", JSON.toJsonObject((Object)dataSpec)).with("sampleKey", JSON.toJsonObject((Object)key)).emit();
            return sample;
        }
        catch (Exception e) {
            this.auditTrailService.failure("statistics-sample-get", (Throwable)e).with("dataSpec", JSON.toJsonObject((Object)dataSpec)).with("sampleKey", JSON.toJsonObject((Object)key)).emit();
            throw e;
        }
    }
}

