/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataquality.DataQualityRunOrigin;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.MetricsService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.Check;
import com.dataiku.dip.metrics.checks.ExternalCheck;
import com.dataiku.dip.metrics.engines.PythonProbeEngine;
import com.dataiku.dip.metrics.probes.ExternalProbeType;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.dataquality.DataQualityService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class MetricsIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService;
    @Autowired
    private MetricsService metricsService;
    @Autowired
    private MetricsComputationService metricsComputationService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DataQualityService dataQualityService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.metrics.intercom");

    @AuditedCall(value={"msgType", "dataset-read-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/tintercom/metrics/datasets/get-last-values"})
    @ResponseBody
    public MetricsService.ComputedMetrics getLastValuesOnDataset(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam(required=false) String partition) throws Exception {
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, datasetName);
            this.permissionsService.checkDatasetPrivileges(authCtxUsage.getAuthCtx(), loc, Privileges.DatasetLevelPrivilegeType.READ_METADATA);
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        MetricsService.ComputedMetrics list = this.metricsService.listComputedMetrics_NT(dataset, MetricTargetType.DATASET, null, true);
        if (StringUtils.isNotBlank((String)partition)) {
            MetricsService.ComputedMetrics restricted = new MetricsService.ComputedMetrics();
            for (MetricsService.ComputedMetric computedMetric : list.metrics) {
                String matches = null;
                for (String computedMetricPartition : computedMetric.partitionsWithValue) {
                    if (!partition.equals(computedMetricPartition)) continue;
                    matches = computedMetricPartition;
                    break;
                }
                if (matches == null) continue;
                computedMetric.partitionsWithValue = Lists.newArrayList((Object[])new String[]{matches});
                restricted.metrics.add(computedMetric);
            }
            return restricted;
        }
        return list;
    }

    @AuditedCall(value={"msgType", "dataset-read-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/tintercom/checks/datasets/get-last-values"})
    @ResponseBody
    public MetricsService.ComputedChecks getLastChecksValuesOnDataset(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam(required=false) String partition) throws Exception {
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, datasetName);
            this.permissionsService.checkDatasetPrivileges(authCtxUsage.getAuthCtx(), loc, Privileges.DatasetLevelPrivilegeType.READ_METADATA);
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        MetricsService.ComputedChecks list = this.metricsService.listComputedChecks_NT(dataset, MetricTargetType.DATASET, null, true);
        if (StringUtils.isNotBlank((String)partition)) {
            MetricsService.ComputedChecks restricted = new MetricsService.ComputedChecks();
            for (MetricsService.ComputedCheck computedCheck : list.checks) {
                String matches = null;
                for (String computedCheckPartition : computedCheck.partitionsWithValue) {
                    if (!partition.equals(computedCheckPartition)) continue;
                    matches = computedCheckPartition;
                    break;
                }
                if (matches == null) continue;
                computedCheck.partitionsWithValue = Lists.newArrayList((Object[])new String[]{matches});
                restricted.checks.add(computedCheck);
            }
            return restricted;
        }
        return list;
    }

    @AuditedCall(value={"msgType", "folder-read-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/tintercom/metrics/managed-folders/get-last-values"})
    @ResponseBody
    public MetricsService.ComputedMetrics getLastValuesOnFolder(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam(required=false) String partitionId) throws Exception {
        ManagedFolder folder;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            folder = (ManagedFolder)this.managedFolderDAO.getOrNull(projectKey, folderId);
            if (folder == null) {
                throw new NotFoundException("Folder '" + folderId + "' does not exist");
            }
        }
        Partition partition = MetricsComputationService.makePartitionFromId(folder.getPartitioningSchema(), partitionId);
        return this.metricsService.listComputedMetrics_NT(folder, MetricTargetType.MANAGED_FOLDER, partition, null, true);
    }

    @AuditedCall(value={"msgType", "folder-read-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/tintercom/checks/managed-folders/get-last-values"})
    @ResponseBody
    public MetricsService.ComputedChecks getLastChecksValuesOnFolder(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam(required=false) String partitionId) throws Exception {
        ManagedFolder folder;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            folder = (ManagedFolder)this.managedFolderDAO.getOrNull(projectKey, folderId);
            if (folder == null) {
                throw new NotFoundException("Folder '" + folderId + "' does not exist");
            }
        }
        MetricsService.ComputedChecks list = this.metricsService.listComputedChecks_NT(folder, MetricTargetType.MANAGED_FOLDER, null, true);
        if (StringUtils.isNotBlank((String)partitionId)) {
            MetricsService.ComputedChecks restricted = new MetricsService.ComputedChecks();
            for (MetricsService.ComputedCheck computedCheck : list.checks) {
                String matches = null;
                for (String computedCheckPartition : computedCheck.partitionsWithValue) {
                    if (!partitionId.equals(computedCheckPartition)) continue;
                    matches = computedCheckPartition;
                    break;
                }
                if (matches == null) continue;
                computedCheck.partitionsWithValue = Lists.newArrayList((Object[])new String[]{matches});
                restricted.checks.add(computedCheck);
            }
            return restricted;
        }
        return list;
    }

    @AuditedCall(value={"msgType", "folder-read-status", "projectKey", "${projectKey}", "mesId", "${mesId}"})
    @RequestMapping(value={"/api/tintercom/metrics/modelevaluationstores/get-last-values"})
    @ResponseBody
    public MetricsService.ComputedMetrics getLastValuesOnMES(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String mesId) throws Exception {
        String latestRunId;
        ModelEvaluationStore mes;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            mes = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getMandatoryUnsafe(projectKey, mesId);
            latestRunId = this.modelEvaluationStoresCRUDService.getLatestEvaluationId(projectKey, mesId);
        }
        Partition partition = MetricsComputationService.fakeMEVersionPartition(latestRunId);
        return this.metricsService.listComputedMetrics_NT(mes, MetricTargetType.MODEL_EVALUATION_STORE, partition, null, true);
    }

    @AuditedCall(value={"msgType", "project-read-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/metrics/projects/get-last-values"})
    @ResponseBody
    public MetricsService.ComputedMetrics getLastValuesOnProject(HttpServletRequest req, @RequestParam String projectKey) throws Exception {
        SerializedProject project;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            project = this.projectsDAO.getOrNull(projectKey);
            if (project == null) {
                throw new NotFoundException("Project '" + projectKey + "' does not exist");
            }
        }
        return this.metricsService.listComputedMetrics_NT(project, MetricTargetType.PROJECT, null, true);
    }

    @AuditedCall(value={"msgType", "project-read-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/checks/projects/get-last-values"})
    @ResponseBody
    public MetricsService.ComputedChecks getLastChecksOnProject(HttpServletRequest req, @RequestParam String projectKey) throws Exception {
        SerializedProject project;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            project = this.projectsDAO.getOrNull(projectKey);
            if (project == null) {
                throw new NotFoundException("Project '" + projectKey + "' does not exist");
            }
        }
        return this.metricsService.listComputedChecks_NT(project, MetricTargetType.PROJECT, null, true);
    }

    @AuditedCall(value={"msgType", "dataset-read-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/tintercom/metrics/datasets/get-metric-history"})
    @ResponseBody
    public MetricsService.MetricHistoryData getHistoryValuesOnDataset(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam(required=false) String partition, @RequestParam String metricLookup) throws Exception {
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, datasetName);
            this.permissionsService.checkDatasetPrivileges(authCtxUsage.getAuthCtx(), loc, Privileges.DatasetLevelPrivilegeType.READ_METADATA);
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        Partition p = MetricsComputationService.makePartitionFromId(dataset.getPartitioningSchema(), partition);
        Map<String, Metric> lastMetrics = this.metricsService.getLastKnownMetrics_NT(dataset, MetricTargetType.DATASET);
        Metric lookedUpMetric = MetricsService.lookupMetric(metricLookup, lastMetrics);
        if (lookedUpMetric == null) {
            throw new NotFoundException("Metric: '" + metricLookup + "' does not exist on dataset " + dataset.getFullName() + ".");
        }
        return this.metricsService.getMetricData_NT(dataset, MetricTargetType.DATASET, p, lookedUpMetric.getId(), true);
    }

    @AuditedCall(value={"msgType", "folder-read-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/tintercom/metrics/managed-folders/get-metric-history"})
    @ResponseBody
    public MetricsService.MetricHistoryData getHistoryValuesOnFolder(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam(required=false) String partitionId, @RequestParam String metricLookup) throws Exception {
        ManagedFolder folder;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            folder = (ManagedFolder)this.managedFolderDAO.getOrNull(projectKey, folderId);
            if (folder == null) {
                throw new IllegalArgumentException("Folder '" + folderId + "' does not exist");
            }
        }
        Partition partition = MetricsComputationService.makePartitionFromId(folder.getPartitioningSchema(), partitionId);
        Map<String, Metric> lastMetrics = this.metricsService.getLastKnownMetrics_NT(folder, MetricTargetType.MANAGED_FOLDER);
        Metric lookedUpMetric = MetricsService.lookupMetric(metricLookup, lastMetrics);
        if (lookedUpMetric == null) {
            throw new NotFoundException("Metric: '" + metricLookup + "' does not exist on folder " + folder.projectKey + "." + folder.id + ".");
        }
        return this.metricsService.getMetricData_NT(folder, MetricTargetType.MANAGED_FOLDER, partition, lookedUpMetric.getId(), true);
    }

    @AuditedCall(value={"msgType", "model-read-status", "projectKey", "${projectKey}", "modelId", "${modelId}"})
    @RequestMapping(value={"/api/tintercom/metrics/saved-models/get-values-for-version"})
    @ResponseBody
    public MetricsService.ComputedMetrics getValuesOnSMVersion(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String modelId, @RequestParam String modelVersionId) throws Exception {
        SavedModel sm;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, modelId);
        }
        MetricsService.ComputedMetrics list = this.metricsService.listComputedMetrics_NT(sm, MetricTargetType.SAVED_MODEL, null, true);
        logger.infoV("Get version values for model %s (v %s): %s", new Object[]{sm.id, modelVersionId, JSON.json((Object)list)});
        MetricsService.ComputedMetrics restricted = new MetricsService.ComputedMetrics();
        for (MetricsService.ComputedMetric computedMetric : list.metrics) {
            String matches = null;
            for (String computedMetricPartition : computedMetric.partitionsWithValue) {
                if (!modelVersionId.equals(computedMetricPartition)) continue;
                matches = computedMetricPartition;
                break;
            }
            if (matches == null) continue;
            computedMetric.partitionsWithValue = Lists.newArrayList((Object[])new String[]{matches});
            restricted.metrics.add(computedMetric);
        }
        return restricted;
    }

    @AuditedCall(value={"msgType", "model-read-status", "projectKey", "${projectKey}", "modelId", "${modelId}"})
    @RequestMapping(value={"/api/tintercom/checks/saved-models/get-values-for-version"})
    @ResponseBody
    public MetricsService.ComputedChecks getChecksValuesOnSMVersion(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String modelId, @RequestParam String modelVersionId) throws Exception {
        SavedModel sm;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            sm = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, modelId);
        }
        MetricsService.ComputedChecks list = this.metricsService.listComputedChecks_NT(sm, MetricTargetType.SAVED_MODEL, null, true);
        logger.infoV("Get version values for model %s (v %s): %s", new Object[]{sm.id, modelVersionId, JSON.json((Object)list)});
        MetricsService.ComputedChecks restricted = new MetricsService.ComputedChecks();
        for (MetricsService.ComputedCheck computedCheck : list.checks) {
            String matches = null;
            for (String computedMetricPartition : computedCheck.partitionsWithValue) {
                if (!modelVersionId.equals(computedMetricPartition)) continue;
                matches = computedMetricPartition;
                break;
            }
            if (matches == null) continue;
            computedCheck.partitionsWithValue = Lists.newArrayList((Object[])new String[]{matches});
            restricted.checks.add(computedCheck);
        }
        return restricted;
    }

    @AuditedCall(value={"msgType", "folder-read-status", "projectKey", "${projectKey}", "mesId", "${mesId}"})
    @RequestMapping(value={"/api/tintercom/metrics/modelevaluationstores/get-metric-history"})
    @ResponseBody
    public MetricsService.MetricHistoryData getHistoryValuesOnMES(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String mesId, @RequestParam String metricLookup) throws Exception {
        ModelEvaluationStore mes;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            mes = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getMandatoryUnsafe(projectKey, mesId);
        }
        Map<String, Metric> lastMetrics = this.metricsService.getLastKnownMetrics_NT(mes, MetricTargetType.MODEL_EVALUATION_STORE);
        Metric lookedUpMetric = MetricsService.lookupMetric(metricLookup, lastMetrics);
        if (lookedUpMetric == null) {
            throw new NotFoundException("Metric: '" + metricLookup + "' does not exist on model evaluation store " + mes.projectKey + "." + mes.id + ".");
        }
        return this.metricsService.getMetricData_NT(mes, MetricTargetType.MODEL_EVALUATION_STORE, null, lookedUpMetric.getId(), true);
    }

    @AuditedCall(value={"msgType", "project-read-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/metrics/projects/get-metric-history"})
    @ResponseBody
    public MetricsService.MetricHistoryData getHistoryValuesOnProject(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String metricLookup) throws Exception {
        SerializedProject project;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            project = this.projectsDAO.getOrNull(projectKey);
            if (project == null) {
                throw new IllegalArgumentException("Project '" + projectKey + "' does not exist");
            }
        }
        Map<String, Metric> lastMetrics = this.metricsService.getLastKnownMetrics_NT(project, MetricTargetType.PROJECT);
        Metric lookedUpMetric = MetricsService.lookupMetric(metricLookup, lastMetrics);
        if (lookedUpMetric == null) {
            throw new NotFoundException("Metric: '" + metricLookup + "' does not exist on project " + project.projectKey + ".");
        }
        return this.metricsService.getMetricData_NT(project, MetricTargetType.PROJECT, null, lookedUpMetric.getId(), true);
    }

    @AuditedCall(value={"msgType", "project-read-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/checks/projects/get-metric-history"})
    @ResponseBody
    public MetricsService.CheckHistoryData getHistoryChecksOnProject(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String checkLookup) throws Exception {
        SerializedProject project;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            project = this.projectsDAO.getOrNull(projectKey);
            if (project == null) {
                throw new IllegalArgumentException("Project '" + projectKey + "' does not exist");
            }
        }
        Map<String, Check> lastChecks = this.metricsService.getLastKnownProjectChecks_NT(project);
        Check lookedUpCheck = MetricsService.lookupCheck(checkLookup, lastChecks);
        if (lookedUpCheck == null) {
            throw new NotFoundException("Check: '" + checkLookup + "' does not exist on project " + project.projectKey + ".");
        }
        return this.metricsService.getCheckData_NT(project, MetricTargetType.PROJECT, null, lookedUpCheck.getId(), true);
    }

    @AuditedCall(value={"msgType", "dataset-save-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/tintercom/metrics/datasets/save-external-values"})
    public void saveDatasetMetrics(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam(required=false) String partitionId, @RequestParam String data, @RequestParam(required=false) String typesData) throws Exception {
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, datasetName);
            this.permissionsService.checkDatasetPrivileges(authCtxUsage.getAuthCtx(), loc, Privileges.DatasetLevelPrivilegeType.WRITE_METADATA);
            Dataset dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            Partition partition = MetricsComputationService.makePartitionFromId(dataset.getPartitioningSchema(), partitionId);
            Map results = (Map)JSON.parse((String)data, (TypeToken)new TypeToken<Map<String, Object>>(){});
            HashMap<String, String> types = StringUtils.isBlank((String)typesData) ? new HashMap<String, String>() : (Map)JSON.parse((String)typesData, (TypeToken)new TypeToken<Map<String, String>>(){});
            Probe externalProbe = new Probe("external").withConfiguration(new ExternalProbeType.ExternalProbeConfiguration());
            Map<Metric, String> metricsValues = PythonProbeEngine.makeMetricsValuesFromObjectMap(dataset, MetricTargetType.DATASET, externalProbe, results, types);
            this.metricsComputationService.saveMetricsValues(authCtxUsage.getAuthCtx(), dataset, MetricTargetType.DATASET, partition, DateTime.now(), metricsValues, this.buildMetricsEnvironment());
            MetricsIntercomController.writeJSON((HttpServletResponse)resp, (Object)"{}");
        }
    }

    @AuditedCall(value={"msgType", "dataset-save-status", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/api/tintercom/checks/datasets/save-external-values"})
    public void saveDatasetChecks(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam(required=false) String partitionId, @RequestParam String data) throws Exception {
        SerializedDataset dataset;
        Map results = (Map)JSON.parse((String)data, (TypeToken)new TypeToken<Map<String, Object>>(){});
        AuthCtx authCtx = this.authService.getTicketOrKeyAndContext(req).getAuthCtx();
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            dataset = (SerializedDataset)this.datasetsDAO.getMandatory(projectKey, datasetName);
            this.dataQualityService.saveExternalRulesIfNotExists(dataset, new HashSet<String>(results.keySet()), authCtx);
            t.commit("Save external rules on dataset " + datasetName);
        }
        Partition partition = MetricsComputationService.makePartitionFromId(dataset.partitioning, partitionId);
        Map<Check, AbstractCheckContext.CheckResult> checksValues = ExternalCheck.makeChecksValuesFromObjectMap(results);
        this.metricsComputationService.saveChecksValues(dataset.projectKey, dataset.name, partition, DateTime.now(), checksValues, new DataQualityRunOrigin.External());
        this.dataQualityService.updateDatasetStatusForPartitionsCascade_NT(dataset, Collections.singletonList(partition.id()));
        MetricsIntercomController.writeJSON((HttpServletResponse)resp, (Object)"{}");
    }

    @AuditedCall(value={"msgType", "folder-save-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/tintercom/metrics/managed-folders/save-external-values"})
    public void saveFolderMetrics(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam(required=false) String partitionId, @RequestParam String data, @RequestParam(required=false) String typesData) throws Exception {
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            ManagedFolder folder = (ManagedFolder)this.managedFolderDAO.getMandatory(projectKey, folderId);
            Partition partition = MetricsComputationService.makePartitionFromId(folder.getPartitioningSchema(), partitionId);
            Map results = (Map)JSON.parse((String)data, (TypeToken)new TypeToken<Map<String, Object>>(){});
            HashMap<String, String> types = StringUtils.isBlank((String)typesData) ? new HashMap<String, String>() : (Map)JSON.parse((String)typesData, (TypeToken)new TypeToken<Map<String, String>>(){});
            Probe externalProbe = new Probe("external").withConfiguration(new ExternalProbeType.ExternalProbeConfiguration());
            Map<Metric, String> metricsValues = PythonProbeEngine.makeMetricsValuesFromObjectMap(folder, MetricTargetType.MANAGED_FOLDER, externalProbe, results, types);
            this.metricsComputationService.saveMetricsValues(authCtxUsage.getAuthCtx(), folder, MetricTargetType.MANAGED_FOLDER, partition, DateTime.now(), metricsValues, this.buildMetricsEnvironment());
            MetricsIntercomController.writeJSON((HttpServletResponse)resp, (Object)"{}");
        }
    }

    @AuditedCall(value={"msgType", "folder-save-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/tintercom/checks/managed-folders/save-external-values"})
    public void saveFolderChecks(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String folderId, @RequestParam(required=false) String partitionId, @RequestParam String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            ManagedFolder folder = (ManagedFolder)this.managedFolderDAO.getMandatory(projectKey, folderId);
            Partition partition = MetricsComputationService.makePartitionFromId(folder.getPartitioningSchema(), partitionId);
            Map results = (Map)JSON.parse((String)data, (TypeToken)new TypeToken<Map<String, Object>>(){});
            Map<Check, AbstractCheckContext.CheckResult> checksValues = ExternalCheck.makeChecksValuesFromObjectMap(results);
            this.metricsComputationService.saveChecksValues(folder.projectKey, folder.id, partition, DateTime.now(), checksValues, new DataQualityRunOrigin.External());
            MetricsIntercomController.writeJSON((HttpServletResponse)resp, (Object)"{}");
        }
    }

    @AuditedCall(value={"msgType", "folder-save-status", "projectKey", "${projectKey}", "folderId", "${folderId}"})
    @RequestMapping(value={"/api/tintercom/checks/saved-models/save-external-values"})
    public void saveModelChecks(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String modelId, @RequestParam String modelVersionId, @RequestParam String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SavedModel model = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, modelId);
            Partition partition = MetricsComputationService.fakeSMVersionPartition(modelVersionId);
            Map results = (Map)JSON.parse((String)data, (TypeToken)new TypeToken<Map<String, Object>>(){});
            Map<Check, AbstractCheckContext.CheckResult> checksValues = ExternalCheck.makeChecksValuesFromObjectMap(results);
            this.metricsComputationService.saveChecksValues(model.projectKey, model.id, partition, DateTime.now(), checksValues, new DataQualityRunOrigin.External());
            MetricsIntercomController.writeJSON((HttpServletResponse)resp, (Object)"{}");
        }
    }

    @AuditedCall(value={"msgType", "project-save-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/metrics/projects/save-external-values"})
    public void saveProjectMetrics(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data, @RequestParam(required=false) String typesData) throws Exception {
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SerializedProject project = this.projectsDAO.getMandatory(projectKey);
            Map results = (Map)JSON.parse((String)data, (TypeToken)new TypeToken<Map<String, Object>>(){});
            HashMap<String, String> types = StringUtils.isBlank((String)typesData) ? new HashMap<String, String>() : (Map)JSON.parse((String)typesData, (TypeToken)new TypeToken<Map<String, String>>(){});
            Probe externalProbe = new Probe("external").withConfiguration(new ExternalProbeType.ExternalProbeConfiguration());
            Map<Metric, String> metricsValues = PythonProbeEngine.makeMetricsValuesFromObjectMap(project, MetricTargetType.PROJECT, externalProbe, results, types);
            this.metricsComputationService.saveMetricsValues(authCtxUsage.getAuthCtx(), project, MetricTargetType.PROJECT, null, DateTime.now(), metricsValues, this.buildMetricsEnvironment());
            MetricsIntercomController.writeJSON((HttpServletResponse)resp, (Object)"{}");
        }
    }

    @AuditedCall(value={"msgType", "project-save-status", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/tintercom/checks/projects/save-external-values"})
    public void saveProjectChecks(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data) throws Exception {
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            this.permissionsService.checkProjectPrivileges(authCtxUsage.getAuthCtx(), projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SerializedProject project = this.projectsDAO.getMandatory(projectKey);
            Map results = (Map)JSON.parse((String)data, (TypeToken)new TypeToken<Map<String, Object>>(){});
            Map<Check, AbstractCheckContext.CheckResult> checksValues = ExternalCheck.makeChecksValuesFromObjectMap(results);
            this.metricsComputationService.saveChecksValues(project.projectKey, null, null, DateTime.now(), checksValues, new DataQualityRunOrigin.External());
            MetricsIntercomController.writeJSON((HttpServletResponse)resp, (Object)"{}");
        }
    }

    private MetricsComputationService.MetricsComputationEnvironment buildMetricsEnvironment() throws IOException {
        MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
        environment.startedFromBuild = false;
        GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.read();
        environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
        environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
        return environment;
    }
}

