/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.dataflow.exec.CodeBasedRecipeDatasetInfoHelper;
import com.dataiku.dip.mec.EvaluationSamplingService;
import com.dataiku.dip.mec.KernelsModelEvaluationStoresService;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditObj;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.controllers.AuditTransformer;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.EvaluationCreatedEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ModelEvaluationStoresIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private KernelsModelEvaluationStoresService kernelModelEvaluationStoresService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private EvaluationSamplingService evaluationSamplingService;

    @AuditedCall(value={"msgType", "modelevaluationstore-read-meta", "projectKey", "${projectKey}", "lookup", "${lookup}"})
    @RequestMapping(value={"/api/tintercom/model-evaluation-stores/get-info"}, method={RequestMethod.POST})
    @ResponseBody
    public CodeBasedRecipeDatasetInfoHelper.LocationInfo getInfo(HttpServletRequest req, @RequestParam String projectKey, @RequestParam String lookup, @RequestParam(required=false) boolean sensitiveInfo) throws Exception {
        ModelEvaluationStore mes;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            mes = this.kernelModelEvaluationStoresService.lookupMandatoryUnsafe(projectKey, lookup);
        }
        return CodeBasedRecipeDatasetInfoHelper.getModelEvaluationStoreLocationInfo_NT(mes, sensitiveInfo);
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-read-data", "projectKey", "${projectKey}", "id", "${id}"})
    @RequestMapping(value={"/api/tintercom/model-evaluation-stores/list-runs"}, method={RequestMethod.POST})
    public void listRuns(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id) throws Exception {
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ModelEvaluationStore mes = this.kernelModelEvaluationStoresService.getMandatoryUnsafe(projectKey, id);
            ModelEvaluationStoresIntercomController.writeJSON((HttpServletResponse)resp, this.kernelModelEvaluationStoresService.listEvaluations(mes));
        }
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-read-data", "projectKey", "${projectKey}", "id", "${id}", "evaluationId", "${evaluationId}"})
    @RequestMapping(value={"/api/tintercom/model-evaluation-stores/get-sample-schema"}, method={RequestMethod.POST})
    public void getSampleSchema(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id, @RequestParam String evaluationId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            ModelEvaluationStore mes = this.kernelModelEvaluationStoresService.getMandatoryUnsafe(projectKey, id);
            ModelEvaluationStoresIntercomController.writeJSON((HttpServletResponse)resp, (Object)this.evaluationSamplingService.getSampleSchema(mes, evaluationId));
        }
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-read-data", "projectKey", "${projectKey}", "id", "${id}", "evaluationId", "${evaluationId}"}, transformer=FullNameTransformer.class)
    @RequestMapping(value={"/api/tintercom/model-evaluation-stores/stream-prepared-sample"}, method={RequestMethod.POST})
    public void streamPreparedModelEvaluationSample(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id, @RequestParam String evaluationId, @RequestParam String script, @RequestParam String requestedOutputSchema, @RequestParam(value="contextProjectKey", required=false) String contextProjectKey) throws Exception {
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, id);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            this.kernelModelEvaluationStoresService.getMandatory(loc.getProjectKey(), loc.getName());
        }
        this.evaluationSamplingService.streamSample(authCtx, projectKey, loc, evaluationId, script, requestedOutputSchema, contextProjectKey, resp);
    }

    @AuditedCall(value={"msgType", "modelevaluationstore-new-evaluation", "projectKey", "${projectKey", "id", "${id}", "evaluationId", "${evaluationId}"})
    @RequestMapping(value={"/api/tintercom/model-evaluation-stores/new-evaluation"}, method={RequestMethod.POST})
    public void newEvaluation(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String id, @RequestParam String evaluationId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        this.pubSub.publish((DSSEvent)new EvaluationCreatedEvent(projectKey, id, evaluationId));
    }

    public static class FullNameTransformer
    implements AuditTransformer {
        public void transform(AuditObj obj) {
            if (obj.has(new String[]{"fullModelEvaluationStoreName"})) {
                AnyLoc loc = AnyLoc.resolveFull(obj.get().get("fullModelEvaluationStoreName").getAsString());
                obj.with("projectKey", loc.getProjectKey());
                obj.with("id", loc.getId());
            }
        }
    }
}

