/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.EventWithHumanReadableString;
import com.dataiku.dip.server.notifications.backend.ProjectEvent;
import com.dataiku.dip.server.notifications.backend.UserEvent;
import com.dataiku.dip.utils.NotImplementedException;

public class ExportStateChangedEvent
extends BackendEvent
implements UserEvent,
ProjectEvent,
EventWithHumanReadableString {
    public static final String NAME = "export-state-change";
    public final String type = "EXPORT";
    public final ExportStatus status;
    public final String user;

    public ExportStateChangedEvent(ExportStatus status) {
        this.status = status;
        this.user = status.userId;
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getUserLogin() {
        return this.status.userId;
    }

    @Override
    public String getProjectKey() {
        throw new NotImplementedException();
    }

    @Override
    public String toHumanReadableString(MarkupFormatter markup) {
        return String.format("Export %s for user %s: %s", markup.text(this.status.exportId), markup.user(this.user, null), markup.text((Object)this.status.state));
    }
}

