/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.EmailNotificationsSender;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.notifications.backend.InstanceAccessRequestEvent;
import com.dataiku.dip.server.notifications.emails.MessageContentBuilder;
import com.dataiku.dip.server.notifications.emails.TemplatedContent;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class InstanceAccessRequestEmailBuilder {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersService usersService;
    private GeneralSettingsDAO.GeneralSettings settings;
    private GeneralSettingsDAO.WhiteLabelingSettings whiteLabeling = new GeneralSettingsDAO.WhiteLabelingSettings();
    protected static final Logger logger = Logger.getLogger((String)"dku.notifications.instance-access-request-email-builder");

    public InstanceAccessRequestEmailBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    protected String makeSubject(PublicUser usr) {
        return usr.displayName + " requested access to this " + this.whiteLabeling.productLongName + " instance";
    }

    protected String makeBody(InstanceAccessRequestEvent evt, PublicUser usr) throws IOException, TemplateException {
        File templateFile = ApplicationConfigurator.getResourceFile((String[])new String[]{"notifications", "instance-access-request-email.ftl"});
        VariableLookup lookup = new VariableLookup();
        if (StringUtils.isNotBlank((String)evt.getRequestMessage())) {
            lookup.addVariable("message", evt.getRequestMessage());
        }
        lookup.addVariable("isRequestEmail", true);
        lookup.addVariable("studioExternalUrl", StringUtils.isBlank((String)this.settings.studioExternalUrl) ? null : this.settings.studioExternalUrl);
        lookup.addVariable("emailPreferencesLink", this.settings.studioExternalUrl + "/profile/");
        lookup.addVariable("title", "Access Request");
        lookup.addVariable("productLongName", this.whiteLabeling.productLongName);
        HrefContext href = new HrefContext(this.settings.studioExternalUrl);
        lookup.addVariable("requesterName", usr.displayName);
        lookup.addVariable("requesterLink", href.user(usr.login));
        lookup.addVariable("requestLink", href.request(evt.getRequestId()));
        lookup.addVariable("usersSecurityLinkName", "Edit users security settings");
        lookup.addVariable("usersSecurityLink", href.usersSettings());
        MessageContentBuilder.ExpandedTemplate expandedTemplate = new MessageContentBuilder(lookup).buildMessage(new TemplatedContent(), templateFile);
        return expandedTemplate.message;
    }

    public void sendToUser(InstanceAccessRequestEvent evt, String user) throws Exception {
        PublicUser dstUser;
        PublicUser srcUser;
        try (Transaction ignored = this.transactionService.beginRead();){
            srcUser = this.usersService.getPublicUser(evt.getUserLogin());
            dstUser = this.usersService.getPublicUser(user);
            if (StringUtils.isBlank((String)dstUser.email)) {
                return;
            }
            this.settings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            if (this.settings.whiteLabeling != null) {
                this.whiteLabeling = this.settings.whiteLabeling;
            }
        }
        UserSettingsService.EmailNotificationsSettings params = new UserSettingsService.EmailNotificationsSettings();
        params.enabled = true;
        params.subject = "Dataiku \u2022 " + this.makeSubject(srcUser);
        EmailNotificationsSender sender = new EmailNotificationsSender();
        logger.info((Object)("Sending email to " + dstUser.login));
        sender.sendToUser(dstUser.email, params, this.makeBody(evt, srcUser));
    }
}

