/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.requestcenter.RequestsService;
import com.dataiku.dip.server.notifications.backend.InstanceAccessRequestEvent;
import com.dataiku.dip.server.notifications.emails.InstanceAccessGrantedEmailBuilder;
import com.dataiku.dip.server.notifications.emails.InstanceAccessRequestEmailBuilder;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InstanceAccessRequestEmailSendService {
    @Autowired
    private PubSubService pubSubService;
    @Autowired
    private RequestsService requestsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UserSettingsService userSettingsService;
    private static final Logger logger = Logger.getLogger((String)"dku.notifications.instance-access-request-email");

    @PostConstruct
    public void init() {
        this.pubSubService.subscribe("instance-access-request", evt -> {
            Map<String, UserSettingsService.UserSettings> usersSettings;
            InstanceAccessRequestEmailBuilder emailBuilder = new InstanceAccessRequestEmailBuilder();
            List<String> logins = this.requestsService.getRequestTargets_NT(evt.getRequestType(), evt.getObjectType(), null);
            try (Transaction ignored = this.transactionService.beginRead();){
                usersSettings = this.userSettingsService.getForUsers(logins);
            }
            for (Map.Entry<String, UserSettingsService.UserSettings> userSettings : usersSettings.entrySet()) {
                String toUser = userSettings.getKey();
                if (!userSettings.getValue().instanceAccessRequestsEmails.enabled) continue;
                try {
                    emailBuilder.sendToUser((InstanceAccessRequestEvent)evt, toUser);
                }
                catch (Exception e) {
                    logger.warn((Object)("Failed to send email to " + toUser + " for instance access request"), (Throwable)e);
                }
            }
        });
        this.pubSubService.subscribe("instance-access-granted", evt -> {
            InstanceAccessGrantedEmailBuilder emailBuilder = new InstanceAccessGrantedEmailBuilder();
            String toUser = evt.getUserLogin();
            try {
                emailBuilder.sendToUser(toUser);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to send email to " + toUser + " for instance access request"), (Throwable)e);
            }
        });
    }
}

