/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.openapi;

import com.dataiku.dip.agents.tools.utils.JsonSchemaElement;
import com.dataiku.dip.server.openapi.OpenAPIHelper;
import com.dataiku.dss.shadelib.io.swagger.models.ArrayModel;
import com.dataiku.dss.shadelib.io.swagger.models.ComposedModel;
import com.dataiku.dss.shadelib.io.swagger.models.Model;
import com.dataiku.dss.shadelib.io.swagger.models.ModelImpl;
import com.dataiku.dss.shadelib.io.swagger.models.Operation;
import com.dataiku.dss.shadelib.io.swagger.models.Path;
import com.dataiku.dss.shadelib.io.swagger.models.RefModel;
import com.dataiku.dss.shadelib.io.swagger.models.Swagger;
import com.dataiku.dss.shadelib.io.swagger.models.parameters.BodyParameter;
import com.dataiku.dss.shadelib.io.swagger.models.properties.ArrayProperty;
import com.dataiku.dss.shadelib.io.swagger.models.properties.ObjectProperty;
import com.dataiku.dss.shadelib.io.swagger.models.properties.Property;
import com.dataiku.dss.shadelib.io.swagger.models.properties.RefProperty;
import com.dataiku.dss.shadelib.io.swagger.models.properties.StringProperty;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class SwaggerSchemaParser {
    private final Swagger swagger;

    public SwaggerSchemaParser(Swagger swagger) {
        this.swagger = swagger;
    }

    @Nullable
    public JsonSchemaElement parseInputSchema(String endpointId, LambdaEndpointConfig.EndpointType endpointType) {
        String endpointPath = OpenAPIHelper.getEndpointCallName(endpointId, endpointType);
        Path path = this.swagger.getPath(endpointPath);
        Operation operation = (Operation)path.getOperations().stream().findFirst().orElseThrow(() -> new IllegalArgumentException("You need to define an operation on your endpoint path %s".formatted(path.toString())));
        return operation.getParameters().stream().filter(param -> param instanceof BodyParameter).map(param -> (BodyParameter)param).map(body -> this.parseModel(body.getSchema())).findFirst().orElse(null);
    }

    private JsonSchemaElement parseModel(Model model) {
        if (model instanceof ModelImpl) {
            ModelImpl impl = (ModelImpl)model;
            String type = impl.getType();
            if ("string".equals(type)) {
                return JsonSchemaElement.string(impl.getDescription());
            }
            if ("integer".equals(type) || "number".equals(type)) {
                return JsonSchemaElement.number(impl.getDescription());
            }
            if ("boolean".equals(type)) {
                return JsonSchemaElement.bool(impl.getDescription());
            }
            JsonSchemaElement obj = JsonSchemaElement.object(impl.getDescription());
            Map props = impl.getProperties();
            List requiredList = impl.getRequired();
            if (props != null) {
                for (Map.Entry entry : props.entrySet()) {
                    String key = (String)entry.getKey();
                    Property prop = (Property)entry.getValue();
                    JsonSchemaElement elem = this.convertProperty(prop, key);
                    obj.properties.put(key, elem);
                    if (requiredList == null || !requiredList.contains(key)) continue;
                    if (obj.required == null) {
                        obj.required = new ArrayList<String>();
                    }
                    obj.required.add(key);
                }
            }
            return obj;
        }
        if (model instanceof ArrayModel) {
            ArrayModel arrayModel = (ArrayModel)model;
            Property items = arrayModel.getItems();
            JsonSchemaElement itemSchema = this.convertProperty(items, "items");
            return JsonSchemaElement.complexArray(arrayModel.getDescription(), itemSchema);
        }
        if (model instanceof RefModel) {
            RefModel ref = (RefModel)model;
            String refName = ref.getSimpleRef();
            Model refModel = (Model)this.swagger.getDefinitions().get(refName);
            if (refModel == null) {
                throw new IllegalArgumentException("Unresolved ref: " + refName);
            }
            return this.parseModel(refModel);
        }
        if (model instanceof ComposedModel) {
            ComposedModel composed = (ComposedModel)model;
            JsonSchemaElement obj = JsonSchemaElement.object(composed.getDescription());
            for (Model inner : composed.getAllOf()) {
                JsonSchemaElement part = this.parseModel(inner);
                obj.properties.putAll(part.properties);
                if (part.required == null) continue;
                if (obj.required == null) {
                    obj.required = new ArrayList<String>();
                }
                obj.required.addAll(part.required);
            }
            return obj;
        }
        throw new IllegalArgumentException("Unsupported model type: " + String.valueOf(model.getClass()));
    }

    private JsonSchemaElement convertProperty(Property prop, String key) {
        StringProperty strProp;
        Object baseDesc;
        Object object = baseDesc = prop.getDescription() != null ? prop.getDescription() : "Value for " + key;
        if (prop instanceof RefProperty) {
            RefProperty refProp = (RefProperty)prop;
            String refName = refProp.getSimpleRef();
            Model refModel = (Model)this.swagger.getDefinitions().get(refName);
            if (refModel == null) {
                throw new IllegalArgumentException("Unresolved ref: " + refName);
            }
            JsonSchemaElement refElem = this.parseModel(refModel);
            if (StringUtils.isNotBlank((String)prop.getDescription())) {
                refElem.description = prop.getDescription();
            } else if (StringUtils.isBlank((String)refElem.description)) {
                refElem.description = baseDesc;
            }
            return refElem;
        }
        if (prop instanceof ArrayProperty) {
            ArrayProperty arrayProperty = (ArrayProperty)prop;
            Property itemType = arrayProperty.getItems();
            switch (itemType.getType()) {
                case "string": {
                    return JsonSchemaElement.simpleArray((String)baseDesc, JsonSchemaElement.Type.string);
                }
                case "number": 
                case "integer": {
                    return JsonSchemaElement.simpleArray((String)baseDesc, JsonSchemaElement.Type.number);
                }
                case "boolean": {
                    return JsonSchemaElement.simpleArray((String)baseDesc, JsonSchemaElement.Type.bool);
                }
            }
            JsonSchemaElement complexItem = this.convertProperty(itemType, key + "_item");
            return JsonSchemaElement.complexArray((String)baseDesc, complexItem);
        }
        if (prop instanceof ObjectProperty) {
            ObjectProperty objectProperty = (ObjectProperty)prop;
            JsonSchemaElement obj = JsonSchemaElement.object((String)baseDesc);
            Map nestedProps = objectProperty.getProperties();
            if (nestedProps != null) {
                for (Map.Entry e : nestedProps.entrySet()) {
                    JsonSchemaElement child = this.convertProperty((Property)e.getValue(), (String)e.getKey());
                    obj.properties.put((String)e.getKey(), child);
                }
            }
            return obj;
        }
        if (prop instanceof StringProperty && (strProp = (StringProperty)prop).getEnum() != null) {
            return JsonSchemaElement.stringEnum((String)baseDesc, strProp.getEnum());
        }
        return switch (prop.getType()) {
            case "string" -> JsonSchemaElement.string((String)baseDesc);
            case "integer", "number" -> JsonSchemaElement.number((String)baseDesc);
            case "boolean" -> JsonSchemaElement.bool((String)baseDesc);
            default -> throw new IllegalArgumentException("Unsupported property type: " + prop.getType());
        };
    }
}

