/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SplitRecipeService {
    @Autowired
    private VariablesService variablesService;
    @Autowired
    protected DatasetsDAO datasetsDAO;
    public static final String NULL_COALESCE = "__dku_null__";
    public static final int NUM_LAST_DIGITS_HASH = 4;

    public SplitRecipePayloadParams loadParams(String payload, JobActivity activity, String projectKey) {
        SplitRecipePayloadParams params = (SplitRecipePayloadParams)JSON.parse((String)payload, SplitRecipePayloadParams.class);
        Preconditions.checkNotNull((Object)params, (Object)"Empty params");
        this.expandParams(params, projectKey);
        this.validateParams(params);
        this.initFilters(params);
        this.resolveDatasetNames(params, activity);
        return params;
    }

    public SplitRecipePayloadParams loadParams(String payload, SerializedRecipe sr) {
        SplitRecipePayloadParams params = (SplitRecipePayloadParams)JSON.parse((String)payload, SplitRecipePayloadParams.class);
        Preconditions.checkNotNull((Object)params, (Object)"Empty params");
        this.expandParams(params, sr.getProjectKey());
        this.validateParams(params);
        this.initFilters(params);
        this.resolveDatasetNames(params, sr);
        return params;
    }

    private void validateParams(SplitRecipePayloadParams params) {
        HashSet<String> usedValues = new HashSet<String>();
        if (params.mode == SplitRecipePayloadParams.Mode.VALUES) {
            for (SplitRecipePayloadParams.ValueSplitDesc split : params.valueSplits) {
                if (usedValues.contains(split.value)) {
                    throw ErrorContext.iae((String)("Duplicate value for split: " + split.value));
                }
                usedValues.add(split.value);
            }
        }
    }

    private void initFilters(SplitRecipePayloadParams params) {
        if (params.mode == SplitRecipePayloadParams.Mode.FILTERS) {
            for (SplitRecipePayloadParams.FilterSplitDesc split : params.filterSplits) {
                split.filter.enabled = true;
            }
        }
        if (params.mode == SplitRecipePayloadParams.Mode.RANGE) {
            for (SplitRecipePayloadParams.FilterSplitDesc split : params.rangeSplits) {
                split.filter.enabled = true;
            }
        }
    }

    private void expandParams(SplitRecipePayloadParams params, String projectKey) {
        VariablesContext vc = this.variablesService.getForProject(projectKey);
        FilterDescUtils.expand(params.preFilter, vc);
        FilterDescUtils.expand(params.computedColumns, vc);
        if (params.filterSplits != null) {
            for (SplitRecipePayloadParams.FilterSplitDesc fs : params.filterSplits) {
                if (fs == null || fs.filter == null) continue;
                FilterDescUtils.expandExpressionIfNeeded(fs.filter, vc);
            }
        }
    }

    public boolean isColumnInSchemaOrComputedColumns(String column, SplitRecipePayloadParams params, Dataset inputDataset) {
        Schema inputAndComputedColumnsSchema = this.getInputAndComputedColumnsBaseSchema(inputDataset, params, true);
        return inputAndComputedColumnsSchema != null && inputAndComputedColumnsSchema.getColumn(column) != null;
    }

    public Schema getOutputSchema(Dataset inputDataset, SplitRecipePayloadParams params, boolean lowerCaseColumnsNames) {
        Schema schema = this.getBaseOutputSchema(inputDataset, params);
        if (lowerCaseColumnsNames) {
            SchemaUtils.lowerCase(schema);
        }
        return schema;
    }

    public Schema getBaseOutputSchema(Dataset inputDataset, SplitRecipePayloadParams params) {
        return this.getInputAndComputedColumnsBaseSchema(inputDataset, params, params.writeComputedColumnsInOutput);
    }

    public Schema getInputAndComputedColumnsBaseSchema(Dataset inputDataset, SplitRecipePayloadParams params, boolean withComputedColumns) {
        Schema outputSchema = inputDataset.getSchema().getCopy();
        if (params.hasComputedColumns() && withComputedColumns) {
            for (ComputedColumn var : params.computedColumns) {
                if (StringUtils.isBlank((String)var.name)) {
                    throw ErrorContext.ice((String)"Computed column has no name");
                }
                if (var.type == null) {
                    throw ErrorContext.icef((String)"Computed column '%s' has no type", (Object)var.name, (Object[])new Object[0]);
                }
                outputSchema.addColumn(var.name, Type.forName((String)var.type));
            }
        }
        return outputSchema;
    }

    public Dataset getFirstOutputDataset(JobActivity activity) throws IOException {
        List<? extends FlowComputable> targets = activity.getSubgraph().getTargets();
        FlowDataset firsTarget = (FlowDataset)targets.get(0);
        return firsTarget.getMandatory(this.datasetsDAO);
    }

    private void resolveDatasetNames(SplitRecipePayloadParams params, JobActivity activity) {
        if (params.mode == null) {
            return;
        }
        List<FlowDataset> datasets = activity.getSubgraph().getTargetsDatasets();
        ArrayList datasetFullNames = Lists.newArrayList();
        for (FlowDataset dataset : datasets) {
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(dataset.getFullName());
            datasetFullNames.add(loc.getFullName());
        }
        this.resolveDatasetNames(params, datasetFullNames);
    }

    private void resolveDatasetNames(SplitRecipePayloadParams params, SerializedRecipe sr) {
        if (params.mode == null) {
            return;
        }
        ArrayList datasetFullNames = Lists.newArrayList();
        for (SerializedRecipe.RecipeOutput in : sr.getFlatOutputs()) {
            AnyLoc loc = AnyLoc.resolveSmart(sr.projectKey, in.ref);
            datasetFullNames.add(loc.getFullName());
        }
        this.resolveDatasetNames(params, datasetFullNames);
    }

    private void resolveDatasetNames(SplitRecipePayloadParams params, List<String> datasetFullNames) {
        if (params.mode == null) {
            return;
        }
        switch (params.mode) {
            case FILTERS: {
                for (SplitRecipePayloadParams.FilterSplitDesc split : params.filterSplits) {
                    this.resolveDatasetName(split, datasetFullNames);
                }
                break;
            }
            case VALUES: {
                for (SplitRecipePayloadParams.ValueSplitDesc split : params.valueSplits) {
                    this.resolveDatasetName(split, datasetFullNames);
                }
                break;
            }
            case RANDOM: {
                for (SplitRecipePayloadParams.ShareSplitDesc split : params.randomSplits) {
                    this.resolveDatasetName(split, datasetFullNames);
                }
                break;
            }
            case RANDOM_COLUMNS: {
                for (SplitRecipePayloadParams.ShareSplitDesc split : params.randomColumnsSplits) {
                    this.resolveDatasetName(split, datasetFullNames);
                }
                break;
            }
            case CENTILE: {
                for (SplitRecipePayloadParams.ShareSplitDesc split : params.centileSplits) {
                    this.resolveDatasetName(split, datasetFullNames);
                }
                break;
            }
            case RANGE: {
                for (SplitRecipePayloadParams.FilterSplitDesc split : params.rangeSplits) {
                    this.resolveDatasetName(split, datasetFullNames);
                }
                break;
            }
            default: {
                throw new Error("Unreachable");
            }
        }
        if (params.defaultOutputIndex >= 0) {
            params.defaultOutputDataset = datasetFullNames.get(params.defaultOutputIndex);
        }
    }

    private void resolveDatasetName(SplitRecipePayloadParams.GenericSplitDesc split, List<String> datasets) {
        if (split.outputIndex >= datasets.size()) {
            throw ErrorContext.iaef((String)"Invalid output index: %s. Recipe has %s outputs.", (Object)split.outputIndex, (Object[])new Object[]{datasets.size()});
        }
        split.outputDatasetFullName = split.outputIndex >= 0 ? datasets.get(split.outputIndex) : null;
    }

    public static String shareToHexString(float share) {
        return String.format("%04x", (int)Math.floor((double)share * (Math.pow(16.0, 4.0) - 1.0) / 100.0));
    }
}

