/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.services.UsersService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConflictCheckService {
    @Autowired
    private UsersService usersService;

    public VersionTag.ConflictCheckResult checkConflict(VersionTag existingTag, VersionTag newTag) throws IOException {
        VersionTag.ConflictCheckResult ccr = new VersionTag.ConflictCheckResult();
        if (existingTag == null) {
            ccr.canBeSaved = true;
            ccr.delta = 1L;
        } else if (newTag == null) {
            ccr.canBeSaved = false;
            ccr.delta = existingTag.versionNumber + 1L;
        } else {
            ccr.canBeSaved = existingTag.versionNumber == newTag.versionNumber;
            ccr.delta = existingTag.versionNumber - newTag.versionNumber;
        }
        if (existingTag != null) {
            PublicUser pu;
            String login = existingTag.getLastAuthor();
            ccr.lastModifiedBy = pu = this.usersService.getPublicUser(login);
            ccr.lastModifiedOn = existingTag.getLastModifiedOn();
        }
        return ccr;
    }
}

