/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class EffectiveProjectFolderReaders {
    private Set<String> groups = new HashSet<String>();
    private Set<String> users = new HashSet<String>();
    private boolean containsLimitedVisibilityProject;

    public void addGroup(String group) {
        this.checkState();
        this.groups.add(group);
    }

    public void addUser(String user) {
        this.checkState();
        this.users.add(user);
    }

    public void setContainsLimitedVisibilityProject() {
        this.checkState();
        this.groups = null;
        this.users = null;
        this.containsLimitedVisibilityProject = true;
    }

    public boolean getContainsLimitedVisibilityProject() {
        return this.containsLimitedVisibilityProject;
    }

    public Set<String> getGroups() {
        return Collections.unmodifiableSet(this.groups);
    }

    public Set<String> getUsers() {
        return Collections.unmodifiableSet(this.users);
    }

    public void add(EffectiveProjectFolderReaders other) {
        this.checkState();
        if (other.containsLimitedVisibilityProject) {
            this.groups = null;
            this.users = null;
            this.containsLimitedVisibilityProject = true;
        } else {
            this.groups.addAll(other.groups);
            this.users.addAll(other.users);
        }
    }

    private void checkState() {
        if (this.containsLimitedVisibilityProject) {
            throw new IllegalStateException("Project folder contains a limited visibility project");
        }
    }
}

