/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.mrimpl;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProcessorWithResolvedParams;
import com.dataiku.dip.ProcessorWithResourceFiles;
import com.dataiku.dip.ProcessorWithSubProcess;
import com.dataiku.dip.SingleCopyAdditionalInputsLoader;
import com.dataiku.dip.contribs.PythonContrib;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorWithFactories;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.SRPAdapter;
import com.dataiku.dip.datalayer.SingleInputRowProcessor;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.datalayer.SingleOutputRowProcessor;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.meanings.MeaningsDAO;
import com.dataiku.dip.plugins.HadoopJavaPluginsHelper;
import com.dataiku.dip.plugins.HadoopJythonPluginsHelper;
import com.dataiku.dip.plugins.HadoopPluginSettingsHelper;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.AdditionalInputsHelper;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.mrimpl.DiagnosticsHandler;
import com.dataiku.dip.shaker.mrimpl.MRAdditionalInputsLoader;
import com.dataiku.dip.shaker.mrimpl.MRProcessorOutput;
import com.dataiku.dip.shaker.mrimpl.ShakerEnvironment;
import com.dataiku.dip.shaker.mrimpl.ShakerJobConfigurator;
import com.dataiku.dip.shaker.mrimpl.formats.RowWithFactories;
import com.dataiku.dip.shaker.mrimpl.models.ContextType;
import com.dataiku.dip.shaker.mrimpl.models.SerializedPythonContribs;
import com.dataiku.dip.shaker.processors.BaseProcessorsFactory;
import com.dataiku.dip.shaker.processors.udf.PythonContribProcessor;
import com.dataiku.dip.shaker.resources.YarnPythonBinsSetup;
import com.dataiku.dip.shaker.streamimpl.StreamPipelineFactory;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class ShakerScriptMapper
extends Mapper<Void, RowWithFactories, Void, RowWithFactories> {
    private static Logger logger = Logger.getLogger((String)"dku.shaker.mr");
    private StreamPipelineFactory.StreamPipeline streamPipeline;
    private SingleInputRowProcessor headProcessor;
    private RowFactory rf;
    private ColumnFactory cf;
    private long readRows;
    private WarningsContext warningsContext = new WarningsContext();
    private SerializedShakerScript shakerScript;
    private HashMap<String, File> localResourceFiles;
    private Map<String, String> pythonlibs;
    private MRProcessorOutput pipelineOutput;
    private BaseProcessorsFactory.PipelineContext pipelineContext;
    private String recipeProjectKey;

    private void lazyPipelineInit(Mapper.Context context, RowWithFactories firstRow) throws IOException {
        if (this.cf == null) {
            logger.info((Object)"Initializing pipeline...");
            if (firstRow != null) {
                this.cf = firstRow.getColumnFactory();
                this.rf = firstRow.getRowFactory();
            } else {
                this.cf = new StreamColumnFactory();
                this.rf = new StreamRowFactory();
            }
            this.pipelineOutput = new MRProcessorOutput(context, this.cf, this.rf);
            try {
                Object rproc;
                MRAdditionalInputsLoader accessor = new MRAdditionalInputsLoader(this.localResourceFiles);
                SerializedShakerScript sss = this.shakerScript.deepCopy();
                this.streamPipeline = StreamPipelineFactory.build(sss.steps, this.pipelineContext, true);
                this.headProcessor = (SingleInputRowProcessor)this.streamPipeline.allProcessors.get(0);
                Object last = this.streamPipeline.allProcessors.get(this.streamPipeline.allProcessors.size() - 1);
                if (!(last instanceof SingleOutputRowProcessor)) {
                    throw ErrorContext.iae((String)"Could not plug output, no end of pipe");
                }
                ((SingleOutputRowProcessor)last).setProcessorOutput((ProcessorOutput)this.pipelineOutput);
                List<SingleCopyAdditionalInputsLoader> loaders = AdditionalInputsHelper.getLoadersForAllProcessors(accessor, sss.steps, this.localResourceFiles);
                for (Object o : this.streamPipeline.allProcessors) {
                    if (o instanceof ProcessorWithResourceFiles) {
                        rproc = (ProcessorWithResourceFiles)o;
                        rproc.setRequiredFiles(this.localResourceFiles);
                    }
                    if (!(o instanceof SRPAdapter) || !(((SRPAdapter)o).getProcessor() instanceof ProcessorWithResourceFiles)) continue;
                    rproc = (ProcessorWithResourceFiles)((SRPAdapter)o).getProcessor();
                    rproc.setRequiredFiles(this.localResourceFiles);
                }
                for (Object o : this.streamPipeline.allProcessors) {
                    if (o instanceof ProcessorWithResolvedParams) {
                        rproc = (ProcessorWithResolvedParams)o;
                        rproc.resolve(DSSAuthCtx.newNone(), this.recipeProjectKey);
                    }
                    if (!(o instanceof SRPAdapter) || !(((SRPAdapter)o).getProcessor() instanceof ProcessorWithResolvedParams)) continue;
                    rproc = (ProcessorWithResolvedParams)((SRPAdapter)o).getProcessor();
                    rproc.resolve(DSSAuthCtx.newNone(), this.recipeProjectKey);
                }
                for (Object o : this.streamPipeline.allProcessors) {
                    if (!(o instanceof ProcessorWithSubProcess)) continue;
                    rproc = (ProcessorWithSubProcess)o;
                    rproc.spawn(DSSAuthCtx.newNone(), "__dku_proj__", false, this.pythonlibs);
                }
                for (Object o : this.streamPipeline.allProcessors) {
                    if (o instanceof SingleInputSingleOutputRowProcessor) {
                        ((ProcessorWithFactories)o).setFactories(this.cf, this.rf);
                        ((SingleInputSingleOutputRowProcessor)o).setWarningsContext(this.warningsContext);
                        ((SingleInputSingleOutputRowProcessor)o).init();
                        continue;
                    }
                    if (!(o instanceof ProcessorWithFactories)) continue;
                    ((ProcessorWithFactories)o).setFactories(this.cf, this.rf);
                }
                AdditionalInputsHelper.setAdditionalInputsOnProcessors(accessor, loaders, this.streamPipeline.allProcessors);
            }
            catch (Exception e) {
                throw new IOException("Failed to init mapper", e);
            }
            logger.info((Object)"Pipeline successfully initialized");
        }
    }

    protected void map(Void key, RowWithFactories value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            this.lazyPipelineInit(context, value);
            Row row = value.getRow();
            this.headProcessor.processRow(row);
        }
        catch (Exception e) {
            DiagnosticsHandler.saveFatalError(ContextType.SHAKER, e, (TaskAttemptContext)context);
            throw new IOException("Failed to map row", e);
        }
        ++this.readRows;
    }

    protected void cleanup(Mapper.Context context) throws IOException {
        try {
            this.lazyPipelineInit(context, null);
            this.headProcessor.postProcess();
        }
        catch (Exception e) {
            try {
                DiagnosticsHandler.saveFatalError(ContextType.SHAKER, e, (TaskAttemptContext)context);
                if (this.headProcessor != null) {
                    try {
                        this.headProcessor.cancel();
                    }
                    catch (Exception e2) {
                        logger.error((Object)"Failure during processor cleanup", (Throwable)e2);
                    }
                }
                throw new IOException("Failed to cleanup", e);
            }
            catch (Throwable throwable) {
                DiagnosticsHandler.saveWarningsContext(ContextType.SHAKER, (TaskAttemptContext)context, this.warningsContext);
                logger.info((Object)"Mapper task terminated");
                logger.info((Object)("Nb input rows : " + this.readRows));
                logger.info((Object)("Nb output rows : " + (this.pipelineOutput == null ? 0L : this.pipelineOutput.getWrittenRows())));
                throw throwable;
            }
        }
        DiagnosticsHandler.saveWarningsContext(ContextType.SHAKER, (TaskAttemptContext)context, this.warningsContext);
        logger.info((Object)"Mapper task terminated");
        logger.info((Object)("Nb input rows : " + this.readRows));
        logger.info((Object)("Nb output rows : " + (this.pipelineOutput == null ? 0L : this.pipelineOutput.getWrittenRows())));
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        logger.info((Object)"Setup shaker configuration");
        File tempFolder = new File(".", "__dku_temp");
        tempFolder.mkdirs();
        File tempiFolder = new File(".", "__dku_tempi");
        tempiFolder.mkdirs();
        logger.info((Object)("Setting temp folders at " + tempFolder.getAbsolutePath() + " and " + tempiFolder.getAbsolutePath()));
        ApplicationConfigurator.configureNoConfig((String)tempFolder.getAbsolutePath(), (String)tempiFolder.getAbsolutePath());
        ShakerEnvironment.setup();
        AnnotationConfigApplicationContext appContext = new AnnotationConfigApplicationContext();
        appContext.register(new Class[]{SpringUtils.class});
        appContext.refresh();
        Configuration hadoopJobConfiguration = context.getConfiguration();
        logger.info((Object)"Load plugins");
        HadoopJavaPluginsHelper.PluginsWithJavaState jstate = ShakerJobConfigurator.getPluginsState(hadoopJobConfiguration);
        HadoopJythonPluginsHelper.PluginsWithJythonState jystate = ShakerJobConfigurator.getPluginStepsState(hadoopJobConfiguration);
        HadoopJavaPluginsHelper.load(jstate);
        HadoopJythonPluginsHelper.load(jystate);
        ShakerJobConfigurator.ResourceMapping resourceMapping = ShakerJobConfigurator.getJobResourceMapping(hadoopJobConfiguration);
        this.localResourceFiles = new HashMap();
        Path[] localFiles = DistributedCache.getLocalCacheFiles((Configuration)hadoopJobConfiguration);
        for (Map.Entry<String, String> entry : resourceMapping.resourceFiles.entrySet()) {
            String filename = entry.getValue();
            String resourceID = entry.getKey();
            Path path = null;
            for (Path currentFile : localFiles) {
                if (!StringUtils.equals((String)currentFile.getName(), (String)filename)) continue;
                path = currentFile;
                break;
            }
            if (path == null) {
                throw new Error("Did not find resource file " + (String)filename);
            }
            logger.info((Object)("Distributed cache has file : " + String.valueOf(path)));
            if (path.toString().endsWith(".zip")) {
                File newPath = new File(path.toString() + "__" + entry.getKey());
                logger.info((Object)("unzip temporary file to " + String.valueOf(newPath)));
                ZipUnzipDir.extractFolder(new File(path.toString()), newPath);
                logger.info((Object)("Reassign file " + resourceID + " to path " + String.valueOf(newPath)));
                this.localResourceFiles.put(resourceID, newPath);
                continue;
            }
            logger.info((Object)("Reassign file " + resourceID + " to path " + String.valueOf(path)));
            this.localResourceFiles.put(resourceID, new File(path.toString()));
        }
        File contributedProcessorsFile = this.localResourceFiles.get("dku.shaker.contrib");
        if (contributedProcessorsFile != null) {
            SerializedPythonContribs contributedProcessors = (SerializedPythonContribs)JSON.parseFile((File)contributedProcessorsFile, SerializedPythonContribs.class);
            for (PythonContrib contrib : contributedProcessors.contribs) {
                BaseProcessorsFactory.addBuiltinProcessor(new PythonContribProcessor(contrib, null).getMeta());
            }
        }
        this.pythonlibs = YarnPythonBinsSetup.setup(this.localResourceFiles);
        File meaningsFile = this.localResourceFiles.get("dku.shaker.udm");
        if (meaningsFile != null) {
            MeaningsDAO.MeaningsList ml = (MeaningsDAO.MeaningsList)JSON.parseFile((File)meaningsFile, MeaningsDAO.MeaningsList.class);
            this.pipelineContext = new BaseProcessorsFactory.PipelineContext(ml.meanings);
        } else {
            this.pipelineContext = new BaseProcessorsFactory.PipelineContext(Lists.newArrayList());
        }
        this.shakerScript = ShakerJobConfigurator.getJobScript(hadoopJobConfiguration);
        this.recipeProjectKey = HadoopPluginSettingsHelper.loadAndGetProjectKey(ShakerJobConfigurator.getPluginSettingsState(hadoopJobConfiguration));
        logger.info((Object)"Setup done!");
    }
}

