/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.opengis.referencing.FactoryException;

public class EnrichWithBuildContextProcessor {
    public static final ProcessorMeta<StreamImpl, Params> META = new ProcessorMeta<StreamImpl, Params>(){

        @Override
        public String getName() {
            return "EnrichWithBuildContextProcessor";
        }

        @Override
        public String getDocPage() {
            return "enrich-with-build-context";
        }

        @Override
        public Category getCategory() {
            return Category.MISC;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.MISC});
        }

        @Override
        public Class<Params> stepParamClass() {
            return Params.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.EnrichWithBuildContextProcessor.HELP", "This processor add columns containing information about the current build (date, job ID)");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.EnrichWithBuildContextProcessor.DESCRIPTION", 1.actionVerb("Enrich") + " record with build information")).withParam("buildDateColumn", "string", false, true, this.translate(language, "SHAKER.PROCESSOR.EnrichWithBuildContextProcessor.DESCRIPTION.BUILD_DATE_COLUMN", "Build date column")).withParam("jobIdColumn", "string", false, true, this.translate(language, "SHAKER.PROCESSOR.EnrichWithBuildContextProcessor.DESCRIPTION.JOB_ID_COLUMN", "Job ID column"));
        }

        @Override
        public StreamImpl build(Params parameter) {
            return new StreamImpl(parameter);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Params)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Params)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                Params enrichParams = (Params)pss.params;
                updatedDatasetPairLineage.removeRelationsOnColumn(enrichParams.buildDateColumn);
                updatedDatasetPairLineage.removeRelationsOnColumn(enrichParams.jobIdColumn);
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private static final DateTimeFormatter SQL_TIMESTAMP_FORMATTER = DKUtils.getDateFormatter((String)"yyyy-MM-dd HH:mm:ss").withZoneUTC();
        private final Params params;

        private SQLTranslator(Params params) {
            this.params = params;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            if (StringUtils.isNotBlank((String)this.params.buildDateColumn)) {
                JobActivity activity = JobContext.getCurrentActivityObj();
                String buildTimestamp = SQL_TIMESTAMP_FORMATTER.print(activity != null ? activity.startTime : System.currentTimeMillis());
                chain.addColumn(new SchemaColumn(this.params.buildDateColumn, Type.DATE));
                chain.select(new ExpressionBuilder.ExpressionBuilderFactory().op(QueryUtils.OperatorType.STRING_TO_TIMESTAMPTZ, buildTimestamp), this.params.buildDateColumn);
            }
            if (StringUtils.isNotBlank((String)this.params.jobIdColumn)) {
                JobContext jobContext = JobContext.getCurrentJobContext();
                String jobId = jobContext != null ? jobContext.jobId : "This column will only be valued at build time";
                chain.addColumn(new SchemaColumn(this.params.jobIdColumn, Type.STRING));
                chain.select(new ExpressionBuilder.ExpressionBuilderFactory().cst(jobId), this.params.jobIdColumn);
            }
            return chain;
        }
    }

    private static class StreamImpl
    extends SingleRowProcessor {
        private final Params params;
        private Column buildDateColumn;
        private long buildDate;
        private Column jobIdColumn;
        private String jobId;

        public StreamImpl(Params params) {
            this.params = params;
        }

        public void init() throws FactoryException {
            if (StringUtils.isNotBlank((String)this.params.buildDateColumn)) {
                this.buildDateColumn = this.cf.column(this.params.buildDateColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
                JobActivity activity = JobContext.getCurrentActivityObj();
                long l = this.buildDate = activity != null ? activity.startTime : System.currentTimeMillis();
            }
            if (StringUtils.isNotBlank((String)this.params.jobIdColumn)) {
                this.jobIdColumn = this.cf.column(this.params.jobIdColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
                JobContext jobContext = JobContext.getCurrentJobContext();
                this.jobId = jobContext != null ? jobContext.jobId : "This column will only be valued at build time";
            }
        }

        public void processRow(Row row) throws Exception {
            if (this.buildDateColumn != null) {
                row.put(this.buildDateColumn, DKUDateUtils.isoFormatUTC((long)this.buildDate));
            }
            if (this.jobIdColumn != null) {
                row.put(this.jobIdColumn, this.jobId);
            }
        }

        public void postProcess() {
        }
    }

    public static class Params
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String buildDateColumn;
        public String jobIdColumn;

        public void validate() throws IllegalArgumentException {
        }
    }
}

