/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.cleansing;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleInputSingleOutputRowProcessor;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UpDownFiller
extends SingleInputSingleOutputRowProcessor
implements Processor {
    public static final ProcessorMeta<UpDownFiller, Parameter> META = new ProcessorMeta<UpDownFiller, Parameter>(){

        @Override
        public String getName() {
            return "UpDownFiller";
        }

        @Override
        public String getDocPage() {
            return "up-down-fill";
        }

        @Override
        public Category getCategory() {
            return Category.CLEANSING;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.CLEANSING});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.UpDownFiller.HELP", "Fill empty cells in column(s) with the previous or next non-empty value. \n# Example\n<table><tr><th>Values</th><th>Fill with previous</th><th>Fill with next</th></tr><tr><td>A</td><td>A</td><td>A</td></tr><tr><td>&nbsp;</td><td>A</td><td>B</td></tr><tr><td>B</td><td>B</td><td>B</td></tr><tr><td>&nbsp;</td><td>B</td><td>&nbsp;</td></tr></table>\n# Options\nWhen filling with previous value, you can specify multiple columns. When filling with next value, you can use only a single column.");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.UpDownFiller.DESCRIPTION", 1.actionVerb("Fill") + " empty cells with previous/next value")).withParam(new ParamDesc("columns", "columns").withLabel(this.translate(language, "SHAKER.PROCESSOR.UpDownFiller.DESCRIPTION.COLUMNS", "Columns")).withMandatory(true).withDefaultValue(Collections.emptyList())).withBool("up", "", this.translate(language, "SHAKER.PROCESSOR.UpDownFiller.DESCRIPTION.UP.TRUE", "Fill with next value (single column only)"), this.translate(language, "SHAKER.PROCESSOR.UpDownFiller.DESCRIPTION.UP.FALSE", "Fill with previous value"));
        }

        @Override
        public UpDownFiller build(Parameter parameter) throws Exception {
            return new UpDownFiller(Sets.newHashSet(parameter.columns), parameter.up);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            return previousRecipeLineage;
        }
    };
    private final Set<String> inCols;
    private final boolean up;
    private Set<Column> cds;
    private Column cd;
    private List<Row> buffer = new ArrayList<Row>();
    private HashMap<Column, String> downValues;

    public UpDownFiller(Set<String> inCols, boolean up) {
        this.inCols = inCols;
        this.up = up;
    }

    public void init() {
        if (!this.up) {
            this.cds = new HashSet<Column>(this.inCols.size());
            this.downValues = new HashMap(this.inCols.size());
            for (String c2 : this.inCols) {
                Column col = this.getCf().column(c2, Processor.ProcessorRole.INPUT_COLUMN);
                this.cds.add(col);
                this.downValues.put(col, null);
            }
        } else {
            if (this.inCols.size() > 1) {
                throw ErrorContext.iae((String)"Cannot fill multiple columns with next value");
            }
            this.cd = this.getCf().column(this.inCols.iterator().next(), Processor.ProcessorRole.INPUT_COLUMN);
        }
    }

    public void processRow(Row row) throws Exception {
        if (!this.up) {
            for (Column cd : this.cds) {
                String cur = row.get(cd);
                if (cur == null) {
                    String v = this.downValues.get(cd);
                    if (v == null) continue;
                    row.put(cd, v);
                    continue;
                }
                this.downValues.put(cd, cur);
            }
            this.getProcessorOutput().emitRow(row);
        } else {
            String cur = row.get(this.cd);
            if (cur == null) {
                this.buffer.add(row);
            } else {
                for (Row buffered : this.buffer) {
                    buffered.put(this.cd, cur);
                    this.getProcessorOutput().emitRow(buffered);
                }
                this.getProcessorOutput().emitRow(row);
                this.buffer.clear();
            }
        }
    }

    public void postProcess() throws Exception {
        if (this.up) {
            for (Row buffered : this.buffer) {
                this.getProcessorOutput().emitRow(buffered);
            }
            this.buffer.clear();
        }
        this.getProcessorOutput().lastRowEmitted();
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public List<String> columns;
        boolean up;

        public void validate() throws IllegalArgumentException {
        }
    }
}

