/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.time;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.PrepareSnowflakeUDFUtils;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.time.DateProcessor;
import com.dataiku.dip.shaker.processors.time.UNIXTimestampParserAlgorithm;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.sql.SnowflakeUDFProcessorTranslator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class UNIXTimestampParser {
    public static final ProcessorMeta<StreamImpl, Parameter> META = new DateProcessor.DateProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "UNIXTimestampParser";
        }

        @Override
        public String getDocPage() {
            return "unixtimestamp-parser";
        }

        @Override
        public Category getCategory() {
            return Category.DATE;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.MATH, ProcessorTag.DATE});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.UNIXTimestampParser.HELP", "Convert a UNIX timestamp (number of seconds or number of milliseconds since Epoch \u2014 January 1, 1970) into a column containing ISO-8601 formatted dates. \n# Option\n\n**Treat input as milliseconds**\n\nBy default, the conversion between UNIX and ISO-8601 is done in milliseconds. Deselect to treat input as seconds.");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.UNIXTimestampParser.DESCRIPTION", 1.actionVerb("Convert") + " a UNIX timestamp to a date"), true).withMNEColParam("inCol", this.translate(language, "SHAKER.PROCESSOR.UNIXTimestampParser.DESCRIPTION.IN_COL", "Column")).withParam("outCol", "string", false, true, this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.OUTPUT_COLUMN_EMPTY_FOR_INPLACE", "Output column (empty for in-place)")).withParam(ParamDesc.booleanP("milliseconds", this.translate(language, "SHAKER.PROCESSOR.UNIXTimestampParser.DESCRIPTION.MILLISECONDS", "Treat input as milliseconds"), null, true));
        }

        @Override
        public Object selfReport(Parameter parameter) {
            return JSON.deepCopyExcept((Object)parameter, (String[])new String[]{"inCol", "outCol"});
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect, AbstractSQLConnection conn) {
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary();
            if (PrepareSnowflakeUDFUtils.canUseSnowflakeUDF(conn)) {
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
            }
            return ret;
        }

        @Override
        public StreamImpl build(Parameter params) {
            return new StreamImpl(params.inCol, params.outCol, params.milliseconds);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SnowflakeUDFSQLTranslator((Parameter)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = super.getUpdatedDatasetPairLineage(pss.params, (DatasetPairLineage)previousDatasetPairLineage, true);
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };

    private static class StreamImpl
    extends SingleRowProcessor
    implements Processor {
        private final String inCol;
        private final String outCol;
        private final boolean milliseconds;
        private Column inCD;
        private Column outCD;

        public StreamImpl(String inCol, String outCol, boolean milliseconds) {
            this.inCol = inCol;
            this.outCol = outCol;
            this.milliseconds = milliseconds;
        }

        public void init() {
            this.inCD = this.getColumnFactory().column(this.inCol, Processor.ProcessorRole.INPUT_COLUMN);
            this.outCD = StringUtils.isNotBlank((String)this.outCol) ? this.getColumnFactory().columnAfter(this.inCol, this.outCol, Processor.ProcessorRole.OUTPUT_COLUMN) : this.getColumnFactory().column(this.inCol, Processor.ProcessorRole.OUTPUT_COLUMN);
        }

        public void processRow(Row row) {
            String inV = row.get(this.inCD);
            String output = UNIXTimestampParserAlgorithm.parseString((String)inV, (boolean)this.milliseconds);
            if (output == null) {
                row.delete(this.outCD);
            } else {
                row.put(this.outCD, output);
            }
        }

        public void postProcess() throws Exception {
        }
    }

    private static class SnowflakeUDFSQLTranslator
    implements SnowflakeUDFProcessorTranslator {
        private final String functionName = "unixTimestampParser_" + SecretKeyGenerator.generate();
        private final Parameter params;

        private SnowflakeUDFSQLTranslator(Parameter params) {
            this.params = params;
        }

        @Override
        public List<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource> getUDFResources() throws IOException {
            List<SnowflakeUDFProcessorTranslator.SnowflakeUDFResource> resources = SnowflakeUDFProcessorTranslator.createStandardResourceList();
            SnowflakeUDFProcessorTranslator.addStandardResources(resources, SnowflakeUDFProcessorTranslator.StandardResource.SHADELIB, SnowflakeUDFProcessorTranslator.StandardResource.COMMONS_LANG_JAR);
            return resources;
        }

        @Override
        public List<SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef> getUDFs() {
            SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef def = new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef(this.functionName, "com.dataiku.dip.shaker.processors.time.UNIXTimestampParserUDF.process", "inV STRING, milliseconds BOOLEAN", "STRING, BOOLEAN", "STRING");
            def.importStandardResources(SnowflakeUDFProcessorTranslator.StandardResource.SHADELIB, SnowflakeUDFProcessorTranslator.StandardResource.COMMONS_LANG_JAR);
            return Lists.newArrayList((Object[])new SnowflakeUDFProcessorTranslator.SnowflakeFunctionDef[]{def});
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            SQLDialect d = chain.getDialect();
            ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
            if (chain.isCreatedOrModifiedByCurrentQuery(this.params.inCol)) {
                chain = chain.makeSubquery();
            }
            chain.addAfterOrReplaceColumn(chain.getCurrentColumn(this.params.inCol), ebf.expr(String.format("%s(%s, %s)", this.functionName, d.quoteIdentifier(this.params.inCol), this.params.milliseconds)), Type.STRING, this.params.outCol, false);
            return chain;
        }
    }

    public static class Parameter
    extends DateProcessor.DateParameter {
        private static final long serialVersionUID = -1L;
        boolean milliseconds;

        @Override
        public void validate() throws IllegalArgumentException {
        }
    }
}

