/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.AppliesToProcessor;
import com.dataiku.dip.shaker.processors.AppliesToUtils;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.MemTableProcessor;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.sql.MySQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class ComputeNTile {
    public static final ProcessorMeta<MemTableImpl, Parameter> META = new ProcessorMeta<MemTableImpl, Parameter>(){

        @Override
        public String getName() {
            return "ComputeNTile";
        }

        @Override
        public String getDocPage() {
            return "compute-ntile";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.MATH});
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.ComputeNTile.HELP", "This processor computes quantile of a column");
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public Object selfReport(Parameter parameter) {
            JsonObject obj = AppliesToProcessor.selfReport(parameter);
            obj.remove("outCol");
            return obj;
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            ProcessorMeta.ProcessorCapabilitiesSummary ret = new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.NO_STREAM_IMPL, ProcessorCapabilities.NATIVE_SPARK_IMPL);
            if (dialect.getOperator(QueryUtils.OperatorType.NTILE) == null) {
                ret.withCould(ProcessorCapabilities.SQL_TRANSLATABLE, "Cannot use SQL engine : database doesn't have ntile()");
            } else {
                ret.withCan(ProcessorCapabilities.SQL_TRANSLATABLE);
            }
            return ret;
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.transform.ComputeNTileNS";
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.ComputeNTile.DESCRIPTION", "Compute quantile")).withParam(ParamDesc.intP("n", this.translate(language, "SHAKER.PROCESSOR.ComputeNTile.DESCRIPTION.N", "Number of quantiles"))).withParam("outCol", "string", false, true, this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.OUTPUT_COLUMN_EMPTY_FOR_INPLACE", this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.OUTPUT_COLUMN_EMPTY_FOR_INPLACE", "Output column (empty for in-place)")));
        }

        @Override
        public MemTableImpl build(Parameter parameter) {
            return new MemTableImpl(parameter);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) throws IOException {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter computeNTileParam = (Parameter)pss.params;
            if (computeNTileParam.columns == null || computeNTileParam.columns.isEmpty()) {
                throw new IllegalConfigurationException("Missing columns information for lineage on the mean processor.");
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                if (AppliesToProcessor.AppliesTo.SINGLE_COLUMN.equals((Object)computeNTileParam.appliesTo) && StringUtils.isNotBlank((String)computeNTileParam.outCol) && !((String)computeNTileParam.columns.get(0)).equals(computeNTileParam.outCol)) {
                    updatedDatasetPairLineage.removeRelationsOnColumn(computeNTileParam.outCol);
                    updatedDatasetPairLineage.addFactorizedColumnRelations((String)computeNTileParam.columns.get(0), computeNTileParam.outCol);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };

    public static class MemTableImpl
    implements MemTableProcessor,
    Processor {
        private final Parameter param;

        public MemTableImpl(Parameter param) {
            this.param = param;
        }

        @Override
        public void process(MemTable table) throws InterruptedException {
            List<Column> consideredColumns = AppliesToUtils.getColumnsForMemTable(this.param, table);
            Iterator<Column> iterator = consideredColumns.iterator();
            while (iterator.hasNext()) {
                Column col;
                Column outCol = col = iterator.next();
                if (this.param.appliesTo == AppliesToProcessor.AppliesTo.SINGLE_COLUMN && StringUtils.isNotBlank((String)this.param.outCol)) {
                    outCol = table.columnAfter(col.getName(), this.param.outCol, Processor.ProcessorRole.OUTPUT_COLUMN);
                }
                FutureProgressState.checkInterrupt();
                ArrayList values = Lists.newArrayList();
                int pos = 0;
                for (MemRow row : table.rows) {
                    if (row.isDeleted()) continue;
                    String v = row.get(col, "");
                    try {
                        values.add(new Pair((Object)Double.parseDouble(v), (Object)pos));
                    }
                    catch (Exception e) {
                        values.add(new Pair((Object)v, (Object)pos));
                    }
                    ++pos;
                }
                Collections.sort(values, new Comparator<Pair<Object, Integer>>(){

                    @Override
                    public int compare(Pair<Object, Integer> a, Pair<Object, Integer> b) {
                        Object va = a.first;
                        Object vb = b.first;
                        if (va.getClass() == vb.getClass()) {
                            if (va instanceof String) {
                                return ((String)va).compareTo((String)vb);
                            }
                            if (va instanceof Double) {
                                double d = (Double)va - (Double)vb;
                                return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
                            }
                            return 0;
                        }
                        return va.getClass().getCanonicalName().compareTo(vb.getClass().getCanonicalName());
                    }
                });
                HashMap indices = Maps.newHashMap();
                pos = 0;
                for (Pair indexedValue : values) {
                    indices.put((Integer)indexedValue.second, pos);
                    ++pos;
                }
                pos = 0;
                for (MemRow row : table.rows) {
                    if (row.isDeleted()) continue;
                    int index = (Integer)indices.get(pos);
                    row.put(outCol, Integer.toString(1 + this.param.n * index / indices.size()));
                    ++pos;
                }
            }
            table.compact();
        }
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;
        private ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();

        private SQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            boolean mysqlWouldNeedNameShuffling;
            List<String> appliesToColumns = chain.getAppliesToColumns(this.parameter);
            if (this.parameter.appliesTo == AppliesToProcessor.AppliesTo.SINGLE_COLUMN && this.parameter.columns.size() > 0 && StringUtils.equals((String)this.parameter.outCol, (String)((String)this.parameter.columns.get(0)))) {
                this.parameter.outCol = null;
            }
            HashMap columnNameToAggregateds = Maps.newHashMap();
            boolean bl = mysqlWouldNeedNameShuffling = this.parameter.appliesTo != AppliesToProcessor.AppliesTo.SINGLE_COLUMN || StringUtils.isBlank((String)this.parameter.outCol);
            if (mysqlWouldNeedNameShuffling && chain.getDialect() instanceof MySQLDialect) {
                String n;
                Schema schema = chain.getCurrentSchema();
                for (String n2 : appliesToColumns) {
                    String nn = "c_" + SecretKeyGenerator.generate((int)8);
                    columnNameToAggregateds.put(n2, nn);
                }
                chain = chain.makeSubquery();
                chain.clearSelected();
                for (SchemaColumn c2 : schema.getColumns()) {
                    n = c2.getName();
                    if (columnNameToAggregateds.containsKey(n)) {
                        chain.select(chain.col(n), (String)columnNameToAggregateds.get(n));
                        continue;
                    }
                    chain.select(n);
                }
                chain = chain.makeSubquery();
                chain.clearSelected();
                for (SchemaColumn c2 : schema.getColumns()) {
                    n = c2.getName();
                    if (columnNameToAggregateds.containsKey(n)) {
                        chain.select(chain.col((String)columnNameToAggregateds.get(n)), n);
                        continue;
                    }
                    chain.select(n);
                }
            } else {
                boolean needsSubquery = chain.isAnyCreatedOrModifiedByCurrentQuery(appliesToColumns);
                if (this.parameter.appliesTo == AppliesToProcessor.AppliesTo.SINGLE_COLUMN && StringUtils.isNotBlank((String)this.parameter.outCol)) {
                    needsSubquery |= chain.isCreatedOrModifiedByCurrentQuery(this.parameter.outCol);
                }
                if (needsSubquery) {
                    chain = chain.makeSubquery();
                }
                for (String n2 : appliesToColumns) {
                    columnNameToAggregateds.put(n2, n2);
                }
            }
            for (Map.Entry column : columnNameToAggregateds.entrySet()) {
                chain = this.handle(chain, (String)column.getKey(), (String)column.getValue());
            }
            return chain;
        }

        private SQLQueryWithSchema handle(SQLQueryWithSchema chain, String column, String aggregated) {
            QueryAst.Window windowUnbounded = SelectQueryBuilder.window(new ArrayList<ExpressionBuilder>(), Lists.newArrayList((Object[])new ExpressionBuilder[]{chain.col(aggregated)}), Lists.newArrayList((Object[])new QueryAst.OrderType[]{QueryAst.OrderType.ASC}));
            windowUnbounded = SelectQueryBuilder.unboundedWindow(windowUnbounded);
            if (this.parameter.appliesTo == AppliesToProcessor.AppliesTo.SINGLE_COLUMN && StringUtils.isNotBlank((String)this.parameter.outCol)) {
                SchemaColumn existing = chain.getCurrentColumn(this.parameter.outCol);
                if (existing == null) {
                    chain.select(this.ebf.ntile(this.parameter.n).over(windowUnbounded).castToBigint(), this.parameter.outCol);
                    chain.addColumnAfter(column, new SchemaColumn(this.parameter.outCol, Type.BIGINT));
                } else {
                    chain.replaceSelect(this.parameter.outCol, this.ebf.ntile(this.parameter.n).over(windowUnbounded).castToBigint(), this.parameter.outCol);
                    chain.markColumnModified(this.parameter.outCol);
                }
            } else {
                chain.replaceSelect(column, this.ebf.ntile(this.parameter.n).over(windowUnbounded).castToBigint(), column);
                chain.markColumnModified(column);
            }
            return chain;
        }
    }

    public static class Parameter
    extends AppliesToProcessor.AppliesToParams {
        private static final long serialVersionUID = -1L;
        public int n = 100;
        public String outCol;
    }
}

