/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server;

import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.processors.filtering.FilterAndFlagOnExplicitConditions;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.utils.Params;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class ProcessorLibraryDesc {
    public List<ProcessorDesc> processors = new ArrayList<ProcessorDesc>();
    public List<TagDesc> tags = new ArrayList<TagDesc>();
    public List<CategoryDesc> categories = new ArrayList<CategoryDesc>();
    private static final Logger logger = Logger.getLogger((String)"dku.shaker.processors.library");

    public static boolean disabledByAdmin(Params p, ProcessorMeta<?, ?> meta) {
        return !p.getBoolParam("dku.prepare.processors." + meta.getName() + ".enabled", true);
    }

    private static boolean displayedInLibrary(Params p, ProcessorMeta<?, ?> meta, boolean defaultValue) {
        return p.getBoolParam("dku.prepare.processors." + meta.getName() + ".displayInLibrary", defaultValue);
    }

    public ProcessorLibraryDesc(Params p, String language, Collection<ProcessorMeta<?, ?>> processorMetas) {
        List<ProcessorMeta<FilterAndFlagOnExplicitConditions, FilterAndFlagOnExplicitConditions.Parameter>> ignoredProcessors = List.of(FilterAndFlagOnExplicitConditions.META_FILTER);
        TranslationService sts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        for (ProcessorTag processorTag : ProcessorTag.values()) {
            this.tags.add(ProcessorLibraryDesc.createTagDesc(language, sts, processorTag));
        }
        for (Enum enum_ : Category.values()) {
            this.categories.add(ProcessorLibraryDesc.createCategoryDesc(language, sts, (Category)enum_));
        }
        for (ProcessorMeta processorMeta : processorMetas) {
            ProcessorDesc processorDesc;
            if (ignoredProcessors.contains(processorMeta) || (processorDesc = ProcessorLibraryDesc.buildProcessorDesc(p, processorMeta, language)) == null) continue;
            this.processors.add(processorDesc);
            this.findOrCreateCategory((String)language, (TranslationService)sts, (Category)processorMeta.getCategory()).processors.add(processorDesc);
        }
    }

    private CategoryDesc findOrCreateCategory(String language, TranslationService sts, Category category) {
        return this.categories.stream().filter(c2 -> c2.id.equals(category.name())).findFirst().orElse(ProcessorLibraryDesc.createCategoryDesc(language, sts, category));
    }

    private static TagDesc createTagDesc(String language, TranslationService sts, ProcessorTag tag) {
        String tagLabel = sts.translateNoContext(language, tag.getLabelTranslationId(), tag.getLabel(), new Object[0]);
        return new TagDesc(tag.name(), tagLabel);
    }

    private static CategoryDesc createCategoryDesc(String language, TranslationService sts, Category category) {
        String categoryLabel = sts.translateNoContext(language, category.getLabelTranslationId(), category.getLabel(), new Object[0]);
        return new CategoryDesc(category.name(), categoryLabel);
    }

    private static ProcessorDesc buildProcessorDesc(Params p, ProcessorMeta<?, ?> meta, String language) {
        ProcessorDesc pdesc = meta.describe(language);
        if (pdesc == null) {
            logger.warn((Object)String.format("Unable to describe processor %s. Ignoring it.", meta.getName()));
            return null;
        }
        pdesc.plugin = meta.plugin;
        try {
            pdesc.defaultParams = meta.stepParamClass().newInstance();
        }
        catch (Exception e) {
            logger.info((Object)String.format("Unable to create new parameter class of processor %s. Ignoring the default parameters", pdesc.type), (Throwable)e);
        }
        pdesc.tags = Lists.newArrayList(meta.getTags());
        pdesc.help = meta.getHelp(language);
        if (pdesc.help == null) {
            pdesc.help = pdesc.tooltip;
        }
        pdesc.docPage = meta.getDocPage();
        pdesc.displayInLibrary = ProcessorLibraryDesc.displayedInLibrary(p, meta, pdesc.displayInLibrary);
        pdesc.disabledByAdmin = ProcessorLibraryDesc.disabledByAdmin(p, meta);
        return pdesc;
    }

    public static class TagDesc {
        public String id;
        public String label;

        public TagDesc(String id, String label) {
            this.id = id;
            this.label = label;
        }
    }

    public static class CategoryDesc {
        public String id;
        public String enName;
        public List<ProcessorDesc> processors = new ArrayList<ProcessorDesc>();

        public CategoryDesc(String id, String label) {
            this.id = id;
            this.enName = label;
        }
    }
}

