/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.sql;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.shaker.processors.filtering.FilterAndFlagOnDate;
import com.dataiku.dip.shaker.sql.AbstractSqlFilterAndFlagOnSimpleCriteria;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.LocalDateTime;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.refine.expr.functions.date.DateTrunc;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class SqlFilterAndFlagOnDate
extends AbstractSqlFilterAndFlagOnSimpleCriteria {
    public SqlFilterAndFlagOnDate(SQLQueryWithSchema chain, FilterAndFlagOnDate.Parameter parameter) {
        super(chain, parameter);
    }

    @Override
    protected ExpressionBuilder exprFor(String column) {
        Preconditions.checkArgument((this.chain.getCurrentColumn(column) != null ? 1 : 0) != 0, (Object)("No schema column found for column " + column));
        ExpressionBuilder comparableCol = this.chain.col(column);
        Optional<SchemaColumn> inputColumn = this.chain.getInputColumn(column);
        if (!inputColumn.isPresent()) {
            logger.debugV("No schema column found for column %s", new Object[]{column});
            return comparableCol;
        }
        Type columnType = ((SchemaColumn)inputColumn.get()).getType();
        if (!columnType.isTemporal()) {
            comparableCol = comparableCol.castToDate();
        }
        ExpressionBuilder filterExpr = switch (this.getTypedParameter().filterType) {
            case FilterAndFlagOnDate.DateFilterType.RANGE -> this.rangeFilter(comparableCol, columnType);
            case FilterAndFlagOnDate.DateFilterType.PART -> this.partFilter(comparableCol, columnType);
            case FilterAndFlagOnDate.DateFilterType.RELATIVE -> this.relativeDateFilter(comparableCol, columnType);
            default -> throw new IllegalArgumentException("The filter type is not valid");
        };
        if (filterExpr == null) {
            return comparableCol.isnotnull();
        }
        return this.ebf.and(comparableCol.isnotnull(), filterExpr);
    }

    private ExpressionBuilder rangeFilter(ExpressionBuilder comparableCol, Type columnType) {
        FilterAndFlagOnDate.Parameter params = this.getTypedParameter();
        Object min = SqlFilterAndFlagOnDate.parseTimestampAsJodaObject(params.min, params.timezone_id, columnType);
        Object max = SqlFilterAndFlagOnDate.parseTimestampAsJodaObject(params.max, params.timezone_id, columnType);
        if (min == null && max == null) {
            return null;
        }
        if (min == null) {
            return comparableCol.lte(this.ebf.cst(max));
        }
        if (max == null) {
            return comparableCol.gte(this.ebf.cst(min));
        }
        return comparableCol.gte(this.ebf.cst(min)).and(comparableCol.lte(this.ebf.cst(max)));
    }

    private ExpressionBuilder partFilter(ExpressionBuilder comparableCol, Type columnType) {
        FilterAndFlagOnDate.Parameter params = this.getTypedParameter();
        if (SqlFilterAndFlagOnDate.hasOnlyEmptyValues(params.values)) {
            return null;
        }
        if (params.part == ChartFilter.DateFilterPart.INDIVIDUAL) {
            List values = params.values.stream().map(s -> {
                try {
                    if (columnType == Type.DATEONLY) {
                        return LocalDate.parse((String)s, (DateTimeFormatter)DateOnly.FORMATTER);
                    }
                    if (columnType == Type.DATETIMENOTZ) {
                        return LocalDateTime.parse((String)(s + " 00:00:00.000"), (DateTimeFormatter)DatetimeNoTz.FORMATTER);
                    }
                    return new DateTime((Object)(s + "T00:00:00.000Z"));
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }).filter(x$0 -> Objects.nonNull(x$0)).collect(Collectors.toList());
            if (columnType == Type.DATEONLY) {
                return comparableCol.dateonlyTrunc("DAY").inList(values);
            }
            if (columnType == Type.DATETIMENOTZ) {
                return comparableCol.datetimenotzTrunc("DAY").inList(values);
            }
            return comparableCol.dateTrunc("DAY").inList(values);
        }
        List values = params.values.stream().map(s -> {
            try {
                return Integer.parseInt(s);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (columnType == Type.DATEONLY) {
            return comparableCol.dateonlyPart(params.part.name()).inList(values);
        }
        if (columnType == Type.DATETIMENOTZ) {
            return comparableCol.datetimenotzPart(params.part.name()).inList(values);
        }
        return comparableCol.datePart(params.part.name()).inList(values);
    }

    private ExpressionBuilder relativeDateFilter(ExpressionBuilder comparableCol, Type columnType) {
        DateTime now = new DateTime().withZone(DateTimeZone.UTC);
        FilterAndFlagOnDate.Parameter params = this.getTypedParameter();
        if (params.option == null || !params.option.isEffective()) {
            return null;
        }
        DateTime lowerBoundDateTime = null;
        DateTime upperBoundDateTime = null;
        if (params.option.containsCurrentDatePart) {
            lowerBoundDateTime = this.getDatePart(now, 0);
            upperBoundDateTime = params.option.isUntilNow ? now : this.getDatePart(now, 1);
        }
        if (params.option.last > 0) {
            lowerBoundDateTime = this.getDatePart(now, -params.option.last);
            if (upperBoundDateTime == null) {
                upperBoundDateTime = this.getDatePart(now, 0);
            }
        }
        if (params.option.next > 0 && !params.option.isUntilNow) {
            if (lowerBoundDateTime == null) {
                lowerBoundDateTime = this.getDatePart(now, 1);
            }
            upperBoundDateTime = this.getDatePart(now, 1 + params.option.next);
        }
        if (lowerBoundDateTime == null || upperBoundDateTime == null) {
            throw new IllegalArgumentException("Invalid option: " + String.valueOf(params.option));
        }
        ExpressionBuilder lowerBound = this.ebf.cst(SqlFilterAndFlagOnDate.toCorrectJodaObject(lowerBoundDateTime, columnType));
        ExpressionBuilder upperBound = this.ebf.cst(SqlFilterAndFlagOnDate.toCorrectJodaObject(upperBoundDateTime, columnType));
        return comparableCol.gte(lowerBound).and(comparableCol.lte(upperBound));
    }

    private DateTime getDatePart(DateTime compareDate, int diff) {
        switch (this.getTypedParameter().part) {
            case YEAR: {
                return new DateTime((Object)DateTrunc.truncate((ReadableInstant)compareDate, DateTrunc.DateUnit.YEARS)).plusYears(diff);
            }
            case QUARTER_OF_YEAR: {
                return new DateTime((Object)DateTrunc.truncate((ReadableInstant)compareDate, DateTrunc.DateUnit.QUARTERS)).plusMonths(diff * 3);
            }
            case MONTH_OF_YEAR: {
                return new DateTime((Object)DateTrunc.truncate((ReadableInstant)compareDate, DateTrunc.DateUnit.MONTHS)).plusMonths(diff);
            }
            case WEEK_OF_YEAR: {
                return new DateTime((Object)DateTrunc.truncate((ReadableInstant)compareDate, DateTrunc.DateUnit.WEEKS)).plusWeeks(diff);
            }
            case DAY_OF_MONTH: {
                return new DateTime((Object)DateTrunc.truncate((ReadableInstant)compareDate, DateTrunc.DateUnit.DAYS)).plusDays(diff);
            }
            case HOUR_OF_DAY: {
                return new DateTime((Object)DateTrunc.truncate((ReadableInstant)compareDate, DateTrunc.DateUnit.HOURS)).plusHours(diff);
            }
        }
        throw new IllegalArgumentException("Date part in not valid: " + String.valueOf((Object)this.getTypedParameter().part));
    }

    private FilterAndFlagOnDate.Parameter getTypedParameter() {
        return (FilterAndFlagOnDate.Parameter)this.getTypedParams();
    }

    private static Object parseTimestampAsJodaObject(String timestamp, String timezoneId, Type columnType) {
        if (StringUtils.isBlank((String)timestamp)) {
            return null;
        }
        DateTimeFormatter tzFormatter = ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.forID((String)timezoneId));
        DateTime dateTime = tzFormatter.parseDateTime(timestamp);
        return SqlFilterAndFlagOnDate.toCorrectJodaObject(dateTime, columnType);
    }

    private static Object toCorrectJodaObject(DateTime dateTime, Type columnType) {
        if (columnType == Type.DATEONLY) {
            return dateTime.toLocalDate();
        }
        if (columnType == Type.DATETIMENOTZ) {
            return dateTime.toLocalDateTime();
        }
        return dateTime;
    }

    private static boolean hasOnlyEmptyValues(List<String> values) {
        return values == null || values.stream().noneMatch(StringUtils::isNotBlank);
    }
}

