/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.types;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.input.formats.csv.RFC4180CSVParser;
import com.dataiku.dip.input.stream.InputStreamLineReader;
import com.dataiku.dip.input.stream.LineReader;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.shaker.types.AbstractAnumMeaning;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang.StringUtils;

public class USStateMeaning
extends AbstractAnumMeaning {
    private static Set<String> names = new HashSet<String>();
    private static Set<String> codes = new HashSet<String>();
    private static File statesFile = new File(ApplicationConfigurator.getInstallFolder() + "/resources/publicdata/usa_states/usa_states.csv.gz");
    private static DKULogger logger = DKULogger.getLogger((String)"dku.meaning.usstate");
    private static final Set<String> dataQualityRuleStatuses = Arrays.stream(AbstractCheckContext.CheckOutcome.values()).map(Enum::name).collect(Collectors.toSet());
    private static final String OK_STATE = AbstractCheckContext.CheckOutcome.OK.name();

    public double detects(String v) {
        if (StringUtils.isBlank((String)v)) {
            return 0.0;
        }
        if (dataQualityRuleStatuses.contains(v)) {
            return v.equals(OK_STATE) ? 0.01 : 0.0;
        }
        if (names.contains(v.toLowerCase())) {
            return 0.025;
        }
        if (codes.contains(v)) {
            return 0.018;
        }
        if (codes.contains(v.toUpperCase())) {
            return 0.009;
        }
        return 0.0;
    }

    static {
        try (GZIPInputStream is = new GZIPInputStream(new FileInputStream(statesFile));){
            InputStreamLineReader islr = new InputStreamLineReader((InputStream)is, "utf8");
            RFC4180CSVParser parser = new RFC4180CSVParser((LineReader)islr, ';');
            ArrayList<String> buff = new ArrayList<String>();
            parser.next(buff);
            while (parser.next(buff)) {
                if (buff.size() < 2) continue;
                codes.add((String)buff.get(0));
                names.add(((String)buff.get(1)).toLowerCase());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to load USStates data", (Throwable)e);
        }
    }
}

