/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.bigquery;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.helpers.RetryPolicyExecutor;
import com.dataiku.dip.connections.helpers.RetryPolicyExecutorFactory;
import com.dataiku.dip.sql.bigquery.BasicWriter;
import com.dataiku.dip.sql.bigquery.WriteStreamNotFoundException;
import com.dataiku.dip.sql.bigquery.Writer;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Params;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.json.JSONArray;

public class RetryingWriter
implements Writer<JSONArrayWorker> {
    private static final int DEFAULT_MAX_RETRIES = 30;
    private static final int DEFAULT_RETRY_DELAY_MS = 5000;
    private final BasicWriter basicWriter;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.bigquery.client.native");

    RetryingWriter(BasicWriter basicWriter) {
        this.basicWriter = basicWriter;
    }

    @Override
    public JSONArrayWorker createJSONArrayWorker() {
        return new JSONArrayWorker();
    }

    @Override
    public void commit(JSONArrayWorker worker) throws IOException {
        if (worker.basicWorker != null) {
            this.basicWriter.commit(worker.basicWorker);
        }
    }

    @Override
    public void commit(Iterable<JSONArrayWorker> workers) throws IOException {
        List<BasicWriter.JSONArrayWorker> basicWorkers = StreamSupport.stream(workers.spliterator(), false).map(w -> w.basicWorker).filter(Objects::nonNull).collect(Collectors.toList());
        if (!basicWorkers.isEmpty()) {
            this.basicWriter.commit((Iterable<BasicWriter.JSONArrayWorker>)basicWorkers);
        }
    }

    public class JSONArrayWorker
    implements Writer.JSONArrayWorker {
        private BasicWriter.JSONArrayWorker basicWorker;

        private JSONArrayWorker() {
        }

        @Override
        public void append(JSONArray data, long offset) throws Exception {
            if (this.basicWorker != null) {
                this.basicWorker.append(data, offset);
                return;
            }
            Params params = DKUApp.getParams();
            int maxRetries = params.getIntParam("dku.sql.bigquery.writer.maxRetries", Integer.valueOf(30));
            int retryDelayMS = params.getIntParam("dku.sql.bigquery.writer.retryDelayMS", Integer.valueOf(5000));
            logger.infoV("About to create write stream and append first batch, maxRetries=%d retryDelayMS=%d", new Object[]{maxRetries, retryDelayMS});
            RetryPolicyExecutor retryPolicyExecutor = RetryPolicyExecutorFactory.createRetryExceptionPolicyExecutor().withMaxRetries(maxRetries).withDelay(retryDelayMS).withDelayMultiplier(1.1).retryOn(e -> {
                if (!(e instanceof WriteStreamNotFoundException)) {
                    return false;
                }
                logger.warn((Object)"Caught WriteStreamNotFoundException. Trying again.", (Throwable)e);
                return true;
            });
            retryPolicyExecutor.execute(() -> {
                try {
                    this.basicWorker = RetryingWriter.this.basicWriter.createJSONArrayWorker();
                    this.basicWorker.append(data, offset);
                }
                catch (WriteStreamNotFoundException e) {
                    if (this.basicWorker != null) {
                        this.basicWorker.close();
                    }
                    throw e;
                }
            });
        }

        @Override
        public void finalizeStream() throws IOException {
            if (this.basicWorker != null) {
                this.basicWorker.finalizeStream();
            }
        }

        @Override
        public void close() {
            if (this.basicWorker != null) {
                this.basicWorker.close();
            }
        }
    }
}

