/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sqlnotebooks;

import com.dataiku.dip.datasets.ColoringDefinition;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dip.pivot.frontend.model.CustomMeasure;
import com.dataiku.dip.pivot.frontend.model.DimensionDef;
import com.dataiku.dip.pivot.frontend.model.HierarchyDef;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.theming.model.DSSVisualizationTheme;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLNotebookResultExploreParams {
    private final Map<String, CellExploreParams> perCellParams = new HashMap<String, CellExploreParams>();

    public SerializedShakerScript getExploreScript(String cellId) {
        return this.perCellParams.getOrDefault((Object)cellId, (CellExploreParams)new CellExploreParams()).script;
    }

    public ChartParams getExploreChart(String cellId) {
        return this.perCellParams.getOrDefault((Object)cellId, (CellExploreParams)new CellExploreParams()).chartParams;
    }

    public void setScript(String cellId, SerializedShakerScript script) {
        CellExploreParams cellParams = this.perCellParams.computeIfAbsent(cellId, _unused -> new CellExploreParams());
        cellParams.script = script;
    }

    public void setChartParams(String cellId, ChartParams chartParams) {
        CellExploreParams cellParams = this.perCellParams.computeIfAbsent(cellId, _unused -> new CellExploreParams());
        cellParams.chartParams = chartParams;
    }

    public void deleteCell(String cellId) {
        this.perCellParams.remove(cellId);
    }

    @VisibleForTesting
    public boolean containsCell(String cellId) {
        return this.perCellParams.containsKey(cellId);
    }

    public static class CellExploreParams {
        public SerializedShakerScript script = new SerializedShakerScript();
        public ChartParams chartParams;

        public CellExploreParams() {
            this.script.origin = SerializedShakerScript.ShakerOrigin.SQL_NOTEBOOK;
            this.script.coloring.scheme = ColoringDefinition.TableColoringScheme.COLORING_GROUPS;
            this.chartParams = new ChartParams();
        }
    }

    public static class ChartParams {
        public List<ResultDataChart> charts = new ArrayList<ResultDataChart>();
    }

    public static class ResultDataChart {
        public ChartDef def;
        public DSSVisualizationTheme theme;
        public List<CustomMeasure> customMeasures = new ArrayList<CustomMeasure>();
        public List<DimensionDef> reusableDimensions = new ArrayList<DimensionDef>();
        public List<HierarchyDef> hierarchies = new ArrayList<HierarchyDef>();
    }
}

