/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dss.shadelib.com.google.gson.Gson;
import com.dataiku.dss.shadelib.com.google.gson.JsonArray;
import com.dataiku.dss.shadelib.com.google.gson.JsonElement;
import com.dataiku.dss.shadelib.com.google.gson.JsonObject;
import com.dataiku.dss.shadelib.com.google.gson.JsonPrimitive;
import com.dataiku.dss.shadelib.com.google.gson.JsonSyntaxException;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class StringBasedFormats {

    public static class JSONLineFormatSerializer {
        private final ColumnFactory cf;
        private final Gson gson = new Gson();
        private final Boolean booleanMeaning = new Boolean();
        private final Map<String, SchemaColumn> schemaColumns = Maps.newHashMap();
        private final Set<String> columns = Sets.newHashSet();

        public JSONLineFormatSerializer(ColumnFactory cf, Schema schema, List<String> columns) {
            this.cf = cf;
            if (columns != null) {
                this.columns.addAll(columns);
            }
            if (schema != null) {
                for (SchemaColumn col : schema.columns) {
                    this.schemaColumns.put(col.getName(), col);
                }
            }
        }

        public String serialize(Row row) {
            JsonObject jsonObj = new JsonObject();
            for (Column c2 : this.cf.columns()) {
                JsonElement serialized;
                String v;
                if (!this.columns.isEmpty() && !this.columns.contains(c2.getName()) || (v = row.get(c2)) == null) continue;
                SchemaColumn schemaColumn = this.schemaColumns.get(c2.getName());
                if (schemaColumn == null) {
                    schemaColumn = new SchemaColumn(c2.getName(), Type.STRING);
                }
                if ((serialized = this.serialize(v, schemaColumn)) == null) continue;
                jsonObj.add(c2.getName(), serialized);
            }
            return this.gson.toJson((JsonElement)jsonObj);
        }

        private JsonElement serialize(String value, SchemaColumn schemaColumn) {
            switch (schemaColumn.getType()) {
                case BOOLEAN: {
                    java.lang.Boolean b = this.booleanMeaning.parseNoFail(value);
                    if (b != null) {
                        return new JsonPrimitive(b);
                    }
                    return null;
                }
                case DOUBLE: 
                case FLOAT: {
                    Double d = Doubles.tryParse((String)value);
                    if (d != null) {
                        return new JsonPrimitive((Number)d);
                    }
                    return null;
                }
                case TINYINT: 
                case SMALLINT: 
                case INT: 
                case BIGINT: {
                    Long l = Longs.tryParse((String)value);
                    if (l != null) {
                        return new JsonPrimitive((Number)l);
                    }
                    if (StringUtils.isNotBlank((String)value)) {
                        Double d = Doubles.tryParse((String)value);
                        if (d != null) {
                            return new JsonPrimitive((Number)d.longValue());
                        }
                        return null;
                    }
                    return null;
                }
                case DATE: 
                case DATEONLY: 
                case DATETIMENOTZ: {
                    return new JsonPrimitive(value);
                }
                case ARRAY: {
                    try {
                        return (JsonElement)this.gson.fromJson(value, JsonArray.class);
                    }
                    catch (JsonSyntaxException e) {
                        return null;
                    }
                }
                case MAP: 
                case OBJECT: {
                    try {
                        return (JsonElement)this.gson.fromJson(value, JsonObject.class);
                    }
                    catch (JsonSyntaxException e) {
                        return null;
                    }
                }
            }
            return new JsonPrimitive(value);
        }
    }

    public static class JSONLineFormatDeserializer {
        private final ColumnFactory cf;
        private final Gson gson = new Gson();
        private final Set<String> columns = Sets.newHashSet();

        public JSONLineFormatDeserializer(ColumnFactory cf, List<String> columns) {
            this.cf = cf;
            if (columns != null) {
                this.columns.addAll(columns);
            }
        }

        public void deserialize(String record, Row row) {
            JsonObject jsonObj = (JsonObject)this.gson.fromJson(record, JsonObject.class);
            if (jsonObj == null || jsonObj.isJsonNull()) {
                return;
            }
            for (Map.Entry e : jsonObj.entrySet()) {
                JsonElement v;
                String column = (String)e.getKey();
                if (!this.columns.isEmpty() && !this.columns.contains(column) || (v = (JsonElement)e.getValue()).isJsonNull()) continue;
                if (v instanceof JsonPrimitive) {
                    row.put(this.cf.column(column), ((JsonPrimitive)v).getAsString());
                    continue;
                }
                row.put(this.cf.column(column), this.gson.toJson(v));
            }
        }
    }

    public static class SingleValueFormatSerializer {
        private final ColumnFactory cf;
        private final String columnName;

        public SingleValueFormatSerializer(ColumnFactory cf, String columnName) {
            this.cf = cf;
            this.columnName = columnName;
        }

        public String serialize(Row row) {
            if (StringUtils.isNotBlank((String)this.columnName)) {
                return row.get(this.cf.column(this.columnName));
            }
            return null;
        }
    }

    public static class SingleValueFormatDeserializer {
        private final ColumnFactory cf;
        private final String columnName;

        public SingleValueFormatDeserializer(ColumnFactory cf, String columnName) {
            this.cf = cf;
            this.columnName = columnName;
        }

        public void deserialize(String record, Row row) {
            if (StringUtils.isNotBlank((String)this.columnName)) {
                row.put(this.cf.column(this.columnName), record);
            }
        }
    }
}

