/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.httpsse;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.security.DefaultRedirectStrategyWithIPBlacklist;
import com.dataiku.dip.security.IPBlacklistVerifier;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePuller;
import com.dataiku.dip.streaming.endpoints.httpsse.HTTPSSEStreamingEndpointParams;
import com.dataiku.dip.streaming.endpoints.httpsse.SSEDecoder;
import com.dataiku.dip.streaming.endpoints.httpsse.TrivialSSEClient;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.dss.shadelib.org.apache.http.client.RedirectStrategy;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;

public class HTTPSSESimplePuller
implements StreamingEndpointSimplePuller {
    private final HTTPSSEStreamingEndpointParams params;
    private volatile boolean closed;
    private ColumnFactory cf;
    private RowFactory rf;
    private TrivialSSEClient client;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.streaming.endpoints.httpsse.puller");

    public HTTPSSESimplePuller(HTTPSSEStreamingEndpointParams params) {
        this.params = params;
    }

    @Override
    public void init(ColumnFactory cf, RowFactory rf, Schema readSchema, JsonElement previousState) throws Exception {
        if (StringUtils.isBlank((CharSequence)this.params.url)) {
            throw new CodedException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Missing or empty URL parameter. Make sure it is set in the endpoint settings.");
        }
        this.cf = cf;
        this.rf = rf;
        ProxySettings dummyProxySettings = new ProxySettings();
        IPBlacklistVerifier.validateUriNotBlacklisted(this.params.url, dummyProxySettings);
        DefaultRedirectStrategyWithIPBlacklist redirectStrategy = new DefaultRedirectStrategyWithIPBlacklist(dummyProxySettings);
        this.client = new TrivialSSEClient(this.params.url, this.params.headers, (RedirectStrategy)redirectStrategy);
        this.client.init(previousState == null ? null : previousState.getAsString());
    }

    @Override
    public void setLimit(JsonElement limit) {
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public StreamingEndpointSimplePuller.RowsPulled next() throws Exception {
        SSEDecoder.HTTPSSEEvent evt = this.client.next();
        if (evt != null) {
            Row row = this.rf.row();
            row.put(this.cf.column("type"), evt.type);
            row.put(this.cf.column("data"), evt.data);
            StreamingEndpointSimplePuller.RowsPulled pulled = new StreamingEndpointSimplePuller.RowsPulled();
            pulled.rows = Lists.newArrayList((Object[])new Row[]{row});
            pulled.state = evt.eventId == null ? null : new JsonPrimitive(evt.eventId);
            return pulled;
        }
        logger.info((Object)"Reached end of HTTP SSE stream");
        return null;
    }
}

