/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring;

import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.server.services.NodesService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.ModelStatus;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringModelStatusComputationService;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringPaths;
import com.dataiku.dip.unifiedmonitoring.project.ProjectModelStatus;
import com.dataiku.dip.unifiedmonitoring.project.ProjectScenarioRunsDTO;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedMonitoringAutomationComputationService {
    @Autowired
    UnifiedMonitoringModelStatusComputationService unifiedMonitoringModelStatusComputationService;
    @Autowired
    NodesService nodesService;
    @Autowired
    SavedModelsCRUDService savedModelsCRUDService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    ScenariosService scenariosService;
    @Autowired
    UsersService usersService;
    private final DKULogger logger = DKULogger.getLogger((String)"dku.services.unifiedMonitoringAutomationComputationService");

    @PostConstruct
    private void init() {
        if (!this.nodesService.isAutomationNode()) {
            return;
        }
        if (!FeatureFlags.isEnabled((String)"unifiedMonitoring.preserveDataOnStartup")) {
            this.logger.infoV("Starting up, clearing Unified Monitoring automation directory", new Object[0]);
            File unifiedMonitoringAutomationDirectory = UnifiedMonitoringPaths.getAutomationBaseDir();
            try {
                DKUFileUtils.deleteDirectory((File)unifiedMonitoringAutomationDirectory);
            }
            catch (IOException e) {
                this.logger.warn((Object)String.format("Unable to clear directory: %s", unifiedMonitoringAutomationDirectory), (Throwable)e);
            }
        }
    }

    public ModelStatus getOrComputeModelStatus(String projectKey, FullModelId fullModelId, @Nullable List<String> mesToFilterOn) throws Exception {
        return this.unifiedMonitoringModelStatusComputationService.getOrComputeModelStatus(projectKey, fullModelId, mesToFilterOn);
    }

    @Nonnull
    public ProjectModelStatus getProjectModelStatus(String projectKey) throws Exception {
        List<SavedModel> savedModels;
        try (Transaction t = this.transactionService.beginRead();){
            savedModels = this.savedModelsCRUDService.listUnsafe(projectKey);
        }
        ArrayList<ModelStatus> modelStatuses = new ArrayList<ModelStatus>();
        for (SavedModel savedModel : savedModels) {
            if (!savedModel.savedModelType.isML() || savedModel.activeVersion == null) continue;
            FullModelId fullModelId = new FullModelId(projectKey, savedModel.id, savedModel.activeVersion);
            try {
                ModelStatus modelStatus = this.unifiedMonitoringModelStatusComputationService.getOrComputeModelStatus(projectKey, fullModelId, null);
                modelStatuses.add(modelStatus);
            }
            catch (Exception e) {
                throw new Exception(String.format("Failed to compute model status for smv %s", fullModelId), e);
            }
        }
        return new ProjectModelStatus(modelStatuses);
    }

    private ProjectScenarioRunsDTO.ProjectScenarioRunDTO getScenarioRunDto(Scenario scenario) throws SQLException {
        String runAsUser;
        try (Transaction t = this.transactionService.beginRead();){
            runAsUser = scenario.runAsUser;
            if (StringUtils.isBlank((String)runAsUser)) {
                if (scenario.getVersionTag() != null) {
                    runAsUser = scenario.getVersionTag().getLastAuthor();
                } else if (scenario.getCreationTag() != null) {
                    runAsUser = scenario.getCreationTag().getLastAuthor();
                }
            }
            try {
                runAsUser = this.usersService.getPublicUser((String)runAsUser).displayName;
            }
            catch (IOException e) {
                this.logger.info((Object)String.format("Unable to retrieve scenario user for scenario %s", scenario.id), (Throwable)e);
            }
        }
        List<ScenarioRun> scenarioRuns = this.scenariosService.getLastRuns(scenario, 2, false, true);
        Optional<ScenarioRun> runOptional = scenarioRuns.stream().filter(scenarioRun -> scenarioRun.getEnd() != 0L).findFirst();
        if (runOptional.isEmpty()) {
            return null;
        }
        ScenarioRun run = runOptional.get();
        return new ProjectScenarioRunsDTO.ProjectScenarioRunDTO(run.trigger.scenarioId, run.scenario.name, run.end, runAsUser, run.result != null ? run.result.outcome : null);
    }

    public ProjectScenarioRunsDTO getScenariosRun(String projectKey) throws IOException {
        List<Scenario> scenarios;
        try (Transaction t = this.transactionService.beginRead();){
            scenarios = this.scenariosService.listUnsafe(projectKey);
        }
        ArrayList<ProjectScenarioRunsDTO.ProjectScenarioRunDTO> scenariosRuns = new ArrayList<ProjectScenarioRunsDTO.ProjectScenarioRunDTO>();
        for (Scenario scenario : scenarios) {
            if (!scenario.active) continue;
            try {
                ProjectScenarioRunsDTO.ProjectScenarioRunDTO run = this.getScenarioRunDto(scenario);
                if (run == null) continue;
                scenariosRuns.add(run);
            }
            catch (Exception e) {
                this.logger.info((Object)String.format("Unable to compute scenario runs for scenario %s", scenario.id), (Throwable)e);
            }
        }
        return new ProjectScenarioRunsDTO(scenariosRuns);
    }
}

