/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring.project;

import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@UIModel
public class ProjectWebappMonitoringStatus {
    public List<WebappInfo> stopped = new ArrayList<WebappInfo>();
    public List<WebappInfo> ready = new ArrayList<WebappInfo>();
    public List<WebappInfo> notReady = new ArrayList<WebappInfo>();
    public boolean hasWebapps;

    public ProjectWebappMonitoringStatus(@Nullable List<WebAppsService.BackendInfo> webappBackendInfoList, boolean considersOnlyAutoStartedWebapps) {
        if (webappBackendInfoList == null) {
            return;
        }
        for (WebAppsService.BackendInfo backendInfo : webappBackendInfoList) {
            if (considersOnlyAutoStartedWebapps && !backendInfo.isBackendAutostartOn) continue;
            WebappInfo webappInfo = new WebappInfo(backendInfo.id, backendInfo.name, backendInfo.type, backendInfo.status);
            if (webappInfo.status == WebAppsService.Status.STOPPED) {
                this.stopped.add(webappInfo);
                continue;
            }
            if (webappInfo.status == WebAppsService.Status.BACKEND_NOT_READY) {
                this.notReady.add(webappInfo);
                continue;
            }
            if (webappInfo.status != WebAppsService.Status.BACKEND_READY) continue;
            this.ready.add(webappInfo);
        }
        this.hasWebapps = !this.stopped.isEmpty() || !this.ready.isEmpty() || !this.notReady.isEmpty();
    }

    @UIModel
    public static class WebappInfo {
        public String id;
        public String name;
        public String type;
        private final WebAppsService.Status status;

        public WebappInfo(String id, String name, String type, WebAppsService.Status status) {
            this.id = id;
            this.name = name;
            this.type = type;
            this.status = status;
        }
    }
}

