/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.common.rpc.InternalAPIClient;
import com.dataiku.common.rpc.NoAuthAPIClient;
import com.dataiku.common.rpc.NoAuthThrottlingAPIClient;
import com.dataiku.common.rpc.ProxyUserAPIClient;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.analysis.docgen.helpers.UrlUtil;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.LegacyGlobalScopePublicAPIKey;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.api.auth.PublicAPIKeysService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendsManager;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class AIFeaturesUtil {
    public static final int GPT_MAX_TOKENS = 128000;
    public static final int CHARS_PER_TOKEN = 4;
    public static final int MAX_SAMPLE_ROWS = 5;
    public static final int MAX_COLUMN_COUNT = 50;
    public static final String DEFAULT_URL = "https://ai.api-services.dataiku.io/";
    public static final int CONNECTION_TIMEOUT = DKUApp.getParams().getIntParam("dku.dada.AIServer.network.connection.timeout", Integer.valueOf(30000));
    public static final int SOCKET_TIMEOUT = DKUApp.getParams().getIntParam("dku.dada.AIServer.network.socket.timeout", Integer.valueOf(60000));
    private static final Map<String, GeneralSettingsDAO.LocalAIServerSettings.AiAssistant> featureToAiAssistant = ImmutableMap.ofEntries((Map.Entry[])new Map.Entry[]{Map.entry("text2recipe", GeneralSettingsDAO.LocalAIServerSettings.AiAssistant.prepareAICompletion), Map.entry("text2sql", GeneralSettingsDAO.LocalAIServerSettings.AiAssistant.aiGenerateSQL), Map.entry("generateSteps", GeneralSettingsDAO.LocalAIServerSettings.AiAssistant.prepareAICompletion), Map.entry("text2story_presentation", GeneralSettingsDAO.LocalAIServerSettings.AiAssistant.storiesAI), Map.entry("text2story_chart", GeneralSettingsDAO.LocalAIServerSettings.AiAssistant.storiesAI)});
    static final DKULogger logger = DKULogger.getLogger(AIFeaturesUtil.class);

    public static String getAIServerUrl(GeneralSettingsDAO.GeneralSettings settings, GeneralSettingsDAO.LocalAIServerSettings.AiAssistant aiAssistant) {
        if (settings != null && settings.localAIServerSettings.isLocalAiAssistantEnabled(aiAssistant)) {
            if (StringUtils.isBlank((String)settings.localAIServerSettings.webappReference)) {
                throw new IllegalArgumentException("No web app selected to run the AI services with the LLM mesh connections. Please ask your administrator to fix the settings of the AI services.");
            }
            String[] webAppReferenceSplit = settings.localAIServerSettings.webappReference.split("\\.", 2);
            if (webAppReferenceSplit.length != 2) {
                throw new IllegalArgumentException("Invalid web app reference ID selected to run the AI services with the LLM mesh connections. Please ask your administrator to fix the settings of the AI services.");
            }
            try {
                String projectKey = webAppReferenceSplit[0];
                String webAppId = webAppReferenceSplit[1];
                WebAppBackendsManager webAppBackendsManager = (WebAppBackendsManager)SpringUtils.getBean(WebAppBackendsManager.class);
                WebAppBackend webAppBackend = webAppBackendsManager.getBackendOrNull(projectKey, webAppId);
                if (webAppBackend != null) {
                    return UrlUtil.getDSSInternalRootUrl(settings) + webAppBackend.getBackendUrl();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to retrieve AI server webapp", (Throwable)e);
            }
            throw new IllegalArgumentException("Unable to connect to AI assistant server, please contact your administrator.");
        }
        if (settings == null || !settings.aiDrivenAnalyticsSettings.dataikuAIServicesTermsOfUseAccepted) {
            throw new IllegalStateException("The administrator hasn't accepted the AI Terms of Uses");
        }
        return DKUApp.getParams().getParam("dku.dada.defaultEndpoint", DEFAULT_URL);
    }

    public static InternalAPIClient getAiServerAPIClient(AuthCtx authCtx, GeneralSettingsDAO.GeneralSettings settings, GeneralSettingsDAO.LocalAIServerSettings.AiAssistant aiAssistant, int connectionTimeout, int socketTimeout) throws IOException, DKUSecurityException {
        return AIFeaturesUtil.getAiServerAPIClient(authCtx, settings, aiAssistant, connectionTimeout, socketTimeout, 0, 0);
    }

    public static InternalAPIClient getAiServerAPIClient(AuthCtx authCtx, GeneralSettingsDAO.GeneralSettings settings, GeneralSettingsDAO.LocalAIServerSettings.AiAssistant aiAssistant, int connectionTimeout, int socketTimeout, int maxRetries, int defaultSleepSeconds) throws IOException, DKUSecurityException {
        String aiServerUrl = AIFeaturesUtil.getAIServerUrl(settings, aiAssistant);
        logger.info((Object)("Querying AI server URL: " + aiServerUrl));
        if (settings == null || !settings.localAIServerSettings.isLocalAiAssistantEnabled(aiAssistant)) {
            if (maxRetries > 0) {
                return new NoAuthThrottlingAPIClient(aiServerUrl, false, ApplicationConfigurator.getProxySettings(), connectionTimeout, socketTimeout, maxRetries, defaultSleepSeconds);
            }
            return new NoAuthAPIClient(aiServerUrl, false, ApplicationConfigurator.getProxySettings(), connectionTimeout, socketTimeout);
        }
        String[] webAppReferenceSplit = settings.localAIServerSettings.webappReference.split("\\.", 2);
        if (webAppReferenceSplit.length != 2) {
            throw new IllegalArgumentException("Invalid web app reference ID selected to run the AI services with the LLM mesh connections. Please ask your administrator to fix the settings of the AI services.");
        }
        String projectKey = webAppReferenceSplit[0];
        String webAppId = webAppReferenceSplit[1];
        ProjectsService projectsService = (ProjectsService)SpringUtils.getBean(ProjectsService.class);
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        try (Transaction t = transactionService.retrieveOrBeginRead();){
            if (!projectsService.hasDashboardReadPermission(authCtx, SmartObjectRef.fromSmartName(ITaggingService.TaggableType.WEB_APP, webAppId), projectKey)) {
                throw new UnauthorizedException("You don't have access to the AI Assistant Project. Ask your admin to give you access in order to use this feature", "webapp-access-failed");
            }
        }
        boolean trustAllSSLCertificates = DKUApp.getParams().getBoolParam("dku.feature.localAIServerWebapp.trustAllSSLCertificates", false);
        PublicAPIKeysService publicApiKeyService = (PublicAPIKeysService)SpringUtils.getBean(PublicAPIKeysService.class);
        LegacyGlobalScopePublicAPIKey apiKey = publicApiKeyService.getInMemoryAPIKey("AI Assistant", "AI Assistant", null);
        return new ProxyUserAPIClient(authCtx, aiServerUrl, apiKey.getKey(), trustAllSSLCertificates);
    }

    public static Set<String> collectSampleRowValues(MemScriptRunner.TableWithReport twr, MemColumn mc, Feature feature, String query) {
        HashSet<String> rowVals = new HashSet<String>();
        int queryTokens = query.length() / 4;
        int maxSampleRowCharsAllowed = (128000 - feature.getDefaultPromptSize() - queryTokens) / Math.min(twr.table.ncols(), 50) * 4;
        int totalSampleRowValueChars = 0;
        for (int i = 0; i < twr.table.nrows(); ++i) {
            String v = twr.table.rows.get(i).get(mc);
            if (v != null && !rowVals.contains(v)) {
                if (totalSampleRowValueChars + v.length() > maxSampleRowCharsAllowed) break;
                rowVals.add(v);
                totalSampleRowValueChars += v.length();
            }
            if (i > 50 || rowVals.size() > 5) break;
        }
        return rowVals;
    }

    public static boolean sendRating(Boolean isSuccess, String feedback, String requestId, String featureName, LicenseStatusService.LicensingStatus licensingStatus) {
        boolean bl;
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        if (generalSettings.localAIServerSettings.isLocalAiAssistantEnabled(featureToAiAssistant.get(featureName))) {
            logger.info((Object)("Ratings not sent because local AI server is used for feature " + featureName + ". The feedback was " + feedback));
            return false;
        }
        RatingRequest ratingRequest = new RatingRequest();
        ratingRequest.isSuccess = isSuccess;
        ratingRequest.requestId = requestId;
        ratingRequest.feedback = feedback;
        ratingRequest.featureName = featureName;
        ratingRequest.licenseId = licensingStatus != null && licensingStatus.licenseContent != null ? licensingStatus.licenseContent.licenseId : null;
        String managerURL = DKUApp.getParams().getParam("dku.dada.defaultEndpoint", DEFAULT_URL);
        NoAuthAPIClient apiClient = new NoAuthAPIClient(managerURL, false, ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().proxySettings, CONNECTION_TIMEOUT, SOCKET_TIMEOUT);
        try {
            apiClient.postObject("/log-user-rating", RatingRequest.class, (Object)ratingRequest);
            bl = !generalSettings.localAIServerSettings.isLocalAiAssistantEnabled(featureToAiAssistant.get(featureName));
        }
        catch (Throwable throwable) {
            try {
                try {
                    apiClient.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to log user rating for AI feature: " + featureName));
                return false;
            }
        }
        apiClient.close();
        return bl;
    }

    public static void logValidation(String requestId, String validationText, LicenseStatusService.LicensingStatus licensingStatus, boolean telemetryEnabled, String featureName, boolean validationSuccess, GeneralSettingsDAO.GeneralSettings generalSettings) {
        GeneralSettingsDAO.LocalAIServerSettings.AiAssistant aiAssistant = featureToAiAssistant.get(featureName);
        if (generalSettings.localAIServerSettings.isLocalAiAssistantEnabled(aiAssistant)) {
            logger.debug((Object)("Validation not sent because local AI server is used for feature " + featureName));
            return;
        }
        if (requestId == null) {
            logger.info((Object)"Validation not sent because requestId is null");
            return;
        }
        String licenseId = licensingStatus != null && licensingStatus.licenseContent != null ? licensingStatus.licenseContent.licenseId : null;
        try (InternalAPIClient apiClient = AIFeaturesUtil.getAiServerAPIClient(null, generalSettings, aiAssistant, CONNECTION_TIMEOUT, SOCKET_TIMEOUT);){
            apiClient.postObject("log-validation-status", AiAssistantBackendValidationResponse.class, (Object)new AiAssistantBackendValidationResponse(requestId, featureName, validationText, licenseId, telemetryEnabled, validationSuccess));
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to log validation for AI feature: " + featureName), (Throwable)e);
        }
    }

    public static void parseAndValidateExplanationOptions(String explanationOptions) {
        String verbosity;
        String purpose;
        JsonObject options = (JsonObject)JSON.parse((String)explanationOptions, JsonObject.class);
        List<String> supportedLanguages = List.of("dutch", "english", "french", "german", "japanese", "portuguese", "spanish");
        List<String> supportedPurposes = List.of("GENERIC", "TECHNICAL", "BUSINESS_ORIENTED", "EXECUTIVE");
        List<String> supportedVerbosity = List.of("LOW", "MEDIUM", "HIGH");
        String language = options.get("language").getAsString();
        if (!supportedLanguages.contains(language)) {
            throw new IllegalArgumentException(String.format("Invalid language: '%s'. Currently supported languages: %s", language, supportedLanguages));
        }
        if (options.has("purpose") && !supportedPurposes.contains(purpose = options.get("purpose").getAsString())) {
            throw new IllegalArgumentException(String.format("Invalid purpose: '%s'. Supported purposes: %s", purpose, supportedPurposes));
        }
        if (options.has("verbosity") && !supportedVerbosity.contains(verbosity = options.get("verbosity").getAsString())) {
            throw new IllegalArgumentException(String.format("Invalid verbosity: '%s'. Supported verbosity levels: %s", verbosity, supportedVerbosity));
        }
    }

    public static enum Feature {
        AIPREPARE(3000),
        AIRECIPE(5000),
        AIEXPLAINDATASET(5000);

        private final int defaultPromptSize;

        private Feature(int defaultPromptSize) {
            this.defaultPromptSize = defaultPromptSize;
        }

        public int getDefaultPromptSize() {
            return this.defaultPromptSize;
        }
    }

    public static class RatingRequest {
        String requestId;
        Boolean isSuccess;
        String licenseId;
        String feedback;
        String featureName;
    }

    private static class AiAssistantBackendValidationResponse {
        String requestId;
        String featureName;
        String validationText;
        String licenseId;
        boolean telemetryEnabled;
        boolean validationSuccess;

        public AiAssistantBackendValidationResponse(String requestId, String featureName, String validationText, String licenseId, boolean telemetryEnabled, boolean validationSuccess) {
            this.requestId = requestId;
            this.featureName = featureName;
            this.validationText = telemetryEnabled ? validationText : null;
            this.licenseId = telemetryEnabled ? licenseId : null;
            this.telemetryEnabled = telemetryEnabled;
            this.validationSuccess = validationSuccess;
        }
    }
}

