/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.remoterun.RemoteRunEnvHelper;
import com.dataiku.dip.util.AnyLoc;
import org.apache.commons.lang.StringUtils;

public class DatasetLocUtils {
    public static DatasetLoc resolveSmart(String contextProjectKey, String name) {
        if (name.contains(".")) {
            String[] chunks = StringUtils.split((String)name, (String)".");
            return new DatasetLoc(chunks[0], chunks[1]);
        }
        if (contextProjectKey == null) {
            throw new IllegalArgumentException("A full dataset name (in the form PROJECT_KEY.DATASET_NAME) is required");
        }
        return new DatasetLoc(contextProjectKey, name);
    }

    public static DatasetLoc resolveFull(String fullName) {
        if (fullName.contains(".")) {
            String[] chunks = StringUtils.split((String)fullName, (String)".");
            return new DatasetLoc(chunks[0], chunks[1]);
        }
        throw new IllegalArgumentException("A full dataset name (in the form PROJECT_KEY.DATASET_NAME) is required");
    }

    public static DatasetLoc resolveWithEnvDefault(String name) {
        if (name.contains(".")) {
            String[] chunks = StringUtils.split((String)name, (String)".");
            return new DatasetLoc(chunks[0], chunks[1]);
        }
        if (RemoteRunEnvHelper.getEnv("DKU_DEFAULT_PROJECT") == null) {
            throw new IllegalArgumentException("No DKU_DEFAULT_PROJECT env variable, a full dataset name (in the form PROJECT_KEY.DATASET_NAME) is required");
        }
        return new DatasetLoc(RemoteRunEnvHelper.getEnv("DKU_DEFAULT_PROJECT"), name);
    }

    public static DatasetLoc forDataset(SerializedDataset dataset) {
        return new DatasetLoc(dataset.projectKey, dataset.name);
    }

    public static class DatasetLoc
    extends AnyLoc {
        private static final long serialVersionUID = 1L;

        public DatasetLoc(String projectKey, String name) {
            super(projectKey, name);
        }

        public String getName() {
            return this.getId();
        }
    }
}

