/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.variables;

import com.dataiku.dip.variables.HierarchicalVariablesContext;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DynamicLevelsStack {
    static ThreadLocal<DynamicLevelsStack> localStack = new InheritableThreadLocal<DynamicLevelsStack>(){

        @Override
        public DynamicLevelsStack childValue(DynamicLevelsStack parentValue) {
            return new DynamicLevelsStack(parentValue);
        }
    };
    private List<JsonObject> levels = new ArrayList<JsonObject>();

    public DynamicLevelsStack() {
    }

    public DynamicLevelsStack(DynamicLevelsStack parent) {
        this.levels.addAll(parent.levels);
    }

    private void _pushLevel(JsonObject level) {
        this.levels.add(level);
    }

    private void _popLevel() {
        assert (this.levels.size() > 0);
        this.levels.remove(this.levels.size() - 1);
    }

    private void _fill(HierarchicalVariablesContext hvc) {
        for (JsonObject level : this.levels) {
            hvc.addLevel(level);
        }
    }

    public static void pushLevel(JsonObject level) {
        if (localStack.get() == null) {
            localStack.set(new DynamicLevelsStack());
        }
        localStack.get()._pushLevel(level);
    }

    public static void popLevel() {
        if (localStack.get() == null) {
            localStack.set(new DynamicLevelsStack());
        }
        localStack.get()._popLevel();
    }

    public static void fill(HierarchicalVariablesContext hvc) {
        if (localStack.get() == null) {
            localStack.set(new DynamicLevelsStack());
        }
        localStack.get()._fill(hvc);
    }

    public static AutoCloseable withLevel(JsonObject level) {
        DynamicLevelsStack.pushLevel(level);
        return new AutoCloseable(){

            @Override
            public void close() throws IOException {
                DynamicLevelsStack.popLevel();
            }
        };
    }
}

