/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.variables;

import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OverrideTable {
    public List<Override> overrides = new ArrayList<Override>();
    private static Logger logger = Logger.getLogger((String)"dku.variables");

    public void addOverride(String path, String expr) {
        Override o = new Override();
        o.path = path;
        o.expr = expr;
        this.overrides.add(o);
    }

    private List<String> chunkify(String path) {
        String[] chunks = StringUtils.split((String)path, (String)".");
        ArrayList<String> out = new ArrayList<String>();
        for (String chunk : chunks) {
            if (chunk.contains("[")) {
                String[] c2 = StringUtils.split((String)chunk, (char)'[');
                out.add(c2[0]);
                out.add("[" + c2[1]);
                continue;
            }
            out.add(chunk);
        }
        return out;
    }

    protected TreeLoc findRecInObj(List<String> chunks, JsonObject cur) {
        String localPath = chunks.get(0);
        assert (!StringUtils.isBlank((String)localPath));
        boolean hasMore = chunks.size() > 1;
        JsonElement elt = cur.get(localPath);
        if (elt == null && hasMore) {
            throw new IllegalArgumentException("Failed to override, did not find : " + localPath + " in " + String.valueOf(cur));
        }
        if (elt == null) {
            cur.addProperty(localPath, "");
            elt = cur.get(localPath);
        }
        if (hasMore) {
            if (elt.isJsonObject()) {
                return this.findRecInObj(chunks.subList(1, chunks.size()), elt.getAsJsonObject());
            }
            return this.findRecInArr(chunks.subList(1, chunks.size()), elt.getAsJsonArray());
        }
        TreeLoc tl = new TreeLoc();
        tl.parentObj = cur;
        tl.objKey = localPath;
        tl.valueElt = elt;
        return tl;
    }

    protected TreeLoc findRecInArr(List<String> chunks, JsonArray cur) {
        boolean hasMore;
        String localPath = chunks.get(0);
        boolean bl = hasMore = chunks.size() > 1;
        assert (!StringUtils.isBlank((String)localPath));
        if (!chunks.get(0).startsWith("[")) {
            throw ErrorContext.iae((String)("Failed to override, expected an array element but got " + localPath + " for " + String.valueOf(cur)));
        }
        int idx = 0;
        try {
            idx = Integer.parseInt(StringUtils.remove((String)StringUtils.remove((String)chunks.get(0), (char)'['), (char)']'));
        }
        catch (Exception e) {
            throw ErrorContext.iae((String)("Failed to override, invalid chunk in expression: " + chunks.get(0)));
        }
        if (idx >= cur.size()) {
            throw new IllegalArgumentException("Failed to override, index " + idx + " is invalid in " + String.valueOf(cur));
        }
        JsonElement elt = cur.get(idx);
        if (hasMore) {
            if (elt.isJsonObject()) {
                return this.findRecInObj(chunks.subList(1, chunks.size()), elt.getAsJsonObject());
            }
            return this.findRecInArr(chunks.subList(1, chunks.size()), elt.getAsJsonArray());
        }
        TreeLoc tl = new TreeLoc();
        tl.parrentArr = cur;
        tl.arrIndex = idx;
        tl.valueElt = elt;
        return tl;
    }

    public <T> T overrideObject(VariablesContext context, Object obj, Class<T> clazz) {
        JsonObject jsonObj = (JsonObject)JSON.parse((String)JSON.json((Object)obj), JsonObject.class);
        for (Override override : this.overrides) {
            String ret;
            TreeLoc tl = this.findRecInObj(this.chunkify(override.path), jsonObj);
            if (tl.valueElt.isJsonPrimitive() && tl.valueElt.getAsJsonPrimitive().isBoolean()) {
                if (tl.parentObj != null) {
                    tl.parentObj.addProperty(tl.objKey, context.getAsString(override.expr));
                    continue;
                }
                tl.parrentArr.set(tl.arrIndex, (JsonElement)new JsonPrimitive(context.getAsString(override.expr)));
                continue;
            }
            if (tl.valueElt.isJsonPrimitive() && tl.valueElt.getAsJsonPrimitive().isNumber()) {
                if (tl.parentObj != null) {
                    tl.parentObj.addProperty(tl.objKey, (Number)context.getAsInt(override.expr));
                    continue;
                }
                tl.parrentArr.set(tl.arrIndex, (JsonElement)new JsonPrimitive((Number)context.getAsInt(override.expr)));
                continue;
            }
            if (tl.valueElt.isJsonPrimitive()) {
                if (tl.parentObj != null) {
                    tl.parentObj.addProperty(tl.objKey, context.getAsString(override.expr));
                    continue;
                }
                tl.parrentArr.set(tl.arrIndex, (JsonElement)new JsonPrimitive(context.getAsString(override.expr)));
                continue;
            }
            if (tl.valueElt.isJsonArray()) {
                ret = context.getAsString(override.expr);
                JsonArray arr = (JsonArray)JSON.parse((String)ret, JsonArray.class);
                if (tl.parentObj != null) {
                    tl.parentObj.add(tl.objKey, (JsonElement)arr);
                    continue;
                }
                tl.parrentArr.set(tl.arrIndex, (JsonElement)arr);
                continue;
            }
            if (tl.valueElt.isJsonObject()) {
                ret = context.getAsString(override.expr);
                JsonObject newObj = (JsonObject)JSON.parse((String)ret, JsonObject.class);
                if (tl.parentObj != null) {
                    tl.parentObj.add(tl.objKey, (JsonElement)newObj);
                    continue;
                }
                tl.parrentArr.set(tl.arrIndex, (JsonElement)newObj);
                continue;
            }
            throw ErrorContext.iae((String)("Don't know how to override property '" + override.path + "' of type: " + String.valueOf(tl.valueElt.getClass())));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Expanded:" + jsonObj.toString()));
        }
        return (T)JSON.parse((String)jsonObj.toString(), clazz);
    }

    public static class Override {
        public String path;
        public String expr;
    }

    static class TreeLoc {
        JsonObject parentObj;
        JsonArray parrentArr;
        int arrIndex;
        String objKey;
        JsonElement valueElt;

        TreeLoc() {
        }
    }
}

