/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.backend;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.futures.IStateLabelAggregator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class NginxUtils {
    private static Logger logger = Logger.getLogger((String)"dip.nginx");

    public static void hupNginx() throws IOException, InterruptedException {
        File nginxPidFile = null;
        File rundevFile = new File(ApplicationConfigurator.getInstallFolder() + "/rundev/nginx/nginx.pid");
        nginxPidFile = rundevFile.isFile() ? rundevFile : ApplicationConfigurator.getFile((String)"run/nginx/nginx.pid");
        String nginxPid = DKUFileUtils.readFileToStringUTF8((File)nginxPidFile).trim();
        logger.info((Object)("HUPing nginx, pid=" + nginxPid));
        if (DKUtils.isOsWindows()) {
            DKUtils.execAndLogThrows((String[])new String[]{ApplicationConfigurator.getInstallFolder() + "/third-party/nginx/nginx.exe", "-s", "reload", "-c", ApplicationConfigurator.getBaseFolder() + "/install-support/nginx.conf"}, null, (File)null);
        } else {
            DKUtils.execAndLogThrows((String[])new String[]{"kill", "-HUP", nginxPid}, null, (File)null);
        }
    }

    public static void waitForHost(String host, IStateLabelAggregator stateLabelAggregator) throws InterruptedException, IOException {
        try (Closeable resolveState = stateLabelAggregator.startWaitingOn("Waiting on IP/hostname to resolve");){
            long timeout = ApplicationConfigurator.getParams().getLongParam("dip.webapp.exposition.host.resolution.timeout", 120000L);
            long waitResolveEnd = System.currentTimeMillis() + timeout;
            while (!NginxUtils.resolves(host) && System.currentTimeMillis() < waitResolveEnd) {
                Thread.sleep(3000L);
            }
            if (!NginxUtils.resolves(host)) {
                logger.warn((Object)("Host " + host + " still doesn't resolve, proceeding anyway"));
            }
        }
    }

    public static boolean resolves(String host) {
        try {
            InetAddress.getByName(host);
            return true;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

