/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.backend;

import com.dataiku.dip.autorestart.AutoRestartingProcessRunner;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.ExpositionRegistry;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureProgressStateSnapshot;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureServiceBase;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.futures.IStateLabelAggregator;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.futures.StateLabelAggregator;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.scheduler.runnables.StoppableWithTimeoutService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.WebAppRegistry;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInfra;
import com.dataiku.dip.webapps.backend.WebAppBackendRunner;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class WebAppBackendInstance
extends SimpleFutureThread<Void>
implements IStateLabelAggregator {
    private final WebAppBackend backend;
    private final WebApp webApp;
    public final JsonObject userVariables;
    private final WebAppMeta meta;
    private final String hash;
    public String instanceId;
    private FutureProgressState state;
    private WebAppBackendRunner runner;
    private volatile boolean abortLoop;
    private volatile boolean hasExposedEndpoint;
    private AutoRestartingProcessRunner.BackendStartFailedException startFailedException;
    private int crashCount;
    private SmartLogTail lastCrashLogTail;
    private StoppableWithTimeoutService stoppableWithTimeoutService;
    private IStateLabelAggregator stateLabelAggregator = new StateLabelAggregator();
    private GeneralSettingsDAO generalSettingsDAO;
    private static Logger logger = Logger.getLogger((String)"dip.webapp.backend.instance");

    public WebAppBackendInstance(AuthCtx authCtx, WebApp webApp, JsonObject userVariables, WebAppBackend backend) {
        super(authCtx);
        this.backend = backend;
        Preconditions.checkNotNull((Object)webApp);
        Preconditions.checkNotNull((Object)webApp.type);
        this.webApp = webApp;
        this.userVariables = userVariables;
        this.meta = WebAppRegistry.getMeta(webApp.type);
        this.hash = this.computeHash();
        this.stoppableWithTimeoutService = (StoppableWithTimeoutService)SpringUtils.getBean(StoppableWithTimeoutService.class);
        this.generalSettingsDAO = (GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class);
    }

    public String getPayloadForStartDoneMessage() {
        return "webapp:" + this.webApp.getFullId();
    }

    public Closeable startWaitingOn(String chunk) {
        return this.stateLabelAggregator.startWaitingOn(chunk);
    }

    public synchronized String makeStateLabel() {
        return this.stateLabelAggregator.makeStateLabel();
    }

    public long getReadinessProbeTimeoutMilliseconds() {
        if (this.webApp.params.readinessProbeTimeoutSeconds != null) {
            logger.debug((Object)("Use the readiness probe timeout in seconds = " + this.webApp.params.readinessProbeTimeoutSeconds + " from the webapp instance settings"));
            return (long)this.webApp.params.readinessProbeTimeoutSeconds.intValue() * 1000L;
        }
        try {
            GeneralSettingsDAO.WebappsSettings webappsSettings = this.generalSettingsDAO.getUnsafeAutoTXN().webappsSettings;
            if (webappsSettings.readinessProbeTimeoutSeconds != null) {
                logger.debug((Object)("Use the readiness probe timeout in seconds = " + webappsSettings.readinessProbeTimeoutSeconds + " from the webapp general settings"));
                return (long)webappsSettings.readinessProbeTimeoutSeconds.intValue() * 1000L;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to read the webapp general settings", (Throwable)e);
        }
        if (this.webApp.params.infra != null) {
            try {
                WebAppBackendInfra infra = this.webApp.params.infra;
                ContainerExecRuntimeConfig containerConfig = new ContainerExecConfigSelector().select_autoTXN(this.owner, this.webApp.getProjectKey(), infra.containerSelection);
                Exposition exposition = infra.getEffectiveExposition(this.owner, this.webApp.getProjectKey(), containerConfig);
                long expositionTimeout = ExpositionRegistry.getMeta(exposition).getMaxStartWait(this.owner);
                if (containerConfig != null && containerConfig.type == ContainerExecRuntimeConfig.Container.KUBERNETES) {
                    return Math.max(120000L, expositionTimeout);
                }
                return expositionTimeout;
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to inspect webapp backend setup to infer the readiness probe timeout in seconds", (Throwable)e);
            }
        }
        return 0L;
    }

    public void setHasExposedEndpoint(boolean hasExposedEndpoint) {
        this.hasExposedEndpoint = hasExposedEndpoint;
    }

    public String getHash() {
        return this.hash;
    }

    private String computeHash() {
        String apiKey = this.webApp.apiKey;
        if (apiKey != null) {
            PasswordEncryptionService passwordEncryptionService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
            apiKey = passwordEncryptionService.decryptIfEncrypted(apiKey);
        }
        ArrayList elements = Lists.newArrayList((Object[])new Object[]{this.owner, this.userVariables, this.webApp.config, apiKey, this.webApp.params.infra});
        elements.addAll(this.meta.getHashElements(this.webApp));
        ArrayList hashed = Lists.newArrayList();
        for (Object element : elements) {
            if (element == null) {
                hashed.add("");
                continue;
            }
            if (element instanceof String) {
                String stringElement = (String)element;
                hashed.add(stringElement);
                continue;
            }
            hashed.add(JSON.json(element));
        }
        return DKUtils.md5Base64((String)Joiner.on((String)"-").join((Iterable)hashed));
    }

    public FutureProgressStateSnapshot getProgressSnapshot() {
        Pair<Long, Long> info;
        if (this.state != null && (info = this.stoppableWithTimeoutService.getElapsedTime("webApp:" + this.webApp.getFullId())) != null) {
            long elapsed = Math.max(0L, Math.min((Long)info.second, (Long)info.first));
            try {
                this.state.set((double)elapsed);
            }
            catch (InterruptedException e) {
                logger.warn((Object)"Failed to update elapsed time in virtual webapp");
            }
        }
        return super.getProgressSnapshot();
    }

    @Override
    protected Void compute() throws Exception {
        logger.info((Object)("Start backend (re)start MainLoop (virtual=" + this.webApp.isVirtual + ")"));
        ComputeResourceUsageContext cruContext = ComputeResourceUsageContext.forWebappBackend((AuthCtx)this.owner, (String)this.webApp.projectKey, (String)this.webApp.id);
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)cruContext);
        try (FutureAborter.AutoCloseableAbortHook hook = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

            @Override
            public void run() {
                logger.info((Object)"MainLoopThread future abort hook - stopping the runner");
                WebAppBackendInstance.this.stopNoWait();
            }
        });){
            if (this.webApp.isVirtual) {
                this.state = FutureProgress.pushState((String)("Running " + this.webApp.getFullId()), (double)(WebAppsService.getVirtualAliveMins() * 60.0f * 1000.0f), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
            }
            while (!this.abortLoop && !this.isAborted()) {
                try {
                    logger.info((Object)("Build runner of type " + this.webApp.type));
                    this.runner = WebAppRegistry.getMeta(this.webApp.type).buildRunner(this.webApp, this.backend, this.userVariables, this.owner, this);
                    assert (this.runner != null);
                    logger.info((Object)("Running runner: " + String.valueOf(this.runner)));
                    this.runner.run();
                    logger.info((Object)"Runner terminated without exception");
                }
                catch (AutoRestartingProcessRunner.BackendStartFailedException e) {
                    logger.error((Object)"Backend start failed, aborting restart loop", (Throwable)e);
                    this.startFailedException = e;
                    ++this.crashCount;
                    this.lastCrashLogTail = this.runner.getLogTail();
                    logger.warn((Object)("Recorded crash log: " + JSON.pretty((Object)this.lastCrashLogTail)));
                    throw e;
                }
                catch (AutoRestartingProcessRunner.BackendDiedException e) {
                    if (!this.abortLoop && !this.isAborted()) {
                        logger.error((Object)"Backend died, restarting it", (Throwable)e);
                        ++this.crashCount;
                        this.lastCrashLogTail = this.runner.getLogTail();
                        logger.warn((Object)("Recorded crash log: " + JSON.pretty((Object)this.lastCrashLogTail)));
                    } else {
                        logger.info((Object)"Backend died, was aborted", (Throwable)e);
                    }
                }
                catch (Throwable e) {
                    logger.error((Object)"Unexpected exception during backend start failed, aborting restart loop", e);
                    this.startFailedException = new AutoRestartingProcessRunner.BackendStartFailedException("Unexpected exception", e, this.runner.getLogTail());
                    ++this.crashCount;
                    this.lastCrashLogTail = this.runner.getLogTail();
                    logger.warn((Object)("Recorded crash log: " + JSON.pretty((Object)this.lastCrashLogTail)));
                    throw e;
                }
                finally {
                    this.runner = null;
                }
                logger.info((Object)("Runner terminated abortLoop=" + this.abortLoop));
            }
            if (this.state != null) {
                FutureProgress.popState();
            }
            Void void_ = null;
            return void_;
        }
    }

    public FuturePayload getPayload() {
        FuturePayload fp = new FuturePayload();
        fp.displayName = "Backend for " + (this.webApp.id.startsWith("TENSORBOARD") ? "Tensorboard" : "Web app");
        fp.extras = new HashMap();
        if (this.runner != null) {
            fp.extras.put("pid", this.runner.getPid());
        }
        fp.extras.put("crashCount", this.crashCount);
        fp.targets.add(new FuturePayload.FuturePayloadTarget(this.webApp.projectKey, this.webApp.id, this.webApp.name, ITaggingService.TaggableType.WEB_APP.name()));
        return fp;
    }

    void stopNoWait() {
        logger.info((Object)("Stopping backend for webapp " + this.webApp.projectKey + "." + this.webApp.id));
        this.abortLoop = true;
        if (this.runner != null) {
            logger.info((Object)"Stopping webapp backend runner");
            this.runner.stop();
            logger.info((Object)"Webapp backend runner stopped");
        }
    }

    public void stopAndWait() throws InterruptedException {
        this.stopNoWait();
        logger.info((Object)"Waiting for webapp backend to effectively stop");
        this.join();
    }

    public void stopDanglingRun() throws Exception {
        this.runner = WebAppRegistry.getMeta(this.webApp.type).buildRunner(this.webApp, this.backend, this.userVariables, this.owner, this);
        logger.info((Object)("Cleanup with runner: " + String.valueOf(this.runner)));
        this.runner.stopDanglingRun();
    }

    public void checkStartFailure() throws AutoRestartingProcessRunner.BackendStartFailedException {
        if (this.startFailedException != null) {
            throw this.startFailedException;
        }
    }

    public BackendState getBackendState(boolean keepFutureId) throws IOException {
        BackendState ret = new BackendState(this.webApp);
        ret.futureId = this.jobId;
        ret.futureInfo = ((FutureServiceBase)SpringUtils.getBean(FutureServiceBase.class)).getProgress((FutureThreadBase)this);
        if (!keepFutureId) {
            ret.futureId = null;
            if (ret.futureInfo != null) {
                ret.futureInfo.jobId = null;
            }
        }
        if (this.runner != null) {
            ret.currentLogTail = this.runner.getLogTail();
        }
        ret.hasExposedEndpoint = this.hasExposedEndpoint;
        ret.lastCrashLogTail = this.lastCrashLogTail;
        return ret;
    }

    public boolean isRunning() {
        return this.runner != null;
    }

    public String getLivelinessPath() {
        WebAppBackendRunner current = this.runner;
        return current == null ? "" : current.getLivelinessPath();
    }

    public static class BackendState {
        public final String projectKey;
        public final String webAppId;
        public String futureId;
        public FutureResponse<?> futureInfo;
        public SmartLogTail currentLogTail;
        public SmartLogTail lastCrashLogTail;
        public boolean hasExposedEndpoint;
        public ExposedEndpointConsumer.ExposedEndpoint exposed;

        public BackendState(WebApp webApp) {
            this.projectKey = webApp.projectKey;
            this.webAppId = webApp.id;
        }
    }
}

