/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.shiny;

import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.shiny.AbstractShinyWebAppHandler;
import java.io.IOException;

public class ShinyWebAppHandler
extends AbstractShinyWebAppHandler {
    protected RelFile directory;

    public ShinyWebAppHandler(WebApp webapp) {
        super(webapp);
        this.directory = new RelFile(new String[]{"projects", webapp.projectKey, "web_apps", webapp.id});
    }

    @Override
    public void readCodeFiles() {
        try {
            TransactionRef t = TransactionContext.retrieveRead();
            if (t.exists(this.getUiFile())) {
                this.params.ui = t.readStringUTF8(this.getUiFile());
            } else {
                logger.info((Object)("File does not exist: " + this.getUiFile().getFullPath()));
            }
            if (t.exists(this.getServerFile())) {
                this.params.server = t.readStringUTF8(this.getServerFile());
            } else {
                logger.info((Object)("File does not exist: " + this.getServerFile().getFullPath()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read web app.", e);
        }
    }

    @Override
    public void writeCodeFiles() throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeStringUTF8(this.getUiFile(), this.params.ui);
        t.writeStringUTF8(this.getServerFile(), this.params.server);
    }

    @Override
    public void deleteCodeFiles() throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.deleteDirectory(this.directory);
    }

    @Override
    public void initCustomWebApp() throws IOException {
    }

    private RelFile getServerFile() {
        return this.directory.append(new String[]{"server.R"});
    }

    private RelFile getUiFile() {
        return this.directory.append(new String[]{"ui.R"});
    }
}

