/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.wikis;

import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.timelines.EnrichmentService;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@UIModel
public class Article
extends TaggableObjectsService.TaggableObject {
    @JSON.FileTransient
    public String projectKey;
    @JSON.FileTransient
    public String id;
    public String name;
    public ArticleLayout layout;
    public List<ArticleAttachment> attachments = new ArrayList<ArticleAttachment>();

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.ARTICLE;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public static class ArticleSummary
    extends TaggableObjectsService.TaggableObjectSummary {
        public String payload;
        public long lastModifiedOn;
        public PublicUser lastModifiedBy;
        public long createdOn;
        public PublicUser createdBy;
    }

    public static enum ArticleAttachmentType {
        DSS_OBJECT,
        FILE;

    }

    public static class ArticleAttachment
    implements EnrichmentService.EnrichableSmartId {
        public ArticleAttachmentType attachmentType;
        public ITaggingService.TaggableType taggableType;
        public String smartId;
        public String description;
        public JsonObject details = new JsonObject();
        public String attachedBy;
        public long attachedOn;

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return this.taggableType;
        }

        @Override
        public String getObjectSmartId() {
            return this.smartId;
        }

        @Override
        public String getUserLogin() {
            return this.attachedBy;
        }

        @Override
        public JsonObject getDetails() {
            return this.details;
        }

        @Nullable
        public String getFileDisplayName() {
            JsonElement displayName = this.details.get("objectDisplayName");
            return displayName == null ? null : displayName.getAsString();
        }
    }

    public static enum ArticleLayout {
        WIKI_ARTICLE,
        FOLDER;

    }
}

