/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.geoip.mmdb;

import com.dataiku.geoip.mmdb.Decoder;
import com.dataiku.geoip.mmdb.InvalidDatabaseException;
import com.dataiku.geoip.mmdb.Metadata;
import com.dataiku.geoip.mmdb.ThreadBuffer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.apache.commons.lang.mutable.MutableInt;

public final class Reader
implements Closeable {
    private static final int DATA_SECTION_SEPARATOR_SIZE = 16;
    private static final byte[] METADATA_START_MARKER = new byte[]{-85, -51, -17, 77, 97, 120, 77, 105, 110, 100, 46, 99, 111, 109};
    private int ipV4Start;
    private final Decoder decoder;
    private final Metadata metadata;
    private final ThreadBuffer threadBuffer;

    public Reader(File database) throws IOException {
        this(database, FileMode.MEMORY_MAPPED);
    }

    public Reader(File database, FileMode fileMode) throws IOException {
        this.threadBuffer = new ThreadBuffer(database, fileMode);
        int start = this.findMetadataStart(database.getName());
        Decoder metadataDecoder = new Decoder(this.threadBuffer, start);
        this.metadata = new Metadata(metadataDecoder.decode(start).getNode());
        this.decoder = new Decoder(this.threadBuffer, this.metadata.searchTreeSize + 16);
    }

    public JsonNode get(InetAddress ipAddress) throws IOException {
        int pointer = this.findAddressInTree(ipAddress);
        if (pointer == 0) {
            return null;
        }
        return this.resolveDataPointer(pointer);
    }

    public void visit(int bitLength, IpVisitor ipVisitor) {
        try {
            MutableInt previousRecord = new MutableInt(-1);
            int record = this.startNode(bitLength);
            this.visitorHelper(record, 0, 0, new byte[bitLength / 8], ipVisitor, previousRecord);
            this.visitorHelper(record, 1, 0, new byte[bitLength / 8], ipVisitor, previousRecord);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read MaxMind database", e);
        }
    }

    private void visitorHelper(int record, int bit, int depth, byte[] ip, IpVisitor visitor, MutableInt previousRecord) throws Exception {
        record = this.readNode(record, bit);
        int n = depth / 8;
        ip[n] = (byte)(ip[n] | bit << 7 - depth % 8);
        if (record < this.metadata.nodeCount) {
            this.visitorHelper(record, 0, depth + 1, ip, visitor, previousRecord);
            this.visitorHelper(record, 1, depth + 1, ip, visitor, previousRecord);
        } else {
            if (record != previousRecord.intValue()) {
                InetAddress a = InetAddress.getByAddress(ip);
                visitor.visit(a);
            }
            previousRecord.setValue(record);
        }
        int n2 = depth / 8;
        ip[n2] = (byte)(ip[n2] & ~(bit << 7 - depth % 8));
    }

    private int findAddressInTree(InetAddress address) throws InvalidDatabaseException {
        byte[] rawAddress = address.getAddress();
        int bitLength = rawAddress.length * 8;
        int record = this.startNode(bitLength);
        for (int i = 0; i < bitLength && record < this.metadata.nodeCount; ++i) {
            int b = 0xFF & rawAddress[i / 8];
            int bit = 1 & b >> 7 - i % 8;
            record = this.readNode(record, bit);
        }
        if (record == this.metadata.nodeCount) {
            return 0;
        }
        if (record > this.metadata.nodeCount) {
            return record;
        }
        throw new InvalidDatabaseException("Something bad happened");
    }

    private int startNode(int bitLength) throws InvalidDatabaseException {
        if (this.metadata.ipVersion == 6 && bitLength == 32) {
            return this.ipV4StartNode();
        }
        return 0;
    }

    private int ipV4StartNode() throws InvalidDatabaseException {
        if (this.metadata.ipVersion == 4) {
            return 0;
        }
        if (this.ipV4Start != 0) {
            return this.ipV4Start;
        }
        int node = 0;
        for (int i = 0; i < 96 && node < this.metadata.nodeCount; ++i) {
            node = this.readNode(node, 0);
        }
        this.ipV4Start = node;
        return node;
    }

    private int readNode(int nodeNumber, int index) throws InvalidDatabaseException {
        ByteBuffer buffer = (ByteBuffer)this.threadBuffer.get();
        int baseOffset = nodeNumber * this.metadata.nodeByteSize;
        switch (this.metadata.recordSize) {
            case 24: {
                buffer.position(baseOffset + index * 3);
                return Decoder.decodeInteger(buffer, 0, 3);
            }
            case 28: {
                int middle = buffer.get(baseOffset + 3);
                middle = index == 0 ? (0xF0 & middle) >>> 4 : 0xF & middle;
                buffer.position(baseOffset + index * 4);
                return Decoder.decodeInteger(buffer, middle, 3);
            }
            case 32: {
                buffer.position(baseOffset + index * 4);
                return Decoder.decodeInteger(buffer, 0, 4);
            }
        }
        throw new InvalidDatabaseException("Unknown record size: " + this.metadata.recordSize);
    }

    private JsonNode resolveDataPointer(int pointer) throws IOException {
        int resolved = pointer - this.metadata.nodeCount + this.metadata.searchTreeSize;
        if (resolved >= ((ByteBuffer)this.threadBuffer.get()).capacity()) {
            throw new InvalidDatabaseException("The MaxMind DB file's search tree is corrupt: contains pointer larger than the database.");
        }
        return this.decoder.decode(resolved).getNode();
    }

    private int findMetadataStart(String databaseName) throws InvalidDatabaseException {
        ByteBuffer buffer = (ByteBuffer)this.threadBuffer.get();
        int fileSize = buffer.capacity();
        block0: for (int i = 0; i < fileSize - METADATA_START_MARKER.length + 1; ++i) {
            for (int j = 0; j < METADATA_START_MARKER.length; ++j) {
                byte b = buffer.get(fileSize - i - j - 1);
                if (b != METADATA_START_MARKER[METADATA_START_MARKER.length - j - 1]) continue block0;
            }
            return fileSize - i;
        }
        throw new InvalidDatabaseException("Could not find a MaxMind DB metadata marker in this file (" + databaseName + "). Is this a valid MaxMind DB file?");
    }

    Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void close() throws IOException {
        this.threadBuffer.close();
    }

    public static enum FileMode {
        MEMORY_MAPPED,
        MEMORY;

    }

    public static interface IpVisitor {
        public void visit(InetAddress var1) throws Exception;
    }
}

