/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import java.util.Properties;

public class Format
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        Object formatString;
        if (args.length >= 2 && (formatString = args[0]) != null) {
            String format = formatString instanceof String ? (String)formatString : formatString.toString();
            Object[] formatArgs = new Object[args.length - 1];
            System.arraycopy(args, 1, formatArgs, 0, args.length - 1);
            return String.format(format, formatArgs);
        }
        return null;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Format.DOCUMENTATION", "Formats a string using printf-like formatting using the <a href=\"https://docs.oracle.com/javase/7/docs/api/java/util/Formatter.html#summary\" target=\"dss_formula\">Java Formatter syntax</a>.").withParams("string format, object param1 ...").withReturns("boolean").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("\"%4d-%02d\"", "2004", "2").returns("\"2004-02\""));
    }
}

