/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class NGram
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 2) {
            Object s = args[0];
            Object n = args[1];
            if (s instanceof String && n instanceof Number) {
                String[] tokens = StringUtils.split((String)((String)s));
                int count = ((Number)n).intValue();
                if (count >= tokens.length) {
                    return new String[]{(String)s};
                }
                int len = tokens.length - count + 1;
                String[] ngrams = new String[len];
                for (int i = 0; i < len; ++i) {
                    Object[] ss = new String[count];
                    if (count >= 0) {
                        System.arraycopy(tokens, i, ss, 0, count);
                    }
                    ngrams[i] = StringUtils.join((Object[])ss, (char)' ');
                }
                return ngrams;
            }
            return null;
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects a string and a number");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.NGram.DOCUMENTATION", "Returns an array of the word ngrams of given length in a string.").withParams("string s", "number n").withReturns("array").withCategory("GREL.FUNCTIONS.CATEGORY.ARRAY", "Array functions").withExample(Example.with("\"the crazy brown fox\"", "2").returns("[\"the crazy\", \"crazy brown\", \"brown fox\"]"));
    }
}

