/*
 * Decompiled with CFR 0.152.
 */
package com.tlarsendataguy.yxdb;

import com.tlarsendataguy.yxdb.Lzf;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class BufferedRecordReader {
    static int lzfBufferSize = 262144;
    final InputStream stream;
    final int fixedLen;
    final boolean hasVarFields;
    final long totalRecords;
    final ByteBuffer lzfIn;
    final ByteBuffer lzfOut;
    int lzfOutIndex;
    int lzfOutSize;
    final Lzf lzf;
    final ByteBuffer lzfLengthBuffer;
    ByteBuffer recordBuffer;
    int recordBufferIndex;
    long currentRecord;

    public BufferedRecordReader(InputStream stream, int fixedLen, boolean hasVarFields, long totalRecords) {
        this.totalRecords = totalRecords;
        this.stream = stream;
        this.fixedLen = fixedLen;
        this.hasVarFields = hasVarFields;
        this.recordBuffer = hasVarFields ? ByteBuffer.allocate(fixedLen + 4 + 1000).order(ByteOrder.LITTLE_ENDIAN) : ByteBuffer.allocate(fixedLen).order(ByteOrder.LITTLE_ENDIAN);
        this.lzfIn = ByteBuffer.allocate(lzfBufferSize).order(ByteOrder.LITTLE_ENDIAN);
        this.lzfOut = ByteBuffer.allocate(lzfBufferSize).order(ByteOrder.LITTLE_ENDIAN);
        this.lzf = new Lzf(this.lzfIn.array(), this.lzfOut.array());
        this.lzfLengthBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
    }

    public boolean nextRecord() throws IOException {
        ++this.currentRecord;
        if (this.currentRecord > this.totalRecords) {
            this.stream.close();
            return false;
        }
        this.recordBufferIndex = 0;
        if (this.hasVarFields) {
            this.readVariableRecord();
        } else {
            this.read(this.fixedLen);
        }
        return true;
    }

    private void readVariableRecord() throws IOException {
        this.read(this.fixedLen + 4);
        int varLength = this.recordBuffer.getInt(this.recordBufferIndex - 4);
        if (this.fixedLen + 4 + varLength > this.recordBuffer.capacity()) {
            int newLength = (this.fixedLen + 4 + varLength) * 2;
            ByteBuffer newBuffer = ByteBuffer.allocate(newLength).order(ByteOrder.LITTLE_ENDIAN);
            System.arraycopy(this.recordBuffer.array(), 0, newBuffer.array(), 0, this.fixedLen + 4);
            this.recordBuffer = newBuffer;
        }
        this.read(varLength);
    }

    private void read(int size) throws IOException {
        while (size > 0) {
            if (this.lzfOutSize == 0) {
                this.lzfOutSize = this.readNextLzfBlock();
            }
            while (size + this.lzfOutIndex > this.lzfOutSize) {
                size -= this.copyRemainingLzfOutToRecord();
                this.lzfOutSize = this.readNextLzfBlock();
                this.lzfOutIndex = 0;
            }
            int lenToCopy = Math.min(this.lzfOutSize, size);
            System.arraycopy(this.lzfOut.array(), this.lzfOutIndex, this.recordBuffer.array(), this.recordBufferIndex, lenToCopy);
            this.lzfOutIndex += lenToCopy;
            this.recordBufferIndex += lenToCopy;
            size -= lenToCopy;
        }
    }

    private int copyRemainingLzfOutToRecord() {
        int remainingLzf = this.lzfOutSize - this.lzfOutIndex;
        System.arraycopy(this.lzfOut.array(), this.lzfOutIndex, this.recordBuffer.array(), this.recordBufferIndex, remainingLzf);
        this.recordBufferIndex += remainingLzf;
        return remainingLzf;
    }

    private int readNextLzfBlock() throws IOException {
        int lzfBlockLength = this.readLzfBlockLength();
        long checkbit = (long)lzfBlockLength & 0x80000000L;
        if (checkbit > 0L) {
            return this.stream.readNBytes(this.lzfOut.array(), 0, lzfBlockLength &= 0x7FFFFFF);
        }
        int readIn = this.stream.readNBytes(this.lzfIn.array(), 0, lzfBlockLength);
        return this.lzf.decompress(readIn);
    }

    private int readLzfBlockLength() throws IOException {
        int read = this.stream.readNBytes(this.lzfLengthBuffer.array(), 0, 4);
        if (read < 4) {
            throw new IOException("yxdb file is not valid");
        }
        return this.lzfLengthBuffer.getInt(0);
    }
}

