/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.endpoints.custompredict;

import com.codahale.metrics.Timer;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.lambda.endpoints.predict.SQLLeftJoinEnrichStep;
import com.dataiku.lambda.endpoints.predictcommon.PipelineMessage;
import com.dataiku.lambda.endpoints.predictcommon.PoolablePipelineWithEnrich;
import com.dataiku.lambda.endpoints.predictcommon.PredictionEndpointHandlerBase;
import com.dataiku.lambda.model.api.PredictionResponse;
import com.dataiku.lambda.model.serverconfig.PredictionEndpointConfigBase;
import com.google.gson.JsonObject;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class CustomCodePredictionEndpointHandler<PEC extends PredictionEndpointConfigBase, PP extends PoolablePipelineWithEnrich>
extends PredictionEndpointHandlerBase<PEC, PP> {
    private static Logger logger = Logger.getLogger((String)"dku.lambda.custPredEPH");

    public CustomCodePredictionEndpointHandler(PEC config) {
        super(config);
    }

    @Override
    public abstract PP instantiatePipeline() throws Exception;

    protected abstract PredictionResponse predictStep(PP var1, PipelineMessage var2) throws Exception;

    @Override
    protected PredictionEndpointHandlerBase.EnrichedPredictionResponse predict(long startTimeN, PipelineMessage pm) throws Exception {
        this.requestsMeter.mark();
        long preprocessedN = System.nanoTime();
        logger.info((Object)("Predict on CPEH" + this.loggerSuffix));
        PoolablePipelineWithEnrich pipeline = (PoolablePipelineWithEnrich)this.pool.acquire();
        try {
            PredictionResponse ret;
            long acquiredN = System.nanoTime();
            try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((Timer)this.enrichTimer);){
                for (SQLLeftJoinEnrichStep step : pipeline.sqlEnrich) {
                    step.process(pm);
                }
            }
            List<JsonObject> postEnrich = this.collectPostEnrichDataIfNeeded(pm, ((PredictionEndpointConfigBase)this.config).auditPostEnrichData, ((PredictionEndpointConfigBase)this.config).returnPostEnrichData);
            long enrichedN = System.nanoTime();
            try (DSSMetrics.TimeCtx tctx = DSSMetrics.timeCtx((Timer)this.predictTimer);){
                ret = this.predictStep(pipeline, pm);
            }
            long predictedN = System.nanoTime();
            this.pool.release(pipeline);
            long finishedN = System.nanoTime();
            ret.timing.preProcessing = (preprocessedN - startTimeN) / 1000L;
            ret.timing.wait = (acquiredN - preprocessedN) / 1000L;
            ret.timing.enrich = (enrichedN - acquiredN) / 1000L;
            ret.timing.prediction = (predictedN - enrichedN) / 1000L;
            ret.timing.postProcessing = (finishedN - predictedN) / 1000L;
            this.enrichPredictionResponseWithPostEnrichData(ret, postEnrich, ((PredictionEndpointConfigBase)this.config).auditPostEnrichData, ((PredictionEndpointConfigBase)this.config).returnPostEnrichData);
            PredictionEndpointHandlerBase.EnrichedPredictionResponse epr = new PredictionEndpointHandlerBase.EnrichedPredictionResponse();
            this.successRequestMeter.mark();
            epr.response = ret;
            return epr;
        }
        catch (Throwable t) {
            this.pool.destroyOnError(pipeline);
            throw t;
        }
    }
}

