/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.health;

import com.codahale.metrics.health.HealthCheck;
import com.dataiku.lambda.health.PredictionEndpointHealthCheck;
import com.dataiku.lambda.model.api.SinglePredictionQuery;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServiceConfig;
import com.dataiku.lambda.model.serverconfig.PredictionEndpointConfigBase;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class HealthChecksBuilder {
    public static Map<String, HealthCheck> buildForService(String serviceId, LambdaServiceConfig serviceConfig) {
        HashMap<String, HealthCheck> ret = new HashMap<String, HealthCheck>();
        for (LambdaEndpointConfig lec : serviceConfig.endpoints) {
            if (!EnumSet.of(LambdaEndpointConfig.EndpointType.STD_PREDICTION, new LambdaEndpointConfig.EndpointType[]{LambdaEndpointConfig.EndpointType.STD_FORECAST, LambdaEndpointConfig.EndpointType.STD_CAUSAL_PREDICTION, LambdaEndpointConfig.EndpointType.CUSTOM_PREDICTION, LambdaEndpointConfig.EndpointType.CUSTOM_R_PREDICTION, LambdaEndpointConfig.EndpointType.STD_CLUSTERING}).contains(lec.type)) continue;
            PredictionEndpointConfigBase epConfig = (PredictionEndpointConfigBase)lec;
            int i = 0;
            for (SinglePredictionQuery spq : epConfig.healthCheckQueries) {
                ret.put(epConfig.id + "-" + i++, new PredictionEndpointHealthCheck(serviceId, epConfig.id, spq));
            }
        }
        return ret;
    }
}

