/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.monitoring;

import com.dataiku.common.rpc.APIKeyAuthAPIClient;
import com.dataiku.dip.maintainance.InterruptAndPrintStackTraceAfterTimeoutTask;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.lambda.StdLambdaContext;
import com.dataiku.lambda.model.serverconfig.ActivityMonitoringSettings;
import com.dataiku.lambda.monitoring.ActivityMonitoringService;
import java.io.IOException;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class SendActivityTask
extends InterruptAndPrintStackTraceAfterTimeoutTask {
    @Autowired
    private ActivityMonitoringService activityMonitoringService;
    @Autowired
    private StdLambdaContext context;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.monitoring");

    public SendActivityTask() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void executeWithTimeout(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            this.sendActivityToDeployer();
        }
        catch (IOException e) {
            throw new JobExecutionException((Throwable)e);
        }
    }

    public void sendActivityToDeployer() throws IOException {
        if (!(this.context.getMandatoryConfig().activityMonitoringSettings instanceof ActivityMonitoringSettings.PushExplicit)) {
            return;
        }
        ActivityMonitoringSettings.PushExplicit config = (ActivityMonitoringSettings.PushExplicit)this.context.getMandatoryConfig().activityMonitoringSettings;
        String graphitePayload = this.activityMonitoringService.getActivityMetricsInGraphiteRawFormat();
        logger.info((Object)("Sending activity metrics to deployer listening at " + config.activityServerAPIURL));
        try (APIKeyAuthAPIClient httpClient = new APIKeyAuthAPIClient(config.activityServerAPIURL, this.passwordEncryptionService.decryptIfEncrypted(config.apiKey), config.trustAllSSLCertificates);){
            String resp = httpClient.postFormToStringV("", new Object[]{"graphitePayload", graphitePayload});
            logger.info((Object)resp);
        }
        catch (Exception e) {
            throw new IOException("Failed to send activity metrics", e);
        }
    }
}

