/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugin;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public interface ExecutionContext {
    public String getRecipeName();

    public File getTempFolder(String var1) throws IOException;

    public List<InputInfo> getInputs() throws IOException;

    public List<OutputInfo> getOutputs() throws IOException;

    public List<InputInfo> getInputsForRole(String var1) throws IOException;

    public List<OutputInfo> getOutputsForRole(String var1) throws IOException;

    public void runSQLInConnection(String var1, InputOutputInfo var2) throws SQLException, IOException, DKUSecurityException, InterruptedException;

    public static interface InputInfo
    extends InputOutputInfo {
        public Schema getSchema();

        public List<Partition> getPartitions();

        public void pullFromDataset(ProcessorOutput var1, ColumnFactory var2, RowFactory var3) throws Exception;
    }

    public static interface OutputInfo
    extends InputOutputInfo {
        public void setSchema(Schema var1) throws Exception;

        public void clear() throws Exception;

        public Partition getPartition();

        public Output.WriteMode getWriteMode();

        public OutputWriter pushToDataset() throws Exception;
    }

    public static interface InputOutputInfo {
        public String getRole();

        public String getProjectKey();

        public String getId();

        public boolean isDataset();

        public boolean isFolder();

        public boolean isModel();

        public PartitioningScheme getPartitioningScheme();

        public boolean hasFSProvider();

        public FSProvider getFSProvider() throws IOException, Exception;

        public String getSingleFileInFSProvider();

        public boolean isSQLLike();

        public SQLLikeTableLocation getSQLInfo() throws IOException, SQLException, DKUSecurityException;
    }

    public static interface SQLLikeTableLocation {
        default public String getCatalog() {
            return null;
        }

        public String getSchema();

        public String getTable();
    }
}

